/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.types.annotations;

import com.google.inject.Singleton;
import com.yakindu.base.types.AnnotatableElement;
import com.yakindu.base.types.Annotation;
import com.yakindu.base.types.AnnotationType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.TypesFactory;

@Singleton
public class TypeAnnotations {
    private static final String INDEX_OPERATION = "_index_operation_";
    private static final String BUILT_IN_TYPE = "_builtin_type_";
    private static final String EXTERNAL_TYPE = "_external_type_";
    private static final String VALUE_TYPE = "_value_type_";
    private static final String REFERENCE_TYPE = "_reference_type_";
    private static AnnotationType valueTypeAnnotationType = TypesFactory.eINSTANCE.createAnnotationType();
    private static AnnotationType referenceTypeAnnotationType;

    static {
        valueTypeAnnotationType.setName(VALUE_TYPE);
        referenceTypeAnnotationType = TypesFactory.eINSTANCE.createAnnotationType();
        referenceTypeAnnotationType.setName(REFERENCE_TYPE);
    }

    public AnnotationType createBuiltInTypeAnnotationType() {
        AnnotationType builtInAnnotation = TypesFactory.eINSTANCE.createAnnotationType();
        builtInAnnotation.setName(BUILT_IN_TYPE);
        return builtInAnnotation;
    }

    public boolean hasBuiltInTypeAnnotation(AnnotatableElement element) {
        return this.hasAnnotation(element, BUILT_IN_TYPE);
    }

    public AnnotationType createIndexOperationAnnotationType() {
        AnnotationType indexAnnotation = TypesFactory.eINSTANCE.createAnnotationType();
        indexAnnotation.setName(INDEX_OPERATION);
        return indexAnnotation;
    }

    public boolean hasIndexOperationAnnotation(AnnotatableElement element) {
        return this.hasAnnotation(element, INDEX_OPERATION);
    }

    public boolean hasAnnotation(AnnotatableElement element, String name) {
        return element.getAnnotationOfType(name) != null;
    }

    public boolean isExternalType(Declaration type) {
        if (type.getAllAnnotations() == null) {
            return false;
        }
        return type.getAnnotationOfType(EXTERNAL_TYPE) != null;
    }

    public AnnotationType createExternalAnnotationType() {
        AnnotationType indexAnnotation = TypesFactory.eINSTANCE.createAnnotationType();
        indexAnnotation.setName(EXTERNAL_TYPE);
        return indexAnnotation;
    }

    public boolean isValueType(AnnotatableElement type) {
        if (type.getAllAnnotations() == null) {
            return false;
        }
        return type.getAnnotationOfType(VALUE_TYPE) != null;
    }

    public void declareAsValueType(AnnotatableElement type) {
        if (!this.isValueType(type)) {
            Annotation annotation = TypesFactory.eINSTANCE.createAnnotation();
            annotation.setType(valueTypeAnnotationType);
            type.getAnnotations().add((Object)annotation);
        }
    }

    public boolean isReferenceTypeAnnotated(AnnotatableElement type) {
        if (type.getAllAnnotations() == null) {
            return false;
        }
        return type.getAnnotationOfType(REFERENCE_TYPE) != null;
    }

    public void annotateAsReferenceType(AnnotatableElement type) {
        if (!this.isValueType(type)) {
            Annotation annotation = TypesFactory.eINSTANCE.createAnnotation();
            annotation.setType(referenceTypeAnnotationType);
            type.getAnnotations().add((Object)annotation);
        }
    }
}

