/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.types.inferrer;

import com.yakindu.base.types.ArrayTypeSpecifier;
import com.yakindu.base.types.GenericElement;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.TypesFactory;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;

public interface ITypeSystemInferrer {
    public static final String EXCEPTION_CODE = "RuntimeException";
    public static final String NO_INFER_METHOD_CODE = "NoInferMethod";
    public static final String IS_TYPE_CODE = "NotExpectedType.";
    public static final String NOT_TYPE_CODE = "NotType";
    public static final String NOT_SAME_CODE = "NotSame";
    public static final String NOT_COMPATIBLE_CODE = "IncompatibleTypes";
    public static final String NOT_INFERRABLE_TYPE_PARAMETER_CODE = "NotInferrableTypeParameter";
    public static final String UNDEFINED_TYPE_CODE = "UndefinedType";

    public InferenceResult infer(EObject var1, IValidationIssueAcceptor var2);

    public InferenceResult infer(EObject var1);

    public static class InferenceResult {
        private Type type;
        private List<InferenceResult> bindings = new ArrayList<InferenceResult>();
        private Optional<Integer> arraySize;

        protected InferenceResult(Type type) {
            Assert.isNotNull((Object)type);
            this.type = type;
            this.arraySize = Optional.empty();
        }

        protected InferenceResult(Type type, List<InferenceResult> bindings) {
            Assert.isNotNull((Object)type);
            Assert.isNotNull(bindings);
            this.type = type;
            this.bindings.addAll(bindings);
            this.arraySize = Optional.empty();
        }

        protected InferenceResult(Type type, List<InferenceResult> bindings, int arraySize) {
            Assert.isNotNull((Object)type);
            Assert.isNotNull(bindings);
            this.type = type;
            this.bindings.addAll(bindings);
            this.arraySize = Optional.of(arraySize);
        }

        public static InferenceResult from(Type type) {
            return new InferenceResult(type);
        }

        public static InferenceResult from(Type type, List<InferenceResult> bindings) {
            return new InferenceResult(type, bindings);
        }

        public static InferenceResult from(Type type, List<InferenceResult> bindings, int arraySize) {
            return new InferenceResult(type, bindings, arraySize);
        }

        public Type getType() {
            return this.type;
        }

        public List<InferenceResult> getBindings() {
            return this.bindings;
        }

        public boolean isArray() {
            return this.arraySize != null && this.arraySize.isPresent();
        }

        public Optional<Integer> getArraySize() {
            return this.arraySize;
        }

        public TypeSpecifier asTypeSpecifier() {
            TypeSpecifier specifier = this.createTypeSpecifier();
            specifier.setType(this.getType());
            this.bindings.stream().forEach(b -> specifier.getTypeArguments().add((Object)b.asTypeSpecifier()));
            return specifier;
        }

        protected TypeSpecifier createTypeSpecifier() {
            if (this.isArray()) {
                ArrayTypeSpecifier arraySpecifier = TypesFactory.eINSTANCE.createArrayTypeSpecifier();
                arraySpecifier.setSize(this.getArraySize().orElse(0));
                return arraySpecifier;
            }
            return TypesFactory.eINSTANCE.createTypeSpecifier();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.type.toString());
            if (this.type instanceof GenericElement && !((GenericElement)((Object)this.type)).getTypeParameters().isEmpty()) {
                builder.append("<");
                String sep = "";
                for (InferenceResult type : this.bindings) {
                    builder.append(sep);
                    builder.append(type.toString());
                    sep = ", ";
                }
                builder.append(">");
            }
            return builder.toString();
        }
    }

    public static class NullImpl
    implements ITypeSystemInferrer {
        @Override
        public InferenceResult infer(EObject object, IValidationIssueAcceptor acceptor) {
            return null;
        }

        @Override
        public InferenceResult infer(EObject object) {
            return null;
        }
    }
}

