/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.types.typesystem;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.PrimitiveType;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeParameter;
import com.yakindu.base.types.TypesFactory;
import com.yakindu.base.types.annotations.TypeAnnotations;
import com.yakindu.base.types.typesystem.ITypeSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class AbstractTypeSystem
implements ITypeSystem {
    protected Map<String, Type> typeRegistry = new HashMap<String, Type>();
    protected ListMultimap<Type, Type> extendsRegistry = ArrayListMultimap.create();
    protected ListMultimap<Type, Operation> extensionOperationRegistry = ArrayListMultimap.create();
    protected ListMultimap<Type, Property> extensionPropertyRegistry = ArrayListMultimap.create();
    protected ListMultimap<Class<? extends Declaration>, Declaration> metaFeatureRegistry = ArrayListMultimap.create();
    protected Map<Type, Type> conversionRegistry = new HashMap<Type, Type>();
    protected Resource resource = new ResourceImpl(URI.createURI((String)"/types")){

        protected void doUnload() {
        }
    };
    protected TypeAnnotations typeAnnotations;

    protected abstract void initRegistries();

    public AbstractTypeSystem() {
        this.resource.eSetDeliver(false);
        this.typeAnnotations = new TypeAnnotations();
        this.initRegistries();
    }

    protected void reset() {
        this.typeRegistry.clear();
        this.extendsRegistry.clear();
        this.conversionRegistry.clear();
    }

    @Override
    public Type getType(String type) {
        Type result = this.typeRegistry.get(type);
        return result;
    }

    @Override
    public List<Type> getSuperTypes(Type type) {
        LinkedHashSet<Type> allSuperTypes = new LinkedHashSet<Type>();
        this.collectSupertypes(type, allSuperTypes);
        return Lists.newArrayList(allSuperTypes);
    }

    protected List<Type> getDirectSuperTypes(Type type) {
        TypeParameter typeParameter;
        Type bound;
        ArrayList<Type> superTypes = new ArrayList<Type>();
        for (Map.Entry entry : this.extendsRegistry.entries()) {
            if (!this.isSame(type, (Type)entry.getKey())) continue;
            superTypes.add((Type)entry.getValue());
        }
        List collect = type.getSuperTypes().stream().map(typeSpecifier -> typeSpecifier.getType()).collect(Collectors.toList());
        superTypes.addAll(collect);
        if (type instanceof TypeParameter && (bound = (typeParameter = (TypeParameter)type).getBound()) != null) {
            superTypes.add(bound);
        }
        return superTypes;
    }

    @Override
    public boolean isSuperType(Type subtype, Type supertype) {
        LinkedHashSet<Type> typehierachy = new LinkedHashSet<Type>();
        typehierachy.add(subtype);
        this.collectSupertypes(subtype, typehierachy);
        for (Type eObject : typehierachy) {
            if (!this.isSame(eObject, supertype)) continue;
            return true;
        }
        return false;
    }

    protected void collectSupertypes(Type subType, Set<Type> typeHierachy) {
        if (subType == null) {
            return;
        }
        List<Type> superTypes = this.getDirectSuperTypes(subType);
        for (Type superType : superTypes) {
            typeHierachy.add(superType);
        }
        for (Type superType : superTypes) {
            this.collectSupertypes(superType, typeHierachy);
        }
    }

    @Override
    public Collection<Type> getTypes() {
        return Collections.unmodifiableCollection(this.typeRegistry.values());
    }

    @Override
    public Collection<Type> getConcreteTypes() {
        ArrayList<Type> result = new ArrayList<Type>();
        for (Type type : this.getTypes()) {
            if (type.isAbstract()) continue;
            result.add(type);
        }
        return result;
    }

    protected Type declarePrimitive(String name) {
        PrimitiveType primitive = TypesFactory.eINSTANCE.createPrimitiveType();
        primitive.setName(name);
        this.declareType(primitive, name);
        this.resource.getContents().add((Object)primitive);
        return primitive;
    }

    protected Type declareComplex(String name) {
        ComplexType complex = TypesFactory.eINSTANCE.createComplexType();
        complex.setName(name);
        this.declareType(complex, name);
        this.resource.getContents().add((Object)complex);
        return complex;
    }

    protected void declareType(Type type, String name) {
        this.typeRegistry.put(name, type);
    }

    protected void removeType(String name) {
        Type type = this.typeRegistry.get(name);
        if (type != null) {
            this.extendsRegistry.removeAll((Object)type);
            this.resource.getContents().remove((Object)type);
            this.typeRegistry.remove(name);
        }
    }

    protected void declareSuperType(Type subType, Type superType) {
        this.extendsRegistry.put((Object)subType, (Object)superType);
    }

    protected void declareConversion(Type baseType, Type targetType) {
        this.conversionRegistry.put(baseType, targetType);
    }

    @Override
    public boolean haveCommonType(Type type1, Type type2) {
        return this.getCommonType(type1, type2) != null;
    }

    @Override
    public boolean isSame(Type type1, Type type2) {
        return EcoreUtil.equals((EObject)type1, (EObject)type2);
    }

    @Override
    public Type getCommonType(Type type1, Type type2) {
        Type result = this.getCommonTypeInternal(type1, type2);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public boolean haveCommonTypeWithConversion(Type type1, Type type2) {
        return this.getCommonTypeWithConversion(type1, type2) != null;
    }

    @Override
    public Type getCommonTypeWithConversion(Type type1, Type type2) {
        Type result = this.getCommonType(type1, type2);
        if (result != null) {
            return result;
        }
        Type conversionType1 = this.getConversionType(type1);
        if (conversionType1 != null && (result = this.getCommonTypeInternal(conversionType1, type2)) != null) {
            return result;
        }
        Type conversionType2 = this.getConversionType(type2);
        if (conversionType2 != null) {
            return this.getCommonTypeInternal(type1, conversionType2);
        }
        return null;
    }

    protected Type getCommonTypeInternal(Type type1, Type type2) {
        if (this.isSame(type1, type2)) {
            return type1;
        }
        if (this.isSuperType(type1, type2)) {
            return type2;
        }
        if (this.isSuperType(type2, type1)) {
            return type1;
        }
        LinkedHashSet<Type> typehierachy1 = new LinkedHashSet<Type>();
        this.collectSupertypes(type1, typehierachy1);
        LinkedHashSet<Type> typehierachy2 = new LinkedHashSet<Type>();
        this.collectSupertypes(type2, typehierachy2);
        for (Type type : typehierachy1) {
            if (!typehierachy2.contains(type)) continue;
            return type;
        }
        for (Type type : typehierachy2) {
            if (!typehierachy1.contains(type)) continue;
            return type;
        }
        return null;
    }

    protected Type getConversionType(Type sourceType) {
        return this.conversionRegistry.get(sourceType);
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public List<Operation> getOperationExtensions(Type type) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        result.addAll(this.extensionOperationRegistry.get((Object)type));
        List<Type> superTypes = this.getSuperTypes(type);
        for (Type superType : superTypes) {
            result.addAll(this.extensionOperationRegistry.get((Object)superType));
        }
        return result;
    }

    @Override
    public boolean isExtensionOperation(Operation op) {
        return this.extensionOperationRegistry.containsValue((Object)op);
    }

    @Override
    public List<Property> getPropertyExtensions(Type type) {
        ArrayList<Property> result = new ArrayList<Property>();
        result.addAll(this.extensionPropertyRegistry.get((Object)type));
        List<Type> superTypes = this.getSuperTypes(type);
        for (Type superType : superTypes) {
            result.addAll(this.extensionPropertyRegistry.get((Object)superType));
        }
        return result;
    }

    @Override
    public boolean isExtensionProperty(Property prop) {
        return this.extensionPropertyRegistry.containsValue((Object)prop);
    }

    @Override
    public List<Declaration> getMetaFeatures(Class<? extends Declaration> declarationMetaType) {
        ArrayList<Declaration> result = new ArrayList<Declaration>();
        result.addAll(this.metaFeatureRegistry.get(declarationMetaType));
        List<Class<?>> interfaces = Arrays.asList(declarationMetaType.getInterfaces());
        for (Class<?> superMetaType : interfaces) {
            if (!Declaration.class.isAssignableFrom(superMetaType)) continue;
            result.addAll(this.getMetaFeatures(superMetaType.asSubclass(Declaration.class)));
        }
        return result;
    }

    @Override
    public List<Declaration> getMetaFeatures(Declaration decl) {
        return this.getMetaFeatures(decl.getClass().asSubclass(Declaration.class));
    }

    @Override
    public boolean isMetaFeature(Declaration decl) {
        return this.metaFeatureRegistry.containsValue((Object)decl);
    }

    @Override
    public boolean isConvertableTo(Type type1, Type type2) {
        return this.isSame(this.getConversionType(type1), type2);
    }

    @Override
    public boolean isString(Type type) {
        return this.isSame(type, this.getType("string")) || this.isStringLiteral(type);
    }

    @Override
    public boolean isStringLiteral(Type type) {
        return this.isSame(type, this.getType("string:literal"));
    }

    @Override
    public boolean isReal(Type type) {
        return this.isSame(type, this.getType("real"));
    }

    @Override
    public boolean isInteger(Type type) {
        return this.isSame(type, this.getType("integer"));
    }

    @Override
    public boolean isBoolean(Type type) {
        return this.isSame(type, this.getType("boolean"));
    }

    @Override
    public boolean isVoid(Type type) {
        return this.isSame(type, this.getType("void"));
    }

    @Override
    public boolean isAny(Type type) {
        return this.isSame(type, this.getType("any"));
    }

    @Override
    public boolean isArray(Type type) {
        return this.isSame(type, this.getType("array"));
    }

    @Override
    public boolean isMap(Type type) {
        return this.isSame(type, this.getType("map"));
    }

    @Override
    public boolean isUndefined(Type type) {
        return this.isSame(type, this.getType("__undefined__"));
    }
}

