/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.types.validation;

import com.google.inject.Inject;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeParameter;
import com.yakindu.base.types.TypesUtil;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.IQualifiedNameProvider;

public class TypeValidator {
    public static final String TYPE_BINDINGS_NOT_SAME = "Type safety: The expression of type %s needs unchecked conversion to conform to %s";
    @Inject
    protected ITypeSystem registry;
    @Inject
    protected IQualifiedNameProvider fqNameProvider;

    public void assertNotType(ITypeSystemInferrer.InferenceResult currentResult, String msg, IValidationIssueAcceptor acceptor, ITypeSystemInferrer.InferenceResult ... candidates) {
        if (currentResult == null) {
            return;
        }
        if (candidates.length == 0) {
            msg = msg != null ? msg : String.format("Expected type is not %s.", currentResult);
            acceptor.accept(new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, "NotType"));
        }
        ITypeSystemInferrer.InferenceResult[] inferenceResultArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeSystemInferrer.InferenceResult type = inferenceResultArray[n2];
            if (this.registry.isSame(currentResult.getType(), type.getType())) {
                msg = msg != null ? msg : String.format("Expected type is not %s.", currentResult);
                acceptor.accept(new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, "NotType"));
            }
            ++n2;
        }
    }

    public void assertSame(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2, String msg, IValidationIssueAcceptor acceptor) {
        if (result1 == null || result2 == null) {
            return;
        }
        if (!this.registry.isSame(result1.getType(), result2.getType())) {
            msg = msg != null ? msg : String.format("Expected types %s and %s are same.", result1, result2);
            acceptor.accept(new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, "NotSame"));
            return;
        }
        this.assertTypeBindingsSame(result1, result2, msg, acceptor);
    }

    public void assertCompatible(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2, String msg, IValidationIssueAcceptor acceptor) {
        if (result1 == null || result2 == null || this.isNullOnComplexType(result1, result2) || this.isNullOnComplexType(result2, result1)) {
            return;
        }
        if (this.registry.isConvertableTo(result1.getType(), result2.getType())) {
            return;
        }
        if (!this.registry.haveCommonType(result1.getType(), result2.getType())) {
            msg = msg != null ? msg : String.format("Incompatible types %s and %s.", result1, result2);
            acceptor.accept(new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, "IncompatibleTypes"));
            return;
        }
        this.assertTypeBindingsSame(result1, result2, msg, acceptor);
    }

    public void assertAssignable(ITypeSystemInferrer.InferenceResult varResult, ITypeSystemInferrer.InferenceResult valueResult, String msg, IValidationIssueAcceptor acceptor) {
        if (varResult == null || valueResult == null || this.isNullOnComplexType(varResult, valueResult)) {
            return;
        }
        if (this.registry.isAny(varResult.getType())) {
            return;
        }
        if (this.registry.isConvertableTo(valueResult.getType(), varResult.getType())) {
            return;
        }
        if (this.namespaceDiffers(varResult, valueResult)) {
            msg = String.format("Incompatible types %s and %s.", TypesUtil.toQualifiedName(varResult.getType()), TypesUtil.toQualifiedName(valueResult.getType()));
            acceptor.accept(new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, "IncompatibleTypes"));
            return;
        }
        if (!this.registry.isSuperType(valueResult.getType(), varResult.getType())) {
            msg = msg != null ? msg : String.format("Incompatible types %s and %s.", varResult, valueResult);
            acceptor.accept(new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, "IncompatibleTypes"));
            return;
        }
        this.assertTypeBindingsSame(varResult, valueResult, msg, acceptor);
    }

    public void assertTypeBindingsSame(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2, String msg, IValidationIssueAcceptor acceptor) {
        List<ITypeSystemInferrer.InferenceResult> bindings1 = result1.getBindings();
        List<ITypeSystemInferrer.InferenceResult> bindings2 = result2.getBindings();
        if (bindings1.size() != bindings2.size()) {
            msg = String.format(TYPE_BINDINGS_NOT_SAME, result2, result1);
            acceptor.accept(new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.WARNING, msg, "NotSame"));
            return;
        }
        msg = msg != null ? msg : String.format("Incompatible types %s and %s.", result1, result2);
        int i = 0;
        while (i < bindings1.size()) {
            this.assertSame(bindings1.get(i), bindings2.get(i), msg, acceptor);
            ++i;
        }
    }

    public void assertIsSubType(ITypeSystemInferrer.InferenceResult subResult, ITypeSystemInferrer.InferenceResult superResult, String msg, IValidationIssueAcceptor acceptor) {
        if (subResult == null || superResult == null) {
            return;
        }
        if (this.registry.isConvertableTo(subResult.getType(), superResult.getType())) {
            return;
        }
        if (!this.registry.isSuperType(subResult.getType(), superResult.getType())) {
            msg = msg != null ? msg : String.format("Incompatible types %s and %s.", subResult, superResult);
            acceptor.accept(new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, "IncompatibleTypes"));
        }
    }

    public boolean isNullOnComplexType(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2) {
        if (result1 != null && result2 != null) {
            return result1.getType() instanceof ComplexType && this.isNull(result2);
        }
        return false;
    }

    public boolean namespaceDiffers(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2) {
        if (result1.getType() instanceof ComplexType && result2.getType() instanceof ComplexType && !this.bothBaseTypes((ComplexType)result1.getType(), (ComplexType)result2.getType())) {
            return !this.fqNameProvider.getFullyQualifiedName((EObject)result1.getType()).toString().equals(this.fqNameProvider.getFullyQualifiedName((EObject)result2.getType()).toString());
        }
        return false;
    }

    protected boolean bothBaseTypes(ComplexType result1, ComplexType result2) {
        return this.isBaseTypes(result1) && this.isBaseTypes(result2);
    }

    protected boolean isBaseTypes(ComplexType result) {
        return !result.getTypeParameters().isEmpty() && ((TypeParameter)result.getTypeParameters().get(0)).getName().equals("baseType");
    }

    protected boolean isNull(ITypeSystemInferrer.InferenceResult result) {
        return this.registry.isSame(result.getType(), this.registry.getType("null"));
    }

    public boolean isAnyType(Type type) {
        return this.registry.isSame(type, this.registry.getType("any"));
    }
}

