/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.gmf.runtime.highlighting;

import com.yakindu.base.gmf.runtime.highlighting.HighlightingParameters;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public interface IHighlightingSupport {
    public void lockEditor();

    public boolean isLocked();

    public void releaseEditor();

    public void releaseAndLockEditor();

    public void highlight(List<? extends EObject> var1, HighlightingParameters var2);

    public void flash(List<? extends EObject> var1, HighlightingParameters var2);

    public void executeAsync(List<Action> var1);

    public static interface Action {
        public void execute(IHighlightingSupport var1);
    }

    public static class Flash
    implements Action {
        protected List<? extends EObject> semanticElements;
        protected HighlightingParameters highligtingParams;

        public Flash(EObject semanticElement, HighlightingParameters parameters) {
            this(Collections.singletonList(semanticElement), parameters);
        }

        public Flash(List<? extends EObject> semanticElements, HighlightingParameters parameters) {
            this.semanticElements = semanticElements;
            this.highligtingParams = parameters;
        }

        @Override
        public void execute(IHighlightingSupport hs) {
            hs.flash(this.semanticElements, this.highligtingParams);
        }
    }

    public static class Highlight
    implements Action {
        protected List<? extends EObject> semanticElements;
        protected HighlightingParameters highligtingParams;

        public Highlight(EObject semanticElement, HighlightingParameters parameters) {
            this(Collections.singletonList(semanticElement), parameters);
        }

        public Highlight(List<? extends EObject> semanticElements, HighlightingParameters parameters) {
            this.semanticElements = semanticElements;
            this.highligtingParams = parameters;
        }

        @Override
        public void execute(IHighlightingSupport hs) {
            hs.highlight(this.semanticElements, this.highligtingParams);
        }
    }

    public static class HighlightingSupportNullImpl
    implements IHighlightingSupport {
        @Override
        public void lockEditor() {
        }

        @Override
        public boolean isLocked() {
            return false;
        }

        @Override
        public void releaseEditor() {
        }

        @Override
        public void releaseAndLockEditor() {
        }

        @Override
        public void executeAsync(List<Action> actions) {
        }

        @Override
        public void highlight(List<? extends EObject> semanticElement, HighlightingParameters parameters) {
        }

        @Override
        public void flash(List<? extends EObject> semanticElemesnt, HighlightingParameters parameters) {
        }
    }
}

