/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.gmf.runtime.router;

import com.yakindu.base.gmf.runtime.router.MaxMoveDelta;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ConnData {
    public Connection conn;
    public List<PrecisionPoint> initialVisualPoints = new ArrayList<PrecisionPoint>();
    public List<PrecisionPoint> initialVisualPointsAbs = new ArrayList<PrecisionPoint>();
    public List<PrecisionPoint> initialBendpointLocations = new ArrayList<PrecisionPoint>();
    public List<PrecisionPoint> finalVisualPoints = new ArrayList<PrecisionPoint>();
    public boolean isSource;
    public boolean isTarget;
    public boolean isReflexive;
    public int sourceAnchorIndex = -1;
    public int sourceNeighborIndex = -1;
    public int targetAnchorIndex = -1;
    public int targetNeighborIndex = -1;
    public boolean isSourceVertical = false;
    public boolean isTargetVertical = false;
    public int sourceSideIndex = -1;
    public int targetSideIndex = -1;
    public double SideDistance = 10.0;

    public ConnData() {
    }

    public ConnData(Connection conn, boolean isSource, boolean isTarget) {
        Object routingConstraint;
        Point p;
        this.conn = conn;
        this.isSource = isSource;
        this.isTarget = isTarget;
        this.isReflexive = isSource && isTarget;
        PointList pl = conn.getPoints();
        int i = 0;
        while (i < pl.size()) {
            p = pl.getPoint(i);
            this.initialVisualPoints.add(new PrecisionPoint(p));
            ++i;
        }
        i = 0;
        while (i < this.initialVisualPoints.size()) {
            p = new PrecisionPoint((Point)this.initialVisualPoints.get(i));
            conn.translateToAbsolute((Translatable)p);
            this.initialVisualPointsAbs.add((PrecisionPoint)p);
            ++i;
        }
        int initialPointsSize = this.initialVisualPoints.size();
        if (initialPointsSize > 1) {
            if (isSource) {
                this.sourceAnchorIndex = 0;
                this.sourceNeighborIndex = 1;
                boolean bl = this.isSourceVertical = this.initialVisualPoints.get(this.sourceAnchorIndex).preciseX() == this.initialVisualPoints.get(this.sourceNeighborIndex).preciseX();
            }
            if (isTarget) {
                this.targetAnchorIndex = initialPointsSize - 1;
                this.targetNeighborIndex = initialPointsSize - 2;
                boolean bl = this.isTargetVertical = this.initialVisualPoints.get(this.targetAnchorIndex).preciseX() == this.initialVisualPoints.get(this.targetNeighborIndex).preciseX();
            }
        }
        if ((routingConstraint = conn.getRoutingConstraint()) instanceof List) {
            List bendpointList = (List)routingConstraint;
            for (Object bpobj : bendpointList) {
                if (bpobj instanceof RelativeBendpoint) {
                    RelativeBendpoint relBp = (RelativeBendpoint)bpobj;
                    Point bp = relBp.getLocation();
                    this.initialBendpointLocations.add(new PrecisionPoint(bp));
                    continue;
                }
                System.err.println("[ERR] unknown bend point " + String.valueOf(bpobj));
            }
        } else if (routingConstraint != null) {
            System.out.println("[ERR] unknown routing constraint " + String.valueOf(routingConstraint));
        }
    }

    public List<PrecisionPoint> getInitialVisualPointsCopy() {
        ArrayList<PrecisionPoint> copy = new ArrayList<PrecisionPoint>();
        for (PrecisionPoint p : this.initialVisualPoints) {
            copy.add(new PrecisionPoint((Point)p));
        }
        return copy;
    }

    private MaxMoveDelta getMaxMoveDelta(Rectangle bounds, boolean isVerticalSegment, PrecisionPoint anchorPoint) {
        if (isVerticalSegment) {
            double x = anchorPoint.preciseX();
            double bx = bounds.preciseX() + this.SideDistance;
            double bx2 = bx + bounds.preciseWidth() - this.SideDistance - this.SideDistance;
            if (x <= bx) {
                x = bx + 1.0;
            }
            if (x >= bx2) {
                x = bx2 - 1.0;
            }
            return new MaxMoveDelta(false, x - bx2, x - bx);
        }
        double y = anchorPoint.preciseY();
        double by = bounds.preciseY() + this.SideDistance;
        double by2 = by + bounds.preciseHeight() - this.SideDistance - this.SideDistance;
        if (y <= by) {
            y = by + 1.0;
        }
        if (y >= by2) {
            y = by2 - 1.0;
        }
        return new MaxMoveDelta(true, y - by2, y - by);
    }

    public MaxMoveDelta[] getMaxMoveDeltas(Rectangle boundsAbs) {
        MaxMoveDelta mmd;
        PrecisionPoint anchorPoint;
        boolean isVertical;
        MaxMoveDelta[] mmds = new MaxMoveDelta[]{new MaxMoveDelta(), new MaxMoveDelta(true), new MaxMoveDelta(), new MaxMoveDelta(true)};
        if (this.initialVisualPointsAbs.size() < 2) {
            return mmds;
        }
        Rectangle boundsRel = boundsAbs.getCopy();
        this.conn.translateToRelative((Translatable)boundsRel);
        if (this.isSource) {
            isVertical = this.isSourceVertical;
            anchorPoint = this.initialVisualPoints.get(this.sourceAnchorIndex);
            mmd = this.getMaxMoveDelta(boundsRel, isVertical, anchorPoint);
            this.sourceSideIndex = this.getSideIndex(boundsRel, isVertical, anchorPoint);
            mmds[this.sourceSideIndex].merge(mmd);
        }
        if (this.isTarget) {
            isVertical = this.isTargetVertical;
            anchorPoint = this.initialVisualPoints.get(this.targetAnchorIndex);
            mmd = this.getMaxMoveDelta(boundsRel, isVertical, anchorPoint);
            this.targetSideIndex = this.getSideIndex(boundsRel, isVertical, anchorPoint);
            mmds[this.targetSideIndex].merge(mmd);
        }
        return mmds;
    }

    private int getSideIndex(Rectangle bounds, boolean isVerticalSegment, PrecisionPoint anchorPoint) {
        int index = isVerticalSegment ? (bounds.getTop().getDistance((Point)anchorPoint) < bounds.getBottom().getDistance((Point)anchorPoint) ? 0 : 2) : (bounds.getLeft().getDistance((Point)anchorPoint) < bounds.getRight().getDistance((Point)anchorPoint) ? 3 : 1);
        return index;
    }

    public List<PrecisionPoint> getVisualPoints() {
        ArrayList<PrecisionPoint> list = new ArrayList<PrecisionPoint>();
        PointList pointList = this.conn.getPoints();
        int i = 0;
        while (i < pointList.size()) {
            list.add(new PrecisionPoint(pointList.getPoint(i)));
            ++i;
        }
        return list;
    }

    public void printBendpointLocations() {
        System.out.println("Bendpoints for " + String.valueOf(this.conn));
        Object routingConstraint = this.conn.getRoutingConstraint();
        if (routingConstraint instanceof List) {
            List bendpointList = (List)routingConstraint;
            for (Object bpobj : bendpointList) {
                if (bpobj instanceof RelativeBendpoint) {
                    RelativeBendpoint relBp = (RelativeBendpoint)bpobj;
                    Point bp = relBp.getLocation();
                    System.out.println("- " + String.valueOf(bp));
                    continue;
                }
                System.err.println("[ERR] unknown bend point " + String.valueOf(bpobj));
            }
        } else if (routingConstraint != null) {
            System.out.println("[ERR] unknown routing constraint " + String.valueOf(routingConstraint));
        }
    }

    public void printFinalLocations() {
        System.out.println("Final bendpoint locations for " + String.valueOf(this.conn));
        for (Point point : this.finalVisualPoints) {
            System.out.println("- " + String.valueOf(point));
        }
    }

    public void printInitialLocations() {
        System.out.println("Initial bendpoint locations for " + String.valueOf(this.conn));
        for (Point point : this.initialBendpointLocations) {
            System.out.println("- " + String.valueOf(point));
        }
    }

    public void printPoints(List<? extends Point> points) {
        for (Point point : points) {
            System.out.println("- " + String.valueOf(point));
        }
    }

    public void printVisualPoints() {
        System.out.println("Visual Points for " + String.valueOf(this.conn));
        PointList pointList = this.conn.getPoints();
        int i = 0;
        while (i < pointList.size()) {
            Point p = pointList.getPoint(i);
            System.out.println("- " + String.valueOf(p));
            ++i;
        }
    }
}

