/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.gmf.runtime.router;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;

public class GeometryUtil {
    public boolean contains(Line line, Point p) {
        if (p == null) {
            return false;
        }
        if (this.equalsImprecise((Point)line.source, p) || this.equalsImprecise((Point)line.target, p)) {
            return true;
        }
        double distance = Math.abs(this.getSignedDistanceCCW(this.through(line.source, line.target), p));
        return this.equalsImprecise(distance, 0.0) && this.contains(this.getBounds(line), p);
    }

    public boolean contains(Rectangle r, Point p) {
        return !(!this.equalsImprecise(p.preciseY(), r.y) && !(p.preciseY() > r.y) || !this.equalsImprecise(p.preciseY(), r.y + r.h) && !(p.preciseY() < r.y + r.h) || !this.equalsImprecise(p.preciseX(), r.x) && !(p.preciseX() > r.x) || !this.equalsImprecise(p.preciseX(), r.x + r.w) && !(p.preciseX() < r.x + r.w));
    }

    public boolean contains(Straight s, PrecisionPoint v) {
        return this.equalsImprecise(this.getDistance(s, v), 0.0);
    }

    public boolean equalsImprecise(double a, double b) {
        return Math.abs(a - b) < this.getEpsilon();
    }

    public boolean equalsImprecise(Point p, Point q) {
        return this.equalsImprecise(p.preciseX(), q.preciseX()) && this.equalsImprecise(p.preciseY(), q.preciseY());
    }

    public PrecisionPoint findNearestIntersection(Line line, List<Line> segs, PrecisionPoint reference) {
        PrecisionPoint nearestPoi = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Line seg : segs) {
            PrecisionPoint poi = this.getIntersection(seg, line);
            if (poi == null) continue;
            if (nearestPoi == null) {
                nearestPoi = poi;
                nearestDistance = this.getDistance(nearestPoi, reference);
                continue;
            }
            double distance = this.getDistance(poi, reference);
            if (!(distance < nearestDistance)) continue;
            nearestPoi = poi;
            nearestDistance = distance;
        }
        return nearestPoi;
    }

    public PrecisionPoint getAdded(Point v, Point w) {
        return new PrecisionPoint(v.preciseX() + w.preciseX(), v.preciseY() + w.preciseY());
    }

    public PrecisionPoint getAdded(PrecisionPoint p, double dx, double dy) {
        return new PrecisionPoint(p.preciseX() + dx, p.preciseY() + dy);
    }

    public double getAngleRad(Point p, Point other) {
        double length = this.getLength(p) * this.getLength(other);
        if (length == 0.0) {
            throw new ArithmeticException("Division by zero.");
        }
        double cosAlpha = this.getDotProduct(p, other) / length;
        if (cosAlpha > 1.0) {
            cosAlpha = 1.0;
        } else if (cosAlpha < -1.0) {
            cosAlpha = -1.0;
        }
        return Math.acos(cosAlpha);
    }

    public Rectangle getBounds(Line line) {
        double xmin = Math.min(line.source.x, line.target.x);
        double xmax = Math.max(line.source.x, line.target.x);
        double ymin = Math.min(line.source.y, line.target.y);
        double ymax = Math.max(line.source.y, line.target.y);
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    private V3 getCrossProduct(V3 v, V3 w) {
        return new V3(v.y * w.z - v.z * w.y, v.z * w.x - v.x * w.z, v.x * w.y - v.y * w.x);
    }

    public double getDistance(PrecisionPoint p, PrecisionPoint q) {
        return this.getLength((Point)this.getSubtracted(p, q));
    }

    public double getDistance(Straight s, PrecisionPoint v) {
        return this.getDistance(this.getProjection(s, v), v);
    }

    public double getDotProduct(Point p, Point other) {
        return p.preciseX() * other.preciseX() + p.preciseY() * other.preciseY();
    }

    public double getEpsilon() {
        return 1.0E-5;
    }

    public PrecisionPoint getIntersection(Line a, Line b) {
        PrecisionPoint p1 = a.source;
        PrecisionPoint p2 = a.target;
        if (this.equalsImprecise((Point)p1, (Point)p2)) {
            if (this.contains(b, (Point)p1)) {
                return p1;
            }
            if (this.contains(b, (Point)p2)) {
                return p2;
            }
            return null;
        }
        PrecisionPoint lp1 = b.source;
        PrecisionPoint lp2 = b.target;
        if (this.equalsImprecise((Point)lp1, (Point)lp2)) {
            if (this.contains(a, (Point)lp1)) {
                return lp1;
            }
            if (this.contains(a, (Point)lp2)) {
                return lp2;
            }
            return null;
        }
        Straight s1 = this.through(p1, p2);
        Straight s2 = this.through(lp1, lp2);
        if (this.isParallelTo((Point)s1.direction, (Point)s2.direction)) {
            if (this.contains(s1, lp1) && this.contains(s1, lp2)) {
                double u1 = this.getParameterAt(s1, lp1);
                double u2 = this.getParameterAt(s1, lp2);
                if (this.equalsImprecise(u1, 0.0) && u2 < u1 || this.equalsImprecise(u1, 1.0) && u2 > u1) {
                    return lp1;
                }
                if (this.equalsImprecise(u2, 0.0) && u1 < u2 || this.equalsImprecise(u2, 1.0) && u1 > u2) {
                    return lp2;
                }
            }
            return null;
        }
        PrecisionPoint intersection = this.getIntersection(s1, s2);
        return this.contains(a, (Point)intersection) && this.contains(b, (Point)intersection) ? intersection : null;
    }

    public PrecisionPoint getIntersection(Straight s1, Straight s2) {
        PrecisionPoint p1 = this.getAdded((Point)s1.position, (Point)s1.direction);
        PrecisionPoint p2 = this.getAdded((Point)s2.position, (Point)s2.direction);
        V3 l1 = this.getCrossProduct(new V3(s1.position.x, s1.position.y, 1.0), new V3((Point)p1));
        V3 l2 = this.getCrossProduct(new V3(s2.position.x, s2.position.y, 1.0), new V3((Point)p2));
        PrecisionPoint poi = this.getCrossProduct(l1, l2).toPoint();
        return poi;
    }

    public double getLength(Point vector) {
        return Math.sqrt(this.getDotProduct(vector, vector));
    }

    public PrecisionPoint getNormalized(Point vector) {
        double f = 1.0 / this.getLength(vector);
        return new PrecisionPoint(f * vector.preciseX(), f * vector.preciseY());
    }

    public PrecisionPoint getOrthogonalComplement(Point vector) {
        return new PrecisionPoint(-vector.preciseY(), vector.preciseX());
    }

    public List<Line> getOutlineSegments(Rectangle rect) {
        ArrayList<Line> segs = new ArrayList<Line>();
        segs.add(new Line(new PrecisionPoint(rect.x, rect.y), new PrecisionPoint(rect.x + rect.w, rect.y)));
        segs.add(new Line(new PrecisionPoint(rect.x + rect.w, rect.y), new PrecisionPoint(rect.x + rect.w, rect.y + rect.h)));
        segs.add(new Line(new PrecisionPoint(rect.x + rect.w, rect.y + rect.h), new PrecisionPoint(rect.x, rect.y + rect.h)));
        segs.add(new Line(new PrecisionPoint(rect.x, rect.y + rect.h), new PrecisionPoint(rect.x, rect.y)));
        return segs;
    }

    public double getParameterAt(Straight s, PrecisionPoint p) {
        if (!this.contains(s, p)) {
            throw new IllegalArgumentException("The given position Vector has to be on this Straight: getParameterAt(" + String.valueOf(s) + ", " + String.valueOf(p) + ")");
        }
        if (Math.abs(s.direction.preciseX()) > Math.abs(s.direction.preciseY())) {
            return (p.preciseX() - s.position.preciseX()) / s.direction.preciseX();
        }
        if (s.direction.preciseY() != 0.0) {
            return (p.preciseY() - s.position.preciseY()) / s.direction.preciseY();
        }
        throw new IllegalStateException("The direction Vector of this Straight may not be (0, 0) for this computation: getParameterAt(" + String.valueOf(s) + ", " + String.valueOf(p) + ")");
    }

    public PrecisionPoint getProjection(Straight s, PrecisionPoint vector) {
        PrecisionPoint normalized = this.getNormalized((Point)s.direction);
        Straight s1 = new Straight(new PrecisionPoint(0.0, 0.0), normalized);
        Straight s2 = new Straight(this.getSubtracted(vector, s.position), this.getOrthogonalComplement((Point)normalized));
        return this.getAdded((Point)this.getIntersection(s1, s2), (Point)s.position);
    }

    public double getSignedDistanceCCW(Straight s, Point p) {
        Point r = p;
        p = s.position;
        PrecisionPoint q = this.getAdded((Point)s.position, (Point)s.direction);
        Straight3d s3d = this.through3d(p, (Point)q);
        if (s3d == null) {
            return 0.0;
        }
        double sd = -this.getSignedDistanceCW(s3d, new V3(r.preciseX(), r.preciseY(), 1.0));
        return sd;
    }

    public double getSignedDistanceCW(Straight3d s3d, V3 v3) {
        return (s3d.line.x * v3.x + s3d.line.y * v3.y + s3d.line.z) / s3d.f;
    }

    public PrecisionPoint getSubtracted(PrecisionPoint v, PrecisionPoint w) {
        return new PrecisionPoint(v.preciseX() - w.preciseX(), v.preciseY() - w.preciseY());
    }

    public boolean isParallelTo(Point v, Point w) {
        double rad = this.getAngleRad(v, w);
        rad *= 2.0;
        rad = this.normalizeRad(rad);
        return this.equalsImprecise(rad, 0.0);
    }

    public double normalizeRad(double rad) {
        rad -= Math.PI * 2 * Math.floor(rad / (Math.PI * 2));
        return rad;
    }

    public Straight through(PrecisionPoint p, PrecisionPoint q) {
        return new Straight(p, this.getSubtracted(q, p));
    }

    public Straight3d through3d(Point p, Point q) {
        V3 sp = new V3(p);
        V3 line = this.getCrossProduct(sp, new V3(q));
        double f = Math.sqrt(line.x * line.x + line.y * line.y);
        if (f == 0.0) {
            return null;
        }
        Straight3d self = new Straight3d(sp, line, f);
        return self;
    }

    public PrecisionPoint toPP(Point point) {
        return point instanceof PrecisionPoint ? (PrecisionPoint)point : new PrecisionPoint(point.preciseX(), point.preciseY());
    }

    public Rectangle toRectangle(org.eclipse.draw2d.geometry.Rectangle rect) {
        return new Rectangle(rect.preciseX(), rect.preciseY(), rect.preciseWidth(), rect.preciseHeight());
    }

    public static class Line {
        public PrecisionPoint source;
        public PrecisionPoint target;

        public Line(PrecisionPoint source, PrecisionPoint target) {
            this.source = source;
            this.target = target;
        }

        public String toString() {
            return "[" + String.valueOf(this.source) + "--" + String.valueOf(this.target) + "]";
        }
    }

    public static class Rectangle {
        public double x;
        public double y;
        public double w;
        public double h;

        public Rectangle(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }

    public static class Straight {
        public PrecisionPoint position;
        public PrecisionPoint direction;

        public Straight(PrecisionPoint start, PrecisionPoint direction) {
            this.position = start;
            this.direction = direction;
        }
    }

    public static class Straight3d {
        public V3 sp;
        public V3 line;
        public double f;

        public Straight3d(V3 sp, V3 line, double f) {
            this.sp = sp;
            this.line = line;
            this.f = f;
        }
    }

    public static class V3 {
        public double x;
        public double y;
        public double z;

        public V3(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public V3(Point p) {
            this(p.preciseX(), p.preciseY(), 1.0);
        }

        public PrecisionPoint toPoint() {
            if (this.z == 0.0) {
                return null;
            }
            return new PrecisionPoint(this.x / this.z, this.y / this.z);
        }
    }
}

