/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.gmf.runtime.router;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;

public class RelativeBendpointUtil {
    public List<Point> convertConstraintToListOfPoint(Connection conn) {
        ArrayList<Point> list = new ArrayList<Point>();
        Object routingConstraint = conn.getRoutingConstraint();
        if (routingConstraint instanceof List) {
            List bendpointList = (List)routingConstraint;
            for (Object bpobj : bendpointList) {
                if (bpobj instanceof RelativeBendpoint) {
                    list.add(((RelativeBendpoint)bpobj).getLocation());
                    continue;
                }
                System.err.println("[ERR] unknown bend point " + String.valueOf(bpobj));
            }
        } else if (routingConstraint != null) {
            System.out.println("[ERR] unknown routing constraint " + String.valueOf(routingConstraint));
        }
        return list;
    }

    public PointList convertToPointList(List<? extends Point> points) {
        PointList pl = new PointList(points.size());
        for (Point point : points) {
            pl.addPoint(point.getCopy());
        }
        return pl;
    }

    public void forceLocation(Connection conn, RelativeBendpoint relbp, double locX, double locY) {
        float w = 0.0f;
        Dimension d2 = new Dimension();
        PrecisionDimension d1 = new PrecisionDimension();
        PrecisionPoint a1 = new PrecisionPoint(conn.getSourceAnchor().getReferencePoint());
        Point a1Copy = a1.getCopy();
        conn.translateToRelative((Translatable)a1Copy);
        d1.setPreciseWidth(locX - a1Copy.preciseX());
        d1.setPreciseHeight(locY - a1Copy.preciseY());
        relbp.setRelativeDimensions((Dimension)d1, d2);
        relbp.setWeight(w);
        Point location = relbp.getLocation();
        if (Math.abs(location.preciseX() - locX) > 0.1) {
            throw new IllegalStateException("cannot force location-x: expected <" + locX + "> but got <" + location.preciseX() + ">");
        }
        if (Math.abs(location.preciseY() - locY) > 0.1) {
            throw new IllegalStateException("cannot force location-y: expected <" + locY + "> but got <" + location.preciseY() + ">");
        }
    }
}

