/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.concepts;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.yakindu.base.expressions.interpreter.IExpressionInterpreter;
import com.yakindu.base.types.AnnotatableElement;
import com.yakindu.base.types.AnnotatedElement;
import com.yakindu.base.types.Annotation;
import com.yakindu.base.types.AnnotationType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.TypesFactory;
import com.yakindu.base.types.libraries.AbstractTypeLibrary;
import com.yakindu.base.types.libraries.ITypeLibrary;
import com.yakindu.base.types.libraries.ITypeLibraryProvider;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sruntime.SRuntimeFactory;
import com.yakindu.sct.model.stext.stext.StextPackage;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class StatechartAnnotations {
    public static final String LIBRARY = "create.statecharts";
    public static final URI LIBRARY_URI = URI.createURI((String)"create.statecharts");
    public static final String STATECHART_PACKAGE_NAME = "statecharts";
    public static final String CYCLE_BASED_ANNOTATION = "CycleBased";
    public static final String EVENT_DRIVEN_ANNOTATION = "EventDriven";
    public static final String PARENT_FIRST_ANNOTATION = "ParentFirstExecution";
    public static final String CHILD_FIRST_ANNOTATION = "ChildFirstExecution";
    public static final String SUPERSTEP_ANNOTATION = "SuperSteps";
    public static final String EVENTBUFFERING_ANNOTATION = "EventBuffering";
    public static final String DO_NOT_VALIDATE_INITIALIZATION_EXPRESSION_ANNOTATION = "DoNotValidateInitExpr";
    public static final String HALTABLE_ANNOTATION = "Haltable";
    public static final String EXPERIMENTAL_TYPES_ANNOTATION = "ExperimentalTypes";
    @Inject(optional=true)
    private IExpressionInterpreter interpreter;

    public boolean isCycleBased(Statechart statechart) {
        return this.defines(statechart, CYCLE_BASED_ANNOTATION);
    }

    public long getCyclePeriod(EObject obj) {
        Annotation annotation_1;
        long cyclePeriod = 200L;
        if (obj instanceof AnnotatableElement) {
            Annotation annotation = ((AnnotatableElement)obj).getAnnotationOfType(CYCLE_BASED_ANNOTATION);
            if (annotation != null && this.interpreter != null) {
                Object _evaluate = this.interpreter.evaluate((Expression)annotation.getExpressions().get(0), SRuntimeFactory.eINSTANCE.createExecutionContext());
                cyclePeriod = (Long)_evaluate;
            }
        } else if (obj instanceof Statechart && (annotation_1 = ((Statechart)obj).getAnnotationOfType(CYCLE_BASED_ANNOTATION)) != null && this.interpreter != null) {
            Object _evaluate_1 = this.interpreter.evaluate((Expression)annotation_1.getExpressions().get(0), SRuntimeFactory.eINSTANCE.createExecutionContext());
            cyclePeriod = (Long)_evaluate_1;
        }
        return cyclePeriod;
    }

    public boolean isEventDriven(Statechart statechart) {
        boolean _isCycleBased = this.isCycleBased(statechart);
        return !_isCycleBased;
    }

    public boolean isParentFirstExecution(Statechart statechart) {
        return this.defines(statechart, PARENT_FIRST_ANNOTATION);
    }

    public boolean isChildFirstExecution(Statechart statechart) {
        boolean _isParentFirstExecution = this.isParentFirstExecution(statechart);
        return !_isParentFirstExecution;
    }

    public boolean validateInitializationExpressions(Statechart statechart) {
        boolean _defines = this.defines(statechart, DO_NOT_VALIDATE_INITIALIZATION_EXPRESSION_ANNOTATION);
        return !_defines;
    }

    public boolean isInternalEventBuffer(Statechart statechart) {
        return this.boolAnnotationParameter((AnnotatedElement)statechart, EVENTBUFFERING_ANNOTATION, 1, true);
    }

    public boolean isInEventBuffer(Statechart statechart) {
        return this.boolAnnotationParameter((AnnotatedElement)statechart, EVENTBUFFERING_ANNOTATION, 0, true);
    }

    public boolean isSuperStep(Statechart statechart) {
        return this.boolAnnotationParameter((AnnotatedElement)statechart, SUPERSTEP_ANNOTATION, 0, false);
    }

    public boolean isExperimentalTypes(Statechart statechart) {
        return this.boolAnnotationParameter((AnnotatedElement)statechart, EXPERIMENTAL_TYPES_ANNOTATION, 0, false);
    }

    public boolean isHaltable(Statechart statechart) {
        return this.defines(statechart, HALTABLE_ANNOTATION);
    }

    public void declareHaltable(Statechart statechart) {
        if (statechart != null && !this.isHaltable(statechart)) {
            Annotation annotation = TypesFactory.eINSTANCE.createAnnotation();
            AnnotationType haltableAnnotationType = TypesFactory.eINSTANCE.createAnnotationType();
            haltableAnnotationType.setName(HALTABLE_ANNOTATION);
            annotation.setType(haltableAnnotationType);
            statechart.getAnnotations().add((Object)annotation);
        }
    }

    public boolean boolAnnotationParameter(AnnotatedElement annotated, String annotation, int param, boolean defaultValue) {
        if (annotated == null) {
            return false;
        }
        Annotation eventBuffering = annotated.getAnnotationOfType(annotation);
        if (eventBuffering == null || eventBuffering.getExpressions().size() <= param || this.interpreter == null) {
            return defaultValue;
        }
        Object _evaluate = this.interpreter.evaluate((Expression)eventBuffering.getExpressions().get(param), SRuntimeFactory.eINSTANCE.createExecutionContext());
        return (Boolean)_evaluate;
    }

    protected boolean defines(Statechart statechart, String annotationName) {
        Annotation _annotationOfType = null;
        if (statechart != null) {
            _annotationOfType = statechart.getAnnotationOfType(annotationName);
        }
        return _annotationOfType != null;
    }

    @Singleton
    public static class Library
    extends AbstractTypeLibrary {
        @Extension
        protected SGraphPackage sgraphPackage = SGraphPackage.eINSTANCE;
        @Extension
        protected StextPackage stextPackage = StextPackage.eINSTANCE;

        protected Package createLibraryPackage() {
            Package __package = this.builder._package(StatechartAnnotations.STATECHART_PACKAGE_NAME);
            Procedures.Procedure1 _function = package_ -> {
                AnnotationType __annotationType = this.builder._annotationType(StatechartAnnotations.EVENT_DRIVEN_ANNOTATION);
                Procedures.Procedure1 _function_1 = it -> this.statechartTargets((AnnotationType)it);
                AnnotationType _doubleArrow = (AnnotationType)ObjectExtensions.operator_doubleArrow((Object)__annotationType, (Procedures.Procedure1)_function_1);
                AnnotationType __annotationType_1 = this.builder._annotationType(StatechartAnnotations.CYCLE_BASED_ANNOTATION);
                Procedures.Procedure1 _function_2 = it -> {
                    this.builder._param((Operation)it, "period", this.builder._integer());
                    this.statechartTargets((AnnotationType)it);
                };
                AnnotationType _doubleArrow_1 = (AnnotationType)ObjectExtensions.operator_doubleArrow((Object)__annotationType_1, (Procedures.Procedure1)_function_2);
                AnnotationType __annotationType_2 = this.builder._annotationType(StatechartAnnotations.PARENT_FIRST_ANNOTATION);
                Procedures.Procedure1 _function_3 = it -> this.statechartTargets((AnnotationType)it);
                AnnotationType _doubleArrow_2 = (AnnotationType)ObjectExtensions.operator_doubleArrow((Object)__annotationType_2, (Procedures.Procedure1)_function_3);
                AnnotationType __annotationType_3 = this.builder._annotationType(StatechartAnnotations.CHILD_FIRST_ANNOTATION);
                Procedures.Procedure1 _function_4 = it -> this.statechartTargets((AnnotationType)it);
                AnnotationType _doubleArrow_3 = (AnnotationType)ObjectExtensions.operator_doubleArrow((Object)__annotationType_3, (Procedures.Procedure1)_function_4);
                AnnotationType __annotationType_4 = this.builder._annotationType(StatechartAnnotations.SUPERSTEP_ANNOTATION);
                Procedures.Procedure1 _function_5 = it -> {
                    this.builder._param((Operation)it, "enabled", this.builder._boolean());
                    this.statechartTargets((AnnotationType)it);
                };
                AnnotationType _doubleArrow_4 = (AnnotationType)ObjectExtensions.operator_doubleArrow((Object)__annotationType_4, (Procedures.Procedure1)_function_5);
                AnnotationType __annotationType_5 = this.builder._annotationType(StatechartAnnotations.EVENTBUFFERING_ANNOTATION);
                Procedures.Procedure1 _function_6 = it -> {
                    this.builder._param((Operation)it, "inEvents", this.builder._boolean());
                    this.builder._param((Operation)it, "localEvents", this.builder._boolean());
                    this.statechartTargets((AnnotationType)it);
                };
                AnnotationType _doubleArrow_5 = (AnnotationType)ObjectExtensions.operator_doubleArrow((Object)__annotationType_5, (Procedures.Procedure1)_function_6);
                AnnotationType __annotationType_6 = this.builder._annotationType(StatechartAnnotations.EXPERIMENTAL_TYPES_ANNOTATION);
                Procedures.Procedure1 _function_7 = it -> {
                    this.builder._param((Operation)it, "enabled", this.builder._boolean());
                    this.statechartTargets((AnnotationType)it);
                };
                AnnotationType _doubleArrow_6 = (AnnotationType)ObjectExtensions.operator_doubleArrow((Object)__annotationType_6, (Procedures.Procedure1)_function_7);
                package_.getMember().addAll(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Declaration[]{_doubleArrow, _doubleArrow_1, _doubleArrow_2, _doubleArrow_3, _doubleArrow_4, _doubleArrow_5, _doubleArrow_6})));
            };
            return (Package)ObjectExtensions.operator_doubleArrow((Object)__package, (Procedures.Procedure1)_function);
        }

        protected boolean statechartTargets(AnnotationType it) {
            EList _targets = it.getTargets();
            EClass _statechart = this.sgraphPackage.getStatechart();
            EClass _statechartSpecification = this.stextPackage.getStatechartSpecification();
            return Iterables.addAll((Collection)_targets, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EClass[]{_statechart, _statechartSpecification})));
        }

        public URI getLibraryURI() {
            return LIBRARY_URI;
        }

        public static class Provider
        implements ITypeLibraryProvider {
            @Inject
            private Injector injector;

            public Iterable<ITypeLibrary> provide() {
                Library _instance = (Library)((Object)this.injector.getInstance(Library.class));
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ITypeLibrary[]{_instance}));
            }
        }
    }
}

