/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.scoping;

import com.google.inject.Inject;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.extensions.STextExtensions;
import com.yakindu.sct.model.stext.stext.ImportScope;
import com.yakindu.sct.model.stext.stext.StatechartSpecification;
import com.yakindu.sct.model.stext.stext.StextPackage;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.impl.ImportUriGlobalScopeProvider;
import org.eclipse.xtext.util.IAcceptor;

public class ImportUriProvider {
    @Inject
    private IPackageImport2URIMapper mapper;
    @Inject
    private STextExtensions utils;

    public LinkedHashSet<URI> get(Resource resource) {
        LinkedHashSet<URI> uniqueImportURIs = new LinkedHashSet<URI>(5);
        ImportUriGlobalScopeProvider.URICollector collector = new ImportUriGlobalScopeProvider.URICollector(resource.getResourceSet(), uniqueImportURIs);
        this.collectFromImportScopes(resource, (IAcceptor<String>)collector);
        this.collectImplicitImports(resource, (IAcceptor<String>)collector);
        this.removeInvalidUris(resource, uniqueImportURIs);
        return uniqueImportURIs;
    }

    protected void removeInvalidUris(Resource resource, LinkedHashSet<URI> uniqueImportURIs) {
        Iterator uriIter = uniqueImportURIs.iterator();
        while (uriIter.hasNext()) {
            if (this.isValidUri(resource, ((URI)uriIter.next()).trimQuery())) continue;
            uriIter.remove();
        }
    }

    protected void collectFromImportScopes(Resource resource, IAcceptor<String> collector) {
        Collection<ImportScope> importScopes = this.getImportScopes(resource);
        for (ImportScope object : importScopes) {
            EList<String> imports = object.getImports();
            for (String packageImport : imports) {
                this.collectPackageImports(resource, packageImport, collector);
            }
        }
    }

    protected void collectImplicitImports(Resource resource, IAcceptor<String> collector) {
    }

    protected Collection<ImportScope> getImportScopes(Resource resource) {
        StatechartSpecification specification = (StatechartSpecification)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)StextPackage.Literals.STATECHART_SPECIFICATION);
        if (specification != null) {
            return EcoreUtil.getObjectsByType((Collection)specification.getScopes(), (EClassifier)StextPackage.Literals.IMPORT_SCOPE);
        }
        Statechart statechart = this.utils.getStatechart(resource);
        if (statechart == null) {
            return new LinkedHashSet<ImportScope>();
        }
        return EcoreUtil.getObjectsByType((Collection)statechart.getScopes(), (EClassifier)StextPackage.Literals.IMPORT_SCOPE);
    }

    protected void collectPackageImports(Resource resource, String packageImport, IAcceptor<String> acceptor) {
        Optional pkgImport = this.mapper.findPackageImport(resource, packageImport);
        if (pkgImport.isPresent() && ((IPackageImport2URIMapper.PackageImport)pkgImport.get()).getUri() != null && this.getConverter().exists(((IPackageImport2URIMapper.PackageImport)pkgImport.get()).getUri().trimQuery(), null)) {
            acceptor.accept((Object)((IPackageImport2URIMapper.PackageImport)pkgImport.get()).getUri().toString());
        }
    }

    protected boolean isValidUri(Resource context, URI uri) {
        boolean validURI = EcoreUtil2.isValidUri((Resource)context, (URI)uri);
        if (!validURI) {
            return this.getConverter().exists(uri, null);
        }
        return true;
    }

    protected URIConverter getConverter() {
        return TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("com.yakindu.sct.domain").getResourceSet().getURIConverter();
    }
}

