/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.scoping;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;

@Singleton
public class ImportedResourceCache {
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;
    @Inject
    private DefaultResourceDescriptionStrategy delegateStrategy;

    protected TransactionalEditingDomain getEditingDomain() {
        return TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("com.yakindu.sct.domain");
    }

    public IResourceDescription get(final URI uri) {
        this.refreshFile(uri);
        try {
            return (IResourceDescription)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl<IResourceDescription>(){

                public void run() {
                    ResourceSet set = ImportedResourceCache.this.getResourceSet();
                    Resource resource = set.getResource(uri, true);
                    if (resource != null) {
                        IResourceServiceProvider serviceProvider = ImportedResourceCache.this.serviceProviderRegistry.getResourceServiceProvider(uri);
                        if (serviceProvider == null) {
                            this.setResult(new DefaultResourceDescription(resource, (IDefaultResourceDescriptionStrategy)ImportedResourceCache.this.delegateStrategy));
                            return;
                        }
                        IResourceDescription.Manager resourceDescriptionManager = serviceProvider.getResourceDescriptionManager();
                        if (resourceDescriptionManager == null) {
                            return;
                        }
                        IResourceDescription result = resourceDescriptionManager.getResourceDescription(resource);
                        this.setResult(result);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void refreshFile(URI uri) {
        String platformString = uri.toPlatformString(true);
        if (platformString == null) {
            return;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformString));
        if (file.isAccessible() && !file.isSynchronized(2)) {
            try {
                file.refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected ResourceSet getResourceSet() {
        return this.getEditingDomain().getResourceSet();
    }
}

