/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.yakindu.base.base.BasePackage;
import com.yakindu.base.types.TypesPackage;
import com.yakindu.base.types.libraries.ITypeLibraryProvider;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.base.types.scoping.TypeLibraryScope;
import com.yakindu.base.types.scoping.TypeSystemAwareScope;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.model.stext.extensions.STextExtensions;
import com.yakindu.sct.model.stext.scoping.ImportUriProvider;
import com.yakindu.sct.model.stext.scoping.ImportedResourceCache;
import com.yakindu.sct.model.stext.scoping.StextDefaultTypeLibraries;
import com.yakindu.sct.model.stext.stext.ImportScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.ImportUriGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.MultimapBasedScope;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;
import org.eclipse.xtext.util.IResourceScopeCache;

public class STextGlobalScopeProvider
extends ImportUriGlobalScopeProvider {
    @Inject
    private ITypeSystem typeSystem;
    @Inject
    private ITypeLibraryProvider typeLibraries;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IResourceScopeCache cache;
    @Inject
    private ImportedResourceCache resourceDescriptionCache;
    @Inject
    private STextExtensions utils;
    @Inject
    private ImportUriProvider importUriProvider;
    @Inject
    private IPackageImport2URIMapper importUriMapper;
    @Inject
    private StatechartAnnotations annotations;
    @Inject
    protected StextDefaultTypeLibraries defaultTypeLibraies;

    public void setCache(IResourceScopeCache cache) {
        this.cache = cache;
    }

    public IScope getScope(Resource context, EReference reference, Predicate<IEObjectDescription> filter) {
        IScope parentScope = super.getScope(context, reference, filter);
        Statechart statechart = this.utils.getStatechart(context);
        final String statechartDomain = statechart != null ? statechart.getDomainID() : BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValue().toString();
        parentScope = new TypeSystemAwareScope(parentScope, this.typeSystem, this.qualifiedNameProvider, reference.getEReferenceType(), this.annotations.isExperimentalTypes(statechart));
        parentScope = this.getTypeLibraryScope(parentScope, context);
        FilteringScope result = new FilteringScope(parentScope, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                String userData = input.getUserData("domainID");
                if (userData == null) {
                    return true;
                }
                return statechartDomain.equals(userData);
            }
        });
        result = this.filterAnnotations(reference, (IScope)result);
        return new FilteringScope((IScope)result, input -> {
            String isVisible = input.getUserData("is_visible_type");
            return isVisible == null || Boolean.valueOf(isVisible) != false;
        });
    }

    protected IScope getTypeLibraryScope(IScope parentScope, Resource context) {
        Collection<ImportScope> importScopes = this.importUriProvider.getImportScopes(context);
        Set imported = importScopes.stream().map(s -> s.getImports().stream().filter(i -> this.importUriMapper.findPackageImport(context, i).isPresent()).map(i -> ((IPackageImport2URIMapper.PackageImport)this.importUriMapper.findPackageImport(context, i).get()).getUri()).collect(Collectors.toSet())).reduce(new LinkedHashSet(), (a, b) -> {
            a.addAll(b);
            return a;
        });
        imported.addAll(this.defaultTypeLibraies.getDefaultTypeLibraries());
        return new TypeLibraryScope.TypeScope(parentScope, this.typeLibraries, imported);
    }

    protected IScope filterAnnotations(EReference reference, IScope result) {
        if (reference != TypesPackage.Literals.ANNOTATION__TYPE) {
            result = new FilteringScope(result, (Predicate)new Predicate<IEObjectDescription>(){

                public boolean apply(IEObjectDescription input) {
                    return input.getEClass() != TypesPackage.Literals.ANNOTATION_TYPE;
                }
            });
        }
        return result;
    }

    protected LinkedHashSet<URI> getImportedUris(final Resource resource) {
        return (LinkedHashSet)this.cache.get((Object)ImportUriGlobalScopeProvider.class.getName(), resource, (Provider)new Provider<LinkedHashSet<URI>>(){

            public LinkedHashSet<URI> get() {
                return STextGlobalScopeProvider.this.importUriProvider.get(resource);
            }
        });
    }

    protected IScope getScope(Resource resource, boolean ignoreCase, EClass type, Predicate<IEObjectDescription> filter) {
        LinkedHashSet<URI> uniqueImportURIs = this.getImportedUris(resource);
        IResourceDescriptions descriptions = this.getResourceDescriptions(resource, uniqueImportURIs);
        ArrayList urisAsList = Lists.newArrayList(uniqueImportURIs);
        Collections.reverse(urisAsList);
        ArrayList objectDescriptions = new ArrayList();
        for (URI uri : urisAsList) {
            IScope scope = this.createLazyResourceScope(IScope.NULLSCOPE, uri, descriptions, type, filter, ignoreCase);
            Iterables.addAll(objectDescriptions, (Iterable)scope.getAllElements());
        }
        return MultimapBasedScope.createScope((IScope)IScope.NULLSCOPE, objectDescriptions, (boolean)ignoreCase);
    }

    protected IScope createLazyResourceScope(IScope parent, URI uri, IResourceDescriptions descriptions, EClass type, Predicate<IEObjectDescription> filter, boolean ignoreCase) {
        IResourceDescription description = this.resourceDescriptionCache.get(uri);
        if (description == null) {
            return IScope.NULLSCOPE;
        }
        return SelectableBasedScope.createScope((IScope)parent, (ISelectable)description, filter, (EClass)type, (boolean)ignoreCase);
    }
}

