/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.scoping;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.MetaCall;
import com.yakindu.base.expressions.scoping.ExpressionsScopeProvider;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.MetaComposite;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypesFactory;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.libraries.ITypeLibraryProvider;
import com.yakindu.base.types.scoping.TypeLibraryScope;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.RegularState;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sgraph.ScopedElement;
import com.yakindu.sct.model.sgraph.SpecificationElement;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.util.StatechartUtil;
import com.yakindu.sct.model.stext.extensions.STextExtensions;
import com.yakindu.sct.model.stext.resource.StextResource;
import com.yakindu.sct.model.stext.scoping.ContextPredicateProvider;
import com.yakindu.sct.model.stext.scoping.GlobalTypeScope;
import com.yakindu.sct.model.stext.scoping.StextDefaultTypeLibraries;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.InternalScope;
import com.yakindu.sct.model.stext.stext.StatechartSpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.EObjectDescriptionLookUp;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xbase.lib.Extension;

public class STextScopeProvider
extends ExpressionsScopeProvider {
    @Inject
    protected ITypeSystemInferrer typeInferrer;
    @Inject
    protected ITypeSystem typeSystem;
    @Inject
    protected IQualifiedNameProvider nameProvider;
    @Inject
    private ContextPredicateProvider predicateProvider;
    @Inject
    @Extension
    protected STextExtensions utils;
    @Inject
    protected StatechartUtil statechartUtil;
    @Inject
    protected ITypeLibraryProvider typeLibraries;
    @Inject
    @Extension
    protected StextDefaultTypeLibraries _stextDefaultTypeLibraries;
    @Inject
    @Extension
    protected ExpressionExtensions _expressionExtensions;
    @Extension
    protected TypesFactory _typesFactory = TypesFactory.eINSTANCE;

    public IScope scope_Annotation_type(EObject context, EReference reference) {
        Set<URI> _defaultTypeLibraries = this._stextDefaultTypeLibraries.getDefaultTypeLibraries();
        return new TypeLibraryScope.AnnotationTypeScope(IScope.NULLSCOPE, this.typeLibraries, _defaultTypeLibraries);
    }

    public IScope scope_ActiveStateReferenceExpression_value(EObject context, EReference reference) {
        Statechart statechart = this.getStatechart(context);
        if (statechart == null) {
            return IScope.NULLSCOPE;
        }
        List allStates = EcoreUtil2.getAllContentsOfType((EObject)statechart, RegularState.class);
        IScope scope = Scopes.scopeFor((Iterable)allStates, (Function)this.nameProvider, (IScope)IScope.NULLSCOPE);
        List<ImportNormalizer> _activeStateNormalizer = this.getActiveStateNormalizer(context);
        ArrayList _newArrayList = Lists.newArrayList((Iterable)scope.getAllElements());
        EObjectDescriptionLookUp _eObjectDescriptionLookUp = new EObjectDescriptionLookUp((List)_newArrayList);
        EClass _eReferenceType = reference.getEReferenceType();
        return new ImportScope(_activeStateNormalizer, scope, (ISelectable)_eObjectDescriptionLookUp, _eReferenceType, false);
    }

    protected List<ImportNormalizer> getActiveStateNormalizer(EObject context) {
        ArrayList normalizer = Lists.newArrayList();
        SpecificationElement contextElement = this.utils.getContextElement(context);
        if (contextElement == null) {
            return normalizer;
        }
        Region containingRegion = (Region)EcoreUtil2.getContainerOfType((EObject)contextElement, Region.class);
        if (containingRegion == null) {
            return normalizer;
        }
        QualifiedName fullyQualifiedName = this.nameProvider.getFullyQualifiedName((EObject)containingRegion);
        while (!fullyQualifiedName.getSegments().isEmpty()) {
            ImportNormalizer _importNormalizer = new ImportNormalizer(fullyQualifiedName, true, false);
            normalizer.add(_importNormalizer);
            fullyQualifiedName = fullyQualifiedName.skipLast(1);
        }
        return normalizer;
    }

    public IScope scope_TypeSpecifier_type(EObject context, EReference reference) {
        IScope _scope = this.getDelegate().getScope(context, reference);
        Resource _statechartResource = this.getStatechartResource(context);
        EClass _eReferenceType = reference.getEReferenceType();
        return new GlobalTypeScope(_scope, _statechartResource, _eReferenceType);
    }

    public IScope scope_ElementReferenceExpression_reference(EObject context, EReference reference) {
        IScope namedScope = this.getNamedTopLevelScope(context, reference);
        IScope unnamedScope = this.getUnnamedTopLevelScope(context, reference);
        Predicate<IEObjectDescription> predicate = this.calculateFilterPredicate(context, reference);
        FilteringScope _filteringScope = new FilteringScope(unnamedScope, predicate);
        unnamedScope = _filteringScope;
        Iterable _scopedElementsFor = Scopes.scopedElementsFor((Iterable)Iterables.filter((Iterable)this.getStatechartResource(context).getContents(), Package.class));
        SimpleScope packageContainerScope = new SimpleScope(unnamedScope, _scopedElementsFor);
        Iterable _allElements = namedScope.getAllElements();
        return new SimpleScope((IScope)packageContainerScope, _allElements);
    }

    public IScope scope_FeatureCall_feature(ElementReferenceExpression context, EReference reference) {
        return this.scope_FeatureCall((Expression)context, reference);
    }

    public IScope scope_FeatureCall_feature(FeatureCall context, EReference reference) {
        return this.scope_FeatureCall(context.getOwner(), reference);
    }

    protected IScope scope_FeatureCall(Expression context, EReference reference) {
        Predicate<IEObjectDescription> predicate = this.calculateFilterPredicate((EObject)context, reference);
        EObject element = this._expressionExtensions.featureOrReference(context);
        if (element instanceof Event) {
            return Scopes.scopeFor((Iterable)this.typeSystem.getMetaFeatures((Declaration)element));
        }
        IScope scope = IScope.NULLSCOPE;
        if (element instanceof Package) {
            Resource _eResource = ((Package)element).eResource();
            if (_eResource instanceof StextResource) {
                return this.addScopeForInternalPackage((Package)element, scope, predicate, reference);
            }
            return this.addScopeForPackage((Package)element, scope, predicate, context, reference);
        }
        ITypeSystemInferrer.InferenceResult result = this.typeInferrer.infer((EObject)context);
        Type _xifexpression = null;
        _xifexpression = result != null ? result.getType() : null;
        Type ownerType = _xifexpression;
        if (element instanceof Scope) {
            scope = Scopes.scopeFor((Iterable)((Scope)element).getDeclarations());
            return new FilteringScope(scope, predicate);
        }
        if (ownerType != null) {
            scope = Scopes.scopeFor((Iterable)this.typeSystem.getPropertyExtensions(ownerType));
            scope = Scopes.scopeFor((Iterable)this.typeSystem.getOperationExtensions(ownerType), (IScope)scope);
        }
        if (ownerType instanceof EnumerationType) {
            scope = this.addScopeForEnumType((EnumerationType)ownerType, scope, predicate);
        }
        if (ownerType instanceof ComplexType) {
            scope = this.scopeForComplexTypeOwner((ComplexType)ownerType, scope, predicate, element);
        }
        return scope;
    }

    protected IScope scopeForComplexTypeOwner(ComplexType ownerType, IScope scope, Predicate<IEObjectDescription> predicate, EObject element) {
        return this.addScopeForComplexType(ownerType, scope, predicate);
    }

    public IScope scope_FeatureCall_feature(MetaCall context, EReference reference) {
        Predicate<IEObjectDescription> predicate = this.calculateFilterPredicate((EObject)context, reference);
        Expression owner = context.getOwner();
        EObject element = null;
        if (owner instanceof ElementReferenceExpression) {
            element = ((ElementReferenceExpression)owner).getReference();
        } else if (owner instanceof FeatureCall) {
            element = ((FeatureCall)owner).getFeature();
        } else {
            return this.getDelegate().getScope((EObject)context, reference);
        }
        IScope scope = IScope.NULLSCOPE;
        if (element instanceof MetaComposite) {
            boolean _greaterThan;
            int _size = ((MetaComposite)element).getMetaFeatures().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                scope = Scopes.scopeFor((Iterable)((MetaComposite)element).getMetaFeatures(), (IScope)scope);
                FilteringScope _filteringScope = new FilteringScope(scope, predicate);
                scope = _filteringScope;
            }
        }
        return scope;
    }

    protected IScope addScopeForEnumType(EnumerationType element, IScope parentScope, Predicate<IEObjectDescription> predicate) {
        IScope scope = parentScope;
        scope = Scopes.scopeFor((Iterable)element.getEnumerator(), (IScope)scope);
        FilteringScope _filteringScope = new FilteringScope(scope, predicate);
        scope = _filteringScope;
        return scope;
    }

    protected IScope addScopeForComplexType(ComplexType type, IScope parentScope, Predicate<IEObjectDescription> predicate) {
        IScope scope = parentScope;
        scope = Scopes.scopeFor((Iterable)type.getAllFeatures(), (IScope)scope);
        FilteringScope _filteringScope = new FilteringScope(scope, predicate);
        scope = _filteringScope;
        return scope;
    }

    protected IScope addScopeForPackage(Package pkg, IScope parentScope, Predicate<IEObjectDescription> predicate, Expression context, EReference reference) {
        IScope scope = parentScope;
        scope = Scopes.scopeFor((Iterable)pkg.getMember(), (IScope)scope);
        FilteringScope _filteringScope = new FilteringScope(scope, predicate);
        scope = _filteringScope;
        return scope;
    }

    protected IScope addScopeForInternalPackage(Package pkg, IScope parentScope, Predicate<IEObjectDescription> predicate, EReference reference) {
        EList namespaceMembers = pkg.getMember();
        IScope scope = parentScope;
        scope = Scopes.scopeFor((Iterable)namespaceMembers, (IScope)scope);
        FilteringScope _filteringScope = new FilteringScope(scope, predicate);
        scope = _filteringScope;
        return scope;
    }

    protected Predicate<IEObjectDescription> calculateFilterPredicate(EObject context, EReference reference) {
        Predicate<IEObjectDescription> predicate = null;
        EObject container = context;
        EReference ref = reference;
        boolean break_ = false;
        while (container != null && !break_) {
            predicate = this.predicateProvider.getPredicate(container.eClass(), ref);
            if (predicate != ContextPredicateProvider.EMPTY_PREDICATE) {
                break_ = true;
            }
            EStructuralFeature _eContainingFeature = container.eContainingFeature();
            ref = (EReference)_eContainingFeature;
            container = container.eContainer();
        }
        return predicate;
    }

    protected IScope getNamedTopLevelScope(EObject context, EReference reference) {
        ArrayList scopeCandidates = Lists.newArrayList();
        ScopedElement scopedElement = this.getScopedElement(context);
        if (scopedElement == null) {
            return IScope.NULLSCOPE;
        }
        EList scopes = scopedElement.getScopes();
        for (Scope scope : scopes) {
            String name;
            if (!(scope instanceof InterfaceScope) || (name = ((InterfaceScope)scope).getName()) == null || name.trim().length() <= 0) continue;
            scopeCandidates.add(scope);
        }
        return Scopes.scopeFor((Iterable)scopeCandidates);
    }

    protected IScope getUnnamedTopLevelScope(EObject context, EReference reference) {
        ArrayList scopeCandidates = Lists.newArrayList();
        ScopedElement scopedElement = this.getScopedElement(context);
        if (scopedElement == null) {
            return IScope.NULLSCOPE;
        }
        EList scopes = scopedElement.getScopes();
        for (Scope scope : scopes) {
            if (scope instanceof InterfaceScope) {
                String name = ((InterfaceScope)scope).getName();
                if (name != null && name.trim().length() != 0) continue;
                scopeCandidates.addAll(((InterfaceScope)scope).getDeclarations());
                continue;
            }
            if (!(scope instanceof InternalScope)) continue;
            scopeCandidates.addAll(((InternalScope)scope).getDeclarations());
        }
        IScope globalScope = this.getDelegate().getScope(context, reference);
        Resource _statechartResource = this.getStatechartResource(context);
        GlobalTypeScope scope_1 = new GlobalTypeScope(globalScope, _statechartResource);
        return Scopes.scopeFor((Iterable)scopeCandidates, (IScope)scope_1);
    }

    protected ScopedElement getScopedElement(EObject context) {
        ScopedElement scopedElement = (ScopedElement)EcoreUtil2.getContainerOfType((EObject)context, ScopedElement.class);
        StatechartSpecification spec = (StatechartSpecification)EcoreUtil2.getContainerOfType((EObject)context, StatechartSpecification.class);
        if (spec != null && scopedElement != null) {
            return scopedElement;
        }
        return this.getStatechart(context);
    }

    protected Statechart getStatechart(EObject context) {
        return this.utils.getStatechart(context);
    }

    protected Resource getStatechartResource(EObject context) {
        Resource _eResource_1;
        Resource _elvis = null;
        Statechart _statechart = this.getStatechart(context);
        Resource _eResource = null;
        if (_statechart != null) {
            _eResource = _statechart.eResource();
        }
        _elvis = _eResource != null ? _eResource : (_eResource_1 = context.eResource());
        return _elvis;
    }
}

