/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.scoping;

import com.yakindu.sct.model.sgraph.resource.AbstractSCTResource;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;

public class SharedEditingDomainFactory
extends DiagramEditingDomainFactory
implements TransactionalEditingDomain.Factory {
    public static final String DOMAIN_ID = "com.yakindu.sct.domain";

    public TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain domain = super.createEditingDomain();
        this.setup(domain);
        return domain;
    }

    public TransactionalEditingDomain createEditingDomain(ResourceSet rset) {
        TransactionalEditingDomain domain = super.createEditingDomain(rset);
        this.setup(domain);
        return domain;
    }

    public TransactionalEditingDomain getEditingDomain(ResourceSet rset) {
        TransactionalEditingDomain domain = super.createEditingDomain(rset);
        this.setup(domain);
        return domain;
    }

    protected void setup(final TransactionalEditingDomain editingDomain) {
        editingDomain.setID(DOMAIN_ID);
        this.replaceCrossReferenceAdapterWithNonResolvingAdapter(editingDomain);
        new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public boolean handleResourceDeleted(Resource resource) {
                SharedEditingDomainFactory.this.unloadWithReferences(resource);
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                SharedEditingDomainFactory.this.unloadWithReferences(resource);
                return true;
            }

            public boolean handleResourceChanged(Resource resource) {
                block3: {
                    SharedEditingDomainFactory.this.unloadWithReferences(resource);
                    if (!(resource instanceof AbstractSCTResource)) break block3;
                    return true;
                }
                try {
                    resource.load(resource.getResourceSet().getLoadOptions());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }

            public void dispose() {
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                try {
                    if (delta != null) {
                        delta.accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                IResource resource;
                                if (delta.getKind() == 1 && (resource = delta.getResource()) instanceof IFile) {
                                    URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
                                    Resource existingResource = editingDomain.getResourceSet().getResource(uri, false);
                                    if (existingResource != null && !(existingResource instanceof AbstractSCTResource)) {
                                        SharedEditingDomainFactory.this.unloadWithReferences(existingResource);
                                    }
                                }
                                return true;
                            }
                        });
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void unloadWithReferences(final Resource resource) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)resource);
        if (editingDomain != null) {
            try {
                editingDomain.runExclusive(new Runnable(){

                    @Override
                    public void run() {
                        HashSet<Resource> resourcesToUnload = new HashSet<Resource>();
                        SharedEditingDomainFactory.this.collectTransitiveReferences(resource, resourcesToUnload);
                        resourcesToUnload.add(resource);
                        SharedEditingDomainFactory.this.collectResourcesWithErrors(resource, resourcesToUnload);
                        for (Resource current : resourcesToUnload) {
                            if (current instanceof AbstractSCTResource || !current.getURI().isPlatform()) continue;
                            current.unload();
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void collectResourcesWithErrors(Resource resource, Set<Resource> resourcesToUnload) {
        for (Resource currentResource : resource.getResourceSet().getResources()) {
            if (currentResource.getErrors().size() <= 0) continue;
            this.collectTransitiveReferences(currentResource, resourcesToUnload);
            resourcesToUnload.add(currentResource);
        }
    }

    protected void collectTransitiveReferences(Resource resource, Set<Resource> references) {
        EList resources = resource.getResourceSet().getResources();
        for (Resource currentResource : resources) {
            Collection allImports = EMFCoreUtil.getImports((Resource)currentResource);
            for (Resource currentImport : allImports) {
                if (currentImport != resource || references.contains(currentResource)) continue;
                references.add(currentResource);
                this.collectTransitiveReferences(currentResource, references);
            }
        }
    }

    protected void replaceCrossReferenceAdapterWithNonResolvingAdapter(TransactionalEditingDomain domain) {
        CrossReferenceAdapter adapter = this.getCrossReferenceAdapter(domain);
        if (adapter != null) {
            adapter.unsetTarget((Notifier)domain.getResourceSet());
            domain.getResourceSet().eAdapters().remove((Object)adapter);
            domain.getResourceSet().eAdapters().add((Object)new CrossReferenceAdapter(false));
        }
    }

    protected CrossReferenceAdapter getCrossReferenceAdapter(TransactionalEditingDomain domain) {
        EList eAdapters = domain.getResourceSet().eAdapters();
        for (Adapter adapter : eAdapters) {
            if (!(adapter instanceof CrossReferenceAdapter)) continue;
            return (CrossReferenceAdapter)adapter;
        }
        return null;
    }
}

