/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.sct.model.sgraph.CompositeElement;
import com.yakindu.sct.model.sgraph.Entry;
import com.yakindu.sct.model.sgraph.Exit;
import com.yakindu.sct.model.sgraph.ReactionProperty;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.sgraph.util.SgraphExtensions;
import com.yakindu.sct.model.stext.concepts.EntryTransition;
import com.yakindu.sct.model.stext.concepts.ExitTransition;
import com.yakindu.sct.model.stext.stext.EntryPointSpec;
import com.yakindu.sct.model.stext.stext.ExitPointSpec;
import com.yakindu.sct.model.stext.validation.STextBaseValidator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class EntryExitPointValidator
extends STextBaseValidator {
    @Inject
    @Extension
    protected ExitTransition _exitTransition;
    @Inject
    @Extension
    protected EntryTransition _entryTransition;
    @Inject
    @Extension
    protected SgraphExtensions _sgraphExtensions;
    public static final String EXITPOINTSPEC_WITH_TRIGGER = "Transition with an exit point spec does not have a trigger or guard.";
    public static final String ONLY_FIRST_ENTRY_POINT_WILL_BE_USED = "Ignoring additional entry points. Using only the first: '%s'";
    public static final String ENTRY_UNUSED = "The named entry '%s' is not used by incoming transitions.";
    public static final String ENTRY_NOT_EXIST = "The named entry does not exist: ";
    public static final String TRANSITION_UNBOUND_DEFAULT_ENTRY_POINT = "Target state '%s' has regions without 'default' entries.";
    public static final String TRANSITION_UNBOUND_NAMED_ENTRY_POINT = "Target state '%s' has regions without named entries: ";
    public static final String REGION_UNBOUND_DEFAULT_ENTRY_POINT = "Region%s must have a 'default' entry.";
    public static final String REGION_UNBOUND_NAMED_ENTRY_POINT = "Region%s should have a named entry to support transitions entry specification: ";
    public static final String EXIT_UNUSED = "Exit%s is not connected to any outgoing transitions.";
    public static final String EXIT_NEVER_USED = "The named exit is not used: ";

    @Check(value=CheckType.FAST)
    public void checkExitPointSpecWithTrigger(Transition it) {
        if (!IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)it.getProperties(), ExitPointSpec.class)) && it.getTrigger() != null && it.getSource() instanceof State) {
            this.error(EXITPOINTSPEC_WITH_TRIGGER, (EObject)it, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkOnlyOneEntryPointSpecIsUsed(Transition transition) {
        boolean _greaterThan;
        int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)transition.getProperties(), EntryPointSpec.class));
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            this.warning(String.format(ONLY_FIRST_ENTRY_POINT_WILL_BE_USED, ((EntryPointSpec)IterableExtensions.head((Iterable)Iterables.filter((Iterable)transition.getProperties(), EntryPointSpec.class))).getEntrypoint()), (EObject)transition, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkUnusedEntry(Entry entry) {
        if (entry.getParentRegion().getComposite() instanceof State && entry.getIncomingTransitions().isEmpty()) {
            boolean _not;
            CompositeElement _composite = entry.getParentRegion().getComposite();
            State state = (State)_composite;
            boolean _isDefault = entry.isDefault();
            boolean bl = _not = !_isDefault;
            if (_not) {
                Functions.Function1 _function = it -> it.getProperties();
                Functions.Function1 _function_1 = p -> entry.getName().equals(p.getEntrypoint());
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)state.getIncomingTransitions(), (Functions.Function1)_function)), EntryPointSpec.class), (Functions.Function1)_function_1));
                if (_isEmpty) {
                    this.warning(String.format(ENTRY_UNUSED, entry.getName()), (EObject)entry, null, -1);
                }
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkUnboundEntryPoints(State state) {
        boolean _isComposite = state.isComposite();
        if (_isComposite) {
            boolean _isEmpty_2;
            boolean _not_2;
            boolean _not;
            List<List<Transition>> transitions = this._entryTransition.getEntrySpecSortedTransitions((List<Transition>)state.getIncomingTransitions());
            HashMap regions = null;
            boolean _isEmpty = transitions.get(0).isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                boolean _not_1;
                regions = this._sgraphExtensions.getRegionsWithoutDefaultEntry((List)state.getRegions());
                boolean _isEmpty_1 = regions.isEmpty();
                boolean bl2 = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    List<Transition> _get = transitions.get(0);
                    for (Transition transition : _get) {
                        this.error(String.format(TRANSITION_UNBOUND_DEFAULT_ENTRY_POINT, transition.getTarget().getName()), (EObject)transition, null, -1);
                    }
                    Set _keySet = regions.keySet();
                    for (Region region : _keySet) {
                        boolean _tripleEquals;
                        Object _xifexpression = null;
                        String _name = region.getName();
                        boolean bl3 = _tripleEquals = _name == null;
                        if (_tripleEquals) {
                            _xifexpression = "";
                        } else {
                            String _name_1 = region.getName();
                            String _plus = " '" + _name_1;
                            _xifexpression = _plus + "'";
                        }
                        this.error(String.format(REGION_UNBOUND_DEFAULT_ENTRY_POINT, _xifexpression), (EObject)region, null, -1);
                    }
                }
            }
            boolean bl4 = _not_2 = !(_isEmpty_2 = transitions.get(1).isEmpty());
            if (_not_2) {
                if (regions == null) {
                    regions = this._sgraphExtensions.getRegionsWithoutDefaultEntry((List)state.getRegions());
                }
                List<Transition> _get_1 = transitions.get(1);
                for (Transition transition_1 : _get_1) {
                    boolean hasTargetEntry = true;
                    EList _properties = transition_1.getProperties();
                    for (ReactionProperty property : _properties) {
                        if (!(property instanceof EntryPointSpec)) continue;
                        EntryPointSpec spec = (EntryPointSpec)property;
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("'");
                        String _entrypoint = spec.getEntrypoint();
                        _builder.append(_entrypoint);
                        _builder.append("'");
                        String specName = _builder.toString();
                        Set _keySet_1 = regions.keySet();
                        for (Region region_1 : _keySet_1) {
                            boolean _tripleEquals_1;
                            boolean hasEntry = false;
                            List _get_2 = (List)regions.get(region_1);
                            for (Entry entry : _get_2) {
                                boolean _equals = entry.getName().equals(spec.getEntrypoint());
                                if (!_equals) continue;
                                hasEntry = true;
                            }
                            if (hasEntry) continue;
                            Object _xifexpression_1 = null;
                            String _name_2 = region_1.getName();
                            boolean bl5 = _tripleEquals_1 = _name_2 == null;
                            if (_tripleEquals_1) {
                                _xifexpression_1 = "";
                            } else {
                                String _name_3 = region_1.getName();
                                String _plus_1 = " '" + _name_3;
                                _xifexpression_1 = _plus_1 + "'";
                            }
                            this.error(String.format(REGION_UNBOUND_NAMED_ENTRY_POINT + specName, _xifexpression_1), (EObject)region_1, null, -1);
                            hasTargetEntry = false;
                        }
                        if (!hasTargetEntry) {
                            this.error(String.format(TRANSITION_UNBOUND_NAMED_ENTRY_POINT + specName, transition_1.getTarget().getName()), (EObject)transition_1, null, -1);
                        }
                        boolean usingEntry = false;
                        EList _regions = state.getRegions();
                        for (Region region_2 : _regions) {
                            EList vertices = region_2.getVertices();
                            for (Vertex vertice : vertices) {
                                boolean _equals;
                                if (!(vertice instanceof Entry) || !(_equals = spec.getEntrypoint().equals(((Entry)vertice).getName()))) continue;
                                usingEntry = true;
                            }
                        }
                        if (usingEntry) continue;
                        this.warning(ENTRY_NOT_EXIST + specName, (EObject)transition_1, null, -1);
                    }
                }
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkUnusedExit(Exit exit) {
        if (exit.getParentRegion().getComposite() instanceof State && exit.getOutgoingTransitions().isEmpty()) {
            boolean _not;
            CompositeElement _composite = exit.getParentRegion().getComposite();
            State state = (State)_composite;
            boolean _isDefault = exit.isDefault();
            boolean bl = _not = !_isDefault;
            if (_not) {
                boolean hasOutgoingTransition = false;
                boolean equalsOutgoingTransition = false;
                Iterator transitionIt = state.getOutgoingTransitions().iterator();
                while (transitionIt.hasNext() && !hasOutgoingTransition) {
                    Transition transition = (Transition)transitionIt.next();
                    boolean bl2 = hasOutgoingTransition = this._exitTransition.isDefaultExitTransition(transition) || this._exitTransition.isNamedExitTransition(transition, exit.getName());
                }
                if (!hasOutgoingTransition) {
                    Object _xifexpression = null;
                    boolean _isBlank = exit.getName().isBlank();
                    if (_isBlank) {
                        _xifexpression = "";
                    } else {
                        String _name = exit.getName();
                        String _plus = " '" + _name;
                        _xifexpression = _plus + "'";
                    }
                    Object exName = _xifexpression;
                    this.error(String.format(EXIT_UNUSED, exName), (EObject)exit, null, -1);
                }
                EList _outgoingTransitions = state.getOutgoingTransitions();
                for (Transition transition : _outgoingTransitions) {
                    EList _properties = transition.getProperties();
                    for (ReactionProperty property : _properties) {
                        String exitpoint;
                        boolean _equals;
                        if (!(property instanceof ExitPointSpec) || !(_equals = (exitpoint = ((ExitPointSpec)property).getExitpoint()).equals(exit.getName()))) continue;
                        equalsOutgoingTransition = true;
                    }
                }
                if (!equalsOutgoingTransition) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(EXIT_NEVER_USED);
                    _builder.append("'");
                    String _name_1 = exit.getName();
                    _builder.append(_name_1);
                    _builder.append("'");
                    this.warning(_builder.toString(), (EObject)exit, null, -1);
                }
            } else {
                boolean hasOutgoingTransition_1 = false;
                Iterator transitionIt_1 = state.getOutgoingTransitions().iterator();
                while (transitionIt_1.hasNext() && !hasOutgoingTransition_1) {
                    hasOutgoingTransition_1 = this._exitTransition.isDefaultExitTransition((Transition)transitionIt_1.next());
                }
                if (!hasOutgoingTransition_1) {
                    Object _xifexpression_1 = null;
                    boolean _isBlank_1 = exit.getName().isBlank();
                    if (_isBlank_1) {
                        _xifexpression_1 = "";
                    } else {
                        String _name_2 = exit.getName();
                        String _plus_1 = " '" + _name_2;
                        _xifexpression_1 = _plus_1 + "'";
                    }
                    String exName_1 = _xifexpression_1;
                    this.error(String.format(EXIT_UNUSED, exName_1), (EObject)exit, null, -1);
                }
            }
        }
    }
}

