/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.validation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.ExpressionsPackage;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.TypesPackage;
import com.yakindu.base.types.TypesUtil;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sgraph.ScopedElement;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.util.ContextElementAdapter;
import com.yakindu.sct.model.stext.concepts.CompletionTransition;
import com.yakindu.sct.model.stext.extensions.STextExtensions;
import com.yakindu.sct.model.stext.services.STextGrammarAccess;
import com.yakindu.sct.model.stext.stext.EventDefinition;
import com.yakindu.sct.model.stext.stext.ImportScope;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.InternalScope;
import com.yakindu.sct.model.stext.stext.OperationDefinition;
import com.yakindu.sct.model.stext.stext.StextPackage;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sct.model.stext.validation.STextBaseValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.nodemodel.BidiIterable;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ScopeValidator
extends STextBaseValidator {
    @Inject
    @Extension
    private IQualifiedNameProvider nameProvider;
    @Inject
    @Extension
    private ExpressionExtensions _expressionExtensions;
    @Inject(optional=true)
    private IPackageImport2URIMapper mapper;
    @Inject
    private STextGrammarAccess grammarAccess;
    @Inject
    @Extension
    protected CompletionTransition _completionTransition;
    @Inject
    @Extension
    protected STextExtensions _sTextExtensions;
    public static final String WARNING_AMBIGOUS_MSG = "%s is ambiguous. Please consider to use fully qualified name.";
    public static final String WARNING_AMBIGOUS_CODE = "ambigousType";
    public static final String FEATURE_CALL_TO_SCOPE = "A variable, event or operation is required.";
    public static final String ONLY_ONE_INTERFACE = "Only one default/unnamed interface is allowed.";
    public static final String DUPLICATE_IMPORT = "Duplicate import '%s'.";
    public static final String ERROR_ASSIGNMENT_TO_READONLY_CODE = "AssignmentToReadonly";
    public static final String ERROR_ASSIGNMENT_TO_READONLY_MSG = "Property '%s' is readonly.";
    public static final String IMPORT_NOT_RESOLVED_MSG = "Import '%s' cannot be resolved.";
    public static final String IMPORT_NOT_RESOLVED_MSG_EXT = " Please check the statechart domain in the statechart properties, e.g. set the C/C++ domain to enable header file imports.";
    public static final String REFERENCE_CONSTANT_BEFORE_DEFINED = "Cannot reference a constant from different scope or before it is defined. '%s' is referring '%s'";
    public static final String INTERNAL_DECLARATION_UNUSED = "Internal declaration '%s' is not used in statechart.";

    @Check(value=CheckType.FAST)
    public void checkAmbigous(TypeSpecifier typedElement) {
        Type type = typedElement.getType();
        EObject _rootContainer = EcoreUtil2.getRootContainer((EObject)type);
        if (_rootContainer instanceof Package) {
            ICompositeNode node = NodeModelUtils.getNode((EObject)typedElement);
            EObject _rootContainer_1 = EcoreUtil2.getRootContainer((EObject)type);
            Set packageContainedTypes = TypesUtil.collectPackageContainedTypes((Package)((Package)_rootContainer_1), (Set)CollectionLiterals.newHashSet());
            if (IterableExtensions.exists((Iterable)packageContainedTypes, it -> it != type && it.getName() != null && it.getName().equals(type.getName())) && node.getText().contains(type.getName()) && !node.getText().contains(TypesUtil.toQualifiedName((EObject)type).toString())) {
                this.warning(String.format(WARNING_AMBIGOUS_MSG, type.getName()), (EStructuralFeature)TypesPackage.Literals.TYPE_SPECIFIER__TYPE, WARNING_AMBIGOUS_CODE, new String[0]);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkFeatureCall(FeatureCall call) {
        EObject _eContainer = call.eContainer();
        if (_eContainer instanceof FeatureCall) {
            return;
        }
        EObject _feature = call.getFeature();
        if (_feature instanceof Scope) {
            this.error(FEATURE_CALL_TO_SCOPE, (EStructuralFeature)ExpressionsPackage.Literals.FEATURE_CALL__FEATURE, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkFeatureCall(ElementReferenceExpression call) {
        EObject _eContainer = call.eContainer();
        if (_eContainer instanceof FeatureCall) {
            return;
        }
        EObject _reference = call.getReference();
        if (_reference instanceof Scope) {
            this.error(FEATURE_CALL_TO_SCOPE, (EStructuralFeature)ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkInterfaceScope(ScopedElement statechart) {
        boolean _greaterThan;
        LinkedList<InterfaceScope> defaultInterfaces = new LinkedList<InterfaceScope>();
        EList _scopes = statechart.getScopes();
        for (Scope scope : _scopes) {
            if (!(scope instanceof InterfaceScope) || ((InterfaceScope)scope).getName() != null) continue;
            defaultInterfaces.add((InterfaceScope)scope);
        }
        int _size = defaultInterfaces.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (InterfaceScope scope_1 : defaultInterfaces) {
                this.error(ONLY_ONE_INTERFACE, (EObject)scope_1, this.grammarAccess.getInterfaceScopeAccess().getInterfaceKeyword_1(), -1, ONLY_ONE_INTERFACE);
            }
        }
    }

    @Check
    public void checkDuplicateImport(ImportScope importScope) {
        Iterable allScopes = Iterables.filter((Iterable)((ScopedElement)EcoreUtil2.getContainerOfType((EObject)importScope, ScopedElement.class)).getScopes(), ImportScope.class);
        EList<String> _imports = importScope.getImports();
        for (String importToCheck : _imports) {
            HashSet allImports = Sets.newHashSet();
            for (ImportScope scope : allScopes) {
                EList<String> _imports_1 = scope.getImports();
                for (String anImport : _imports_1) {
                    if (!anImport.equals(importToCheck) || allImports.add(anImport)) continue;
                    this.warning(String.format(DUPLICATE_IMPORT, importToCheck), (EObject)importScope, (EStructuralFeature)StextPackage.Literals.IMPORT_SCOPE__IMPORTS, importScope.getImports().indexOf((Object)importToCheck));
                }
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkAssignmentToReadonlyVariable(AssignmentExpression exp) {
        EObject referencedObject = this._expressionExtensions.featureOrReference(exp.getVarRef());
        if (referencedObject instanceof Property && ((Property)referencedObject).isReadonly() && !Objects.equals(this.getResource(referencedObject), this.getResource((EObject)exp))) {
            this.error(String.format(ERROR_ASSIGNMENT_TO_READONLY_MSG, ((Property)referencedObject).getName()), (EStructuralFeature)ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION__VAR_REF, ERROR_ASSIGNMENT_TO_READONLY_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkPostFixUnaryExpressionToReadonlyVariable(PostFixUnaryExpression exp) {
        EObject referencedObject = this._expressionExtensions.featureOrReference(exp.getOperand());
        if (referencedObject instanceof Property && ((Property)referencedObject).isReadonly() && !Objects.equals(this.getResource(referencedObject), this.getResource((EObject)exp))) {
            this.error(String.format(ERROR_ASSIGNMENT_TO_READONLY_MSG, ((Property)referencedObject).getName()), (EStructuralFeature)ExpressionsPackage.Literals.UNARY_EXPRESSION__OPERAND, ERROR_ASSIGNMENT_TO_READONLY_CODE, new String[0]);
        }
    }

    @Check
    public void checkImportExists(ImportScope scope) {
        EList<String> imports = scope.getImports();
        for (String packageImport : imports) {
            boolean _not;
            Optional pkImport = this.mapper.findPackageImport(scope.eResource(), packageImport);
            boolean _isPresent = pkImport.isPresent();
            boolean bl = _not = !_isPresent;
            if (!_not) continue;
            String _xifexpression = null;
            _xifexpression = packageImport.endsWith(".ysc") || packageImport.endsWith(".sct") ? IMPORT_NOT_RESOLVED_MSG : "Import '%s' cannot be resolved. Please check the statechart domain in the statechart properties, e.g. set the C/C++ domain to enable header file imports.";
            String msg = _xifexpression;
            this.error(String.format(msg, packageImport), (EObject)scope, (EStructuralFeature)StextPackage.Literals.IMPORT_SCOPE__IMPORTS, imports.indexOf((Object)packageImport));
        }
    }

    protected Resource getResource(EObject context) {
        Adapter _existingAdapter = EcoreUtil.getExistingAdapter((Notifier)context.eResource(), ContextElementAdapter.class);
        ContextElementAdapter provider = (ContextElementAdapter)_existingAdapter;
        if (provider == null) {
            return context.eResource();
        }
        return provider.getElement().eResource();
    }

    @Check(value=CheckType.NORMAL)
    public void checkValueReferenedBeforeDefined(Scope scope) {
        HashSet defined = Sets.newHashSet();
        EList _declarations = scope.getDeclarations();
        for (Declaration declaration : _declarations) {
            boolean _not;
            if (!(declaration instanceof VariableDefinition)) continue;
            boolean _isConst = ((VariableDefinition)declaration).isConst();
            boolean bl = _not = !_isConst;
            if (_not) {
                return;
            }
            Expression initialValue = ((VariableDefinition)declaration).getInitialValue();
            ArrayList toCheck = Lists.newArrayList((Object[])new Expression[]{initialValue});
            TreeIterator eAllContents = initialValue.eAllContents();
            while (eAllContents.hasNext()) {
                EObject next = (EObject)eAllContents.next();
                if (!(next instanceof Expression)) continue;
                toCheck.add((Expression)next);
            }
            for (Expression expression : toCheck) {
                boolean _not_1;
                EObject referencedObject = null;
                if (expression instanceof FeatureCall) {
                    referencedObject = ((FeatureCall)expression).getFeature();
                } else if (expression instanceof ElementReferenceExpression) {
                    referencedObject = ((ElementReferenceExpression)expression).getReference();
                }
                if (!(referencedObject instanceof VariableDefinition)) continue;
                boolean _contains = defined.contains(this.nameProvider.getFullyQualifiedName(referencedObject));
                boolean bl2 = _not_1 = !_contains;
                if (!_not_1) continue;
                this.error(String.format(REFERENCE_CONSTANT_BEFORE_DEFINED, ((VariableDefinition)declaration).getName(), ((VariableDefinition)referencedObject).getName()), (EObject)declaration, (EStructuralFeature)TypesPackage.Literals.PROPERTY__INITIAL_VALUE);
            }
            defined.add(this.nameProvider.getFullyQualifiedName((EObject)declaration));
        }
    }

    @Check(value=CheckType.FAST)
    public void checkUnusedVariablesInInternalScope(InternalScope scope) {
        boolean _tripleNotEquals;
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)scope);
        Resource rootRes = this.getResource(rootContainer);
        Object _objectByType = EcoreUtil.getObjectByType((Collection)rootRes.getContents(), (EClassifier)SGraphPackage.Literals.STATECHART);
        Statechart statechart = (Statechart)_objectByType;
        if (statechart == null) {
            return;
        }
        List allUsedElementReferences = EcoreUtil2.getAllContentsOfType((EObject)statechart, ElementReferenceExpression.class);
        String _specification = statechart.getSpecification();
        boolean bl = _tripleNotEquals = _specification != null;
        if (_tripleNotEquals) {
            EList _declarations = scope.getDeclarations();
            for (Declaration internalDeclaration : _declarations) {
                boolean internalDeclarationUsed = false;
                for (ElementReferenceExpression elementReference : allUsedElementReferences) {
                    EObject _eContainer = elementReference.getReference().eContainer();
                    if (!(_eContainer instanceof InternalScope)) continue;
                    EObject _reference = elementReference.getReference();
                    if (_reference instanceof Property) {
                        if (!((Property)elementReference.getReference()).getName().equals(internalDeclaration.getName()) || !(internalDeclaration instanceof Property)) continue;
                        internalDeclarationUsed = true;
                        continue;
                    }
                    EObject _reference_1 = elementReference.getReference();
                    if (_reference_1 instanceof EventDefinition) {
                        if (!((EventDefinition)elementReference.getReference()).getName().equals(internalDeclaration.getName()) || !(internalDeclaration instanceof EventDefinition)) continue;
                        internalDeclarationUsed = true;
                        continue;
                    }
                    EObject _reference_2 = elementReference.getReference();
                    if (!(_reference_2 instanceof OperationDefinition) || !((OperationDefinition)elementReference.getReference()).getName().equals(internalDeclaration.getName()) || !(internalDeclaration instanceof OperationDefinition)) continue;
                    internalDeclarationUsed = true;
                }
                if (internalDeclarationUsed || !(internalDeclaration instanceof VariableDefinition) && !(internalDeclaration instanceof EventDefinition) && !(internalDeclaration instanceof OperationDefinition)) continue;
                this.warning(String.format(INTERNAL_DECLARATION_UNUSED, internalDeclaration.getName()), (EObject)internalDeclaration, null, -1);
            }
        }
    }

    protected void error(String message, EObject source, Keyword keyword, int index, String code) {
        INode child;
        String[] issueData = null;
        ICompositeNode rootNode = NodeModelUtils.findActualNodeFor((EObject)source);
        if (rootNode != null && (child = this.findNode(source, false, (INode)rootNode, keyword, new int[]{index})) != null) {
            int offset = child.getTotalOffset();
            int length = child.getTotalLength();
            this.getMessageAcceptor().acceptError(message, source, offset, length, code, issueData);
            return;
        }
        this.error(message, source, null, -1, code, new String[0]);
    }

    protected INode findNode(EObject source, boolean sourceFound_finalParam_, INode root, Keyword keyword, int[] index) {
        EObject grammarElement;
        boolean _tripleEquals;
        boolean sourceFound = sourceFound_finalParam_;
        if (sourceFound && root.getSemanticElement() != source) {
            return null;
        }
        EObject _semanticElement = root.getSemanticElement();
        boolean bl = _tripleEquals = _semanticElement == source;
        if (_tripleEquals) {
            sourceFound = true;
        }
        if ((grammarElement = root.getGrammarElement()) instanceof Keyword && keyword.getValue().equals(((Keyword)grammarElement).getValue())) {
            boolean _tripleNotEquals;
            int _get = index[0];
            boolean bl2 = _tripleNotEquals = _get != -1;
            if (_tripleNotEquals) {
                int _postIndx_index = 0;
                int _xblockexpression = 0;
                int _rdIndx_index = _postIndx_index;
                int _postVal_index = _xblockexpression = index[_rdIndx_index];
                int[] _wrVal_index = index;
                int _wrIndx_index = _postIndx_index;
                _wrVal_index[_wrIndx_index] = _postVal_index - 1;
            }
            if (index[0] == 0 || index[0] == -1) {
                return root;
            }
        }
        if (root instanceof ICompositeNode) {
            ICompositeNode node = (ICompositeNode)root;
            BidiIterable _children = node.getChildren();
            for (INode child : _children) {
                INode result = this.findNode(source, sourceFound, child, keyword, index);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }
}

