/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.coverage;

import com.yakindu.sct.simulation.ui.SimulationActivator;
import com.yakindu.sct.simulation.ui.coverage.CoverageColors;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class CoverageImageRenderer {
    private static final String KEY_PREFIX = "scov_";
    private static final Color WHITE = new Color(null, 255, 255, 255);

    public static Image render(float coverage) {
        ImageRegistry imageRegistry = SimulationActivator.getDefault().getImageRegistry();
        Image image = imageRegistry.get(KEY_PREFIX + coverage);
        if (image == null) {
            Image result = CoverageImageRenderer.renderInternal(coverage);
            imageRegistry.put(KEY_PREFIX + coverage, result);
        }
        return imageRegistry.get(KEY_PREFIX + coverage);
    }

    protected static Image renderInternal(float coverage) {
        Image image = new Image((Device)Display.getDefault(), 100, 20);
        GC gc = new GC((Drawable)image);
        gc.setBackground(CoverageColors.GREEN);
        gc.setForeground(WHITE);
        int widthCovered = (int)(coverage * 100.0f);
        gc.fillGradientRectangle(0, 0, widthCovered, 20, true);
        gc.setBackground(CoverageColors.RED);
        gc.setForeground(WHITE);
        gc.fillGradientRectangle(widthCovered, 0, 100 - widthCovered, 20, true);
        gc.dispose();
        return image;
    }
}

