/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.view;

import com.yakindu.sct.simulation.ui.SimulationImages;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class Clock
extends Composite {
    private CLabel timeIconLabel;
    private long currentTime = -1L;
    private static final int FONT_SIZE = 10;
    private static final String FONT = "Courier New";
    private static final Font font = new Font(null, new FontData("Courier New", 10, 0));

    public Clock(Composite parent) {
        super(parent, 0);
        this.createContents();
        this.updateTimestamp(0L);
    }

    protected void createContents() {
        this.setLayout((Layout)new FillLayout());
        this.timeIconLabel = new CLabel((Composite)this, 0);
        this.timeIconLabel.setImage(SimulationImages.SIMULATION_CLOCK.image());
        this.timeIconLabel.setFont(font);
        this.timeIconLabel.setToolTipText("Displays the duration since the simulation is running");
    }

    protected void updateTimestamp(long timestamp) {
        if (timestamp == this.currentTime) {
            return;
        }
        this.currentTime = timestamp;
        String formatDurationHMS = DurationFormatUtils.formatDuration((long)timestamp, (String)(timestamp == 0L || timestamp == Long.MIN_VALUE ? "--:--:--.---" : "HH:mm:ss.SSS"), (boolean)true);
        this.timeIconLabel.setText(formatDurationHMS);
        this.getParent().layout();
    }

    protected String getReadableSimulationTime(long timestamp) {
        long days = TimeUnit.MILLISECONDS.toDays(timestamp);
        long hours = TimeUnit.MILLISECONDS.toHours(timestamp);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(timestamp);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(timestamp);
        return DurationFormatUtils.formatDuration((long)timestamp, (String)((days > 0L ? "dd 'days '" : "") + (hours > 0L ? "HH 'hours '" : "") + (minutes > 0L ? "mm 'minutes '" : "") + (seconds > 0L ? "ss 'seconds '" : "")), (boolean)false);
    }
}

