/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.view;

import com.yakindu.sct.simulation.core.debugmodel.SCTDebugTarget;
import com.yakindu.sct.simulation.ui.SimulationImages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SimulationSessionViewerFactory {
    public static TreeViewer createViewer(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, false, 2, 1);
        comp.setLayoutData((Object)layoutData);
        TreeColumnLayout layout = new TreeColumnLayout();
        comp.setLayout((Layout)layout);
        TreeViewer simulationSessionViewer = new TreeViewer(comp);
        simulationSessionViewer.setContentProvider((IContentProvider)new LaunchContentProvider());
        simulationSessionViewer.setLabelProvider((IBaseLabelProvider)new LaunchLabelProvider());
        return simulationSessionViewer;
    }

    private static final class LaunchContentProvider
    implements ITreeContentProvider {
        private LaunchContentProvider() {
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Launch) {
                return ((Launch)element).getDebugTargets().length > 0;
            }
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Launch) {
                return ((Launch)parentElement).getDebugTargets();
            }
            return null;
        }
    }

    private static final class LaunchLabelProvider
    extends LabelProvider {
        private LaunchLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ILaunch) {
                return ((ILaunch)element).getLaunchConfiguration().getName();
            }
            try {
                return ((SCTDebugTarget)element).getName();
            }
            catch (DebugException e) {
                e.printStackTrace();
                return element.toString();
            }
        }

        public Image getImage(Object element) {
            if (element instanceof Launch) {
                IDebugTarget debugTarget = ((Launch)element).getDebugTarget();
                if (debugTarget != null && debugTarget.isSuspended()) {
                    return DebugPluginImages.getImage((String)"IMG_ELCL_SUSPEND");
                }
                return SimulationImages.LAUNCHER_ICON.image();
            }
            return SimulationImages.SUB_STATECHART_PICTOGRAM.image();
        }
    }
}

