/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.view.editing;

import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.simulation.ui.view.editing.PublicEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerCell;

public class MultiEditingSupport
extends EditingSupport {
    private final PublicEditingSupport[] support;
    private PublicEditingSupport currentActive;

    public MultiEditingSupport(ColumnViewer viewer, PublicEditingSupport ... support) {
        super(viewer);
        this.support = support;
    }

    protected boolean canEdit(Object element) {
        if (element instanceof ExecutionSlot && !((ExecutionSlot)element).isWritable()) {
            return false;
        }
        PublicEditingSupport[] publicEditingSupportArray = this.support;
        int n = this.support.length;
        int n2 = 0;
        while (n2 < n) {
            PublicEditingSupport current = publicEditingSupportArray[n2];
            if (current.canEdit(element)) {
                this.currentActive = current;
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.currentActive.getCellEditor(element);
    }

    protected Object getValue(Object element) {
        return this.currentActive.getValue(element);
    }

    protected void setValue(Object element, Object value) {
        this.currentActive.setValue(element, value);
    }

    public PublicEditingSupport[] getSupport() {
        return this.support;
    }

    protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
        try {
            super.initializeCellEditorValue(cellEditor, cell);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

