/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.view.editing;

import com.yakindu.base.types.Type;
import com.yakindu.sct.simulation.ui.view.editing.ScopeSlotEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class RealEditingSupport
extends ScopeSlotEditingSupport {
    public RealEditingSupport(ColumnViewer viewer, ScopeSlotEditingSupport.ITypeSystemProvider provider) {
        super(viewer, provider);
    }

    @Override
    public CellEditor getCellEditor(Object element) {
        TextCellEditor textCellEditor = new TextCellEditor((Composite)this.getViewer().getControl());
        textCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                String stringValue = (String)value;
                try {
                    Double.parseDouble(stringValue);
                }
                catch (NumberFormatException e) {
                    return "No valid real value!";
                }
                return null;
            }
        });
        return textCellEditor;
    }

    @Override
    public Type getSupportedType() {
        return this.provider.getTypeSystem().getType("real");
    }

    @Override
    protected Object convertValue(Object element, Object value) {
        if (value != null && value instanceof String && ((String)value).trim().length() > 0) {
            return Double.parseDouble((String)value);
        }
        return null;
    }
}

