/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.xtext.utils.gmf.resource;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yakindu.base.xtext.utils.gmf.resource.XMIDirtyResource;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.IDirtyResource;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.shared.Access;

public class DirtyStateListener
implements ResourceSetListener {
    private IDirtyStateManager dirtyStateManager = (IDirtyStateManager)Access.getIDirtyStateManager().get();
    private Map<URI, IDirtyResource> uri2dirtyResource = Maps.newHashMap();

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        ArrayList remainingURIs = Lists.newArrayList(this.uri2dirtyResource.keySet());
        for (Resource currentResource : event.getEditingDomain().getResourceSet().getResources()) {
            if (!(currentResource instanceof XMIResource)) continue;
            XMIResource resource = (XMIResource)currentResource;
            remainingURIs.remove(resource.getURI());
            IDirtyResource dirtyResource = this.uri2dirtyResource.get(resource.getURI());
            if (resource.isModified()) {
                if (dirtyResource != null) continue;
                this.createAndRegisterDirtyState(resource);
                continue;
            }
            if (dirtyResource == null) continue;
            this.uri2dirtyResource.remove(resource.getURI());
            this.dirtyStateManager.discardDirtyState(dirtyResource);
        }
        for (URI remainingURI : remainingURIs) {
            IDirtyResource dirtyResource = this.uri2dirtyResource.get(remainingURI);
            this.dirtyStateManager.discardDirtyState(dirtyResource);
            this.uri2dirtyResource.remove(remainingURI);
        }
    }

    protected boolean createAndRegisterDirtyState(XMIResource resource) {
        IDirtyResource dirtyResource = this.createDirtyResource(resource);
        if (dirtyResource == null) {
            return true;
        }
        boolean isSuccess = this.dirtyStateManager.manageDirtyState(dirtyResource);
        if (isSuccess) {
            this.uri2dirtyResource.put(resource.getURI(), dirtyResource);
        }
        return isSuccess;
    }

    protected IDirtyResource createDirtyResource(XMIResource resource) {
        IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(resource.getURI());
        if (resourceServiceProvider == null) {
            return null;
        }
        return new XMIDirtyResource(resource, resourceServiceProvider);
    }

    public void dispose() {
        if (this.uri2dirtyResource != null) {
            for (IDirtyResource dirtyResource : this.uri2dirtyResource.values()) {
                this.dirtyStateManager.discardDirtyState(dirtyResource);
            }
            this.uri2dirtyResource = null;
        }
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        return null;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public NotificationFilter getFilter() {
        return null;
    }
}

