/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.xtext.utils.gmf.routing;

import com.yakindu.base.xtext.utils.gmf.routing.EdgeLabelQuery;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Vector;
import org.eclipse.gmf.runtime.diagram.ui.figures.LabelLocator;

public class EdgeLabelLocator
extends LabelLocator {
    private PointList oldPointList;
    private Vector oldLabelOffset;
    private boolean isEdgeWithObliqueRoutingStyle;

    public EdgeLabelLocator(IFigure parent, Rectangle bounds, int alignment) {
        super(parent, bounds, alignment);
    }

    public void setFeedbackData(PointList oldPointList, Vector oldLabelOffset, boolean isEdgeWithObliqueRoutingStyle) {
        this.oldPointList = oldPointList;
        this.isEdgeWithObliqueRoutingStyle = isEdgeWithObliqueRoutingStyle;
        this.oldLabelOffset = oldLabelOffset;
    }

    public void eraseFeedbackData() {
        this.oldPointList = null;
        this.oldLabelOffset = null;
        this.isEdgeWithObliqueRoutingStyle = false;
    }

    public void relocate(IFigure target) {
        Dimension preferredSize = target.getPreferredSize();
        LabelLocator currentConstraint = (LabelLocator)target.getParent().getLayoutManager().getConstraint(target);
        Dimension currentExtent = currentConstraint.getSize();
        Dimension size = new Dimension(currentExtent);
        if (currentExtent.width == -1) {
            size.width = preferredSize.width;
        }
        if (currentExtent.height == -1) {
            size.height = preferredSize.height;
        }
        target.setSize(size);
        Point offSet = this.getOffset();
        if (this.oldPointList != null) {
            Vector computedOffSet = this.computeOffSet(size);
            offSet = new Point((int)computedOffSet.x, (int)computedOffSet.y);
        }
        Point centerLocation = EdgeLabelQuery.relativeCenterCoordinateFromOffset(((Connection)this.parent).getPoints(), this.getReferencePoint(), offSet);
        target.setLocation(centerLocation.getTranslated(-1 * size.width / 2, -1 * size.height / 2));
    }

    private Vector computeOffSet(Dimension size) {
        EdgeLabelQuery edgeLabelsComputationUtil = new EdgeLabelQuery(this.oldPointList, this.getPointList(), this.isEdgeWithObliqueRoutingStyle, (Point)this.oldLabelOffset.toPoint(), size, this.getAlignment(), false);
        Point newMethodPoint = edgeLabelsComputationUtil.calculateGMFLabelOffset();
        return new Vector((double)newMethodPoint.x, (double)newMethodPoint.y);
    }
}

