/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.xtext.utils.gmf.routing;

import com.yakindu.base.xtext.utils.gmf.commands.SetLabelsOffsetOperation;
import com.yakindu.base.xtext.utils.gmf.directedit.ExternalXtextLabelEditPart;
import com.yakindu.base.xtext.utils.gmf.figures.SyntaxColoringLabel;
import com.yakindu.base.xtext.utils.gmf.routing.EdgeLabelLocator;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Vector;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;

public class InitialPointsOfRequestDataManager {
    private static final String INITIAL_POINTS_KEY = "InitialPointsManagerForEdgePolicy.initialPointsKey";
    private PointList initialPoints;

    public static PointList getOriginalPoints(LocationRequest request) {
        return (PointList)request.getExtendedData().get(INITIAL_POINTS_KEY);
    }

    public void eraseInitialPoints(Connection connection) {
        this.initialPoints = null;
        for (Object object : connection.getChildren()) {
            Object currentConstraint;
            if (!(object instanceof WrappingLabel) || !((currentConstraint = connection.getLayoutManager().getConstraint((IFigure)((WrappingLabel)object))) instanceof EdgeLabelLocator)) continue;
            ((EdgeLabelLocator)((Object)currentConstraint)).eraseFeedbackData();
        }
    }

    public void storeInitialPointsInRequest(LocationRequest request, ConnectionEditPart connectionEditPart) {
        if (this.initialPoints == null) {
            this.initialPoints = new PointList();
            Connection connection = (Connection)connectionEditPart.getFigure();
            int i = 0;
            while (i < connection.getPoints().size()) {
                this.initialPoints.addPoint(connection.getPoints().getPoint(i).getCopy());
                ++i;
            }
            request.getExtendedData().put(INITIAL_POINTS_KEY, this.initialPoints);
            List children = connectionEditPart.getChildren();
            for (Object child : children) {
                if (!(child instanceof ExternalXtextLabelEditPart)) continue;
                SyntaxColoringLabel figure = ((ExternalXtextLabelEditPart)child).getFigure();
                Object currentConstraint = connection.getLayoutManager().getConstraint((IFigure)figure);
                if (!(currentConstraint instanceof EdgeLabelLocator)) continue;
                EdgeLabelLocator edgeLabelLocator = (EdgeLabelLocator)((Object)currentConstraint);
                edgeLabelLocator.setFeedbackData(this.initialPoints, new Vector((double)edgeLabelLocator.getOffset().x, (double)edgeLabelLocator.getOffset().y), SetLabelsOffsetOperation.isEdgeWithObliqueRoutingStyle(connectionEditPart));
            }
        }
    }
}

