/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.core;

import com.yakindu.core.IEventDriven;
import com.yakindu.core.ITimed;
import com.yakindu.core.ITimerService;
import java.math.BigInteger;
import java.util.PriorityQueue;
import java.util.Queue;

public class VirtualTimer
implements ITimerService {
    private BigInteger stopTime = BigInteger.ZERO;
    protected BigInteger currentTime = BigInteger.ZERO;
    protected long cyclePeriod = 0L;
    protected BigInteger scheduleCount = BigInteger.ZERO;
    private Queue<VirtualTimeTask> tasks = new PriorityQueue<VirtualTimeTask>();

    public VirtualTimer() {
    }

    public VirtualTimer(long cyclePeriod) {
        this.cyclePeriod = cyclePeriod;
    }

    public void timeLeap(long ms) {
        this.stopTime = this.currentTime.add(BigInteger.valueOf(ms));
        this.processTasks();
    }

    public void cycleLeap(long cycles) {
        int elapsedCycles = 0;
        while ((long)elapsedCycles < cycles) {
            CycleTimeEventTask cycleTask = this.getCycleTask();
            if (cycleTask == null) {
                return;
            }
            long timeToNextCycle = cycleTask.nextExecutionTime.subtract(this.currentTime).longValue();
            this.timeLeap(timeToNextCycle);
            ++elapsedCycles;
        }
    }

    @Override
    public void setTimer(ITimed callback, int eventID, long duration, boolean isPeriodical) {
        if (duration <= 0L) {
            duration = 1L;
        }
        VirtualTimeEventTask timeEventTask = new VirtualTimeEventTask(callback, eventID);
        if (isPeriodical) {
            this.schedulePeriodicalTask(timeEventTask, duration, duration);
        } else {
            this.scheduleTask(timeEventTask, duration);
        }
    }

    @Override
    public void unsetTimer(ITimed callback, int eventID) {
        VirtualTimeTask timerTask = this.getTask(callback, eventID);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    public void scheduleTask(VirtualTimeTask task, long interval) {
        task.interval = interval;
        this.scheduleInternal(task, this.currentTime.add(BigInteger.valueOf(interval)), -1L);
    }

    public void schedulePeriodicalTask(VirtualTimeTask task, long interval, long period) {
        this.scheduleInternal(task, this.currentTime.add(BigInteger.valueOf(interval)), period);
    }

    private void scheduleInternal(VirtualTimeTask task, BigInteger time, long period) {
        task.nextExecutionTime = time;
        task.period = period;
        task.scheduleOrder = this.scheduleCount;
        this.scheduleCount = this.scheduleCount.add(BigInteger.ONE);
        this.tasks.add(task);
    }

    protected VirtualTimeTask getTask(ITimed callback, int eventName) {
        for (VirtualTimeTask virtualTimeTask : this.tasks) {
            if (!(virtualTimeTask instanceof VirtualTimeEventTask) || ((VirtualTimeEventTask)virtualTimeTask).getEventId() != eventName || ((VirtualTimeEventTask)virtualTimeTask).getCallback() != callback) continue;
            return virtualTimeTask;
        }
        return null;
    }

    protected CycleTimeEventTask getCycleTask() {
        for (VirtualTimeTask task : this.tasks) {
            if (!(task instanceof CycleTimeEventTask) || task.isCanceled()) continue;
            return (CycleTimeEventTask)task;
        }
        return null;
    }

    protected void processTasks() {
        boolean processTasks = !this.tasks.isEmpty();
        while (processTasks) {
            VirtualTimeTask task = this.tasks.peek();
            if (task == null) break;
            if (task.isCanceled) {
                this.tasks.remove();
                continue;
            }
            if (task.nextExecutionTime.compareTo(this.stopTime) <= 0) {
                this.currentTime = task.nextExecutionTime;
                task = this.tasks.poll();
                if (task.period > -1L) {
                    task.nextExecutionTime = this.currentTime.add(BigInteger.valueOf(task.period));
                    this.tasks.add(task);
                }
                task.run();
                continue;
            }
            this.currentTime = this.stopTime;
            processTasks = false;
        }
    }

    public synchronized void stop() {
        for (VirtualTimeTask timerTask : this.tasks) {
            timerTask.cancel();
        }
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Queue<VirtualTimeTask> queue = this.tasks;
        synchronized (queue) {
            this.tasks.clear();
        }
    }

    public static class CycleTimeEventTask
    extends VirtualTimeTask {
        private IEventDriven statemachine;

        public CycleTimeEventTask(IEventDriven statemachine) {
            this.statemachine = statemachine;
        }

        @Override
        public void run() {
        }
    }

    public static class VirtualTimeEventTask
    extends VirtualTimeTask {
        private final int eventID;
        private ITimed callback;

        public VirtualTimeEventTask(ITimed callback, int eventID) {
            this.callback = callback;
            this.eventID = eventID;
        }

        public int getEventId() {
            return this.eventID;
        }

        public ITimed getCallback() {
            return this.callback;
        }

        @Override
        public void run() {
            this.callback.raiseTimeEvent(this.eventID);
        }
    }

    public static abstract class VirtualTimeTask
    implements Runnable,
    Comparable<VirtualTimeTask> {
        BigInteger nextExecutionTime = BigInteger.ZERO;
        long interval = 0L;
        long period = -1L;
        BigInteger scheduleOrder = BigInteger.ZERO;
        boolean isCanceled = false;

        @Override
        public int compareTo(VirtualTimeTask o) {
            BigInteger diff = BigInteger.ZERO;
            if (!this.nextExecutionTime.equals(o.nextExecutionTime)) {
                diff = this.nextExecutionTime.subtract(o.nextExecutionTime);
            } else {
                if (o instanceof CycleTimeEventTask && !(this instanceof CycleTimeEventTask)) {
                    return -1;
                }
                if (!(o instanceof CycleTimeEventTask) && this instanceof CycleTimeEventTask) {
                    return 1;
                }
                diff = this.scheduleOrder.subtract(o.scheduleOrder);
            }
            return diff.compareTo(BigInteger.ZERO);
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public void cancel() {
            this.isCanceled = true;
        }
    }
}

