/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.sexec.container;

import com.google.inject.Inject;
import com.yakindu.base.expressions.interpreter.base.InterpreterSession;
import com.yakindu.base.expressions.interpreter.scheduling.ITimeTaskScheduler;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.simulation.core.engine.IExecutionControl;
import com.yakindu.sct.simulation.core.launch.AbstractSCTLaunchConfigurationDelegate;
import com.yakindu.sct.simulation.core.sexec.container.AbstractSimulationEngine;

public abstract class InterpreterSessionDebugger
extends AbstractSimulationEngine {
    @Inject
    protected ITimeTaskScheduler timeTaskScheduler;
    @Inject
    protected InterpreterSession session;
    protected ExecutionContext context;

    public void init() {
        try {
            this.doInit();
            this.session.getModeChanged().subscribe(n -> this.modeChanged.next(n));
            this.session.getOnError().subscribe(t -> this.handleException((Throwable)t));
        }
        catch (Exception ex) {
            this.handleException(ex);
            throw new AbstractSCTLaunchConfigurationDelegate.InitializationException(ex.getMessage());
        }
    }

    protected abstract void doInit();

    public void start() {
        try {
            this.session.start();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public boolean canSuspend() {
        return this.session.canSuspend();
    }

    @Override
    public void suspend() {
        try {
            this.session.suspend();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public boolean isSuspended() {
        return this.session.isSuspended();
    }

    @Override
    public boolean canResume() {
        return this.session.canResume();
    }

    @Override
    public void resume() {
        try {
            this.context.getSuspendedElements().clear();
            this.session.resume();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public boolean canTerminate() {
        return this.session.canTerminate();
    }

    @Override
    public void terminate() {
        try {
            this.session.terminate();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public boolean isTerminated() {
        return this.session.isTerminated();
    }

    @Override
    public boolean canStepForward() {
        return this.session.canStep();
    }

    public void stepForward() {
        try {
            this.context.getSuspendedElements().clear();
            this.session.step();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void stepBackward() {
    }

    @Override
    public boolean isStepping() {
        return this.session.isStepping();
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    public void setExecutionContext(ExecutionContext context) {
        this.context = context;
    }

    @Override
    public IExecutionControl getExecutionControl() {
        return this;
    }

    public ITimeTaskScheduler getTimeTaskScheduler() {
        return this.timeTaskScheduler;
    }
}

