/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.sexec.container;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.transformation.FlowOptimizer;
import com.yakindu.sct.model.sexec.transformation.IModelSequencer;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.simulation.core.launch.AbstractSCTLaunchConfigurationDelegate;
import com.yakindu.sct.simulation.core.sexec.container.InterpreterSessionDebugger;
import com.yakindu.sct.simulation.core.sexec.interpreter.StatechartRuntimeExtension;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;

public abstract class StatechartInterpreterSesionDebugger
extends InterpreterSessionDebugger {
    @Inject
    private IModelSequencer sequencer;
    @Inject
    protected StatechartRuntimeExtension statechartRuntime;
    @Inject
    private Provider<FlowOptimizer> optimizerProvider;
    protected boolean initFromContext = false;
    protected Statechart statechart;

    public Statechart getStatechart() {
        return this.statechart;
    }

    @Override
    protected void doInit() {
        if (this.initFromContext) {
            this.initFromContext();
        } else {
            this.initFromStatechart();
        }
    }

    protected void initFromContext() {
        if (this.context == null) {
            throw new AbstractSCTLaunchConfigurationDelegate.InitializationException("No context configured");
        }
    }

    protected void initFromStatechart() {
        IValidationIssueAcceptor.ListBasedValidationIssueAcceptor acceptor = new IValidationIssueAcceptor.ListBasedValidationIssueAcceptor();
        ExecutionFlow flow = this.sequencer.transform(this.statechart, (IValidationIssueAcceptor)acceptor);
        FlowOptimizer optimizer = (FlowOptimizer)this.optimizerProvider.get();
        flow = optimizer.optimize(flow);
        if (acceptor.getTraces(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR).size() > 0) {
            Status errorStatus = new Status(4, "com.yakindu.sct.simulation.core", 765, ((IValidationIssueAcceptor.ValidationIssue)acceptor.getTraces(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR).iterator().next()).toString(), null);
            IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)errorStatus);
            try {
                statusHandler.handleStatus((IStatus)errorStatus, this.getDebugTarget());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.context = this.statechartRuntime.newInstance((Type)flow);
        this.statechartRuntime.init(this.context);
    }
}

