/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.sexec.interpreter;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Singleton;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.IntLiteral;
import com.yakindu.base.expressions.interpreter.AbstractOperationExecutor;
import com.yakindu.base.types.Operation;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class DefaultOperationMockup
extends AbstractOperationExecutor {
    protected MockReturnMap mockReturn = new MockReturnMap();
    protected Multimap<String, List<Object>> verifyCalls = ArrayListMultimap.create();

    public boolean canExecute(ArgumentExpression expression, ExecutionContext context) {
        return true;
    }

    public Object execute(ArgumentExpression expression, ExecutionContext context) {
        return this.execute(expression, context, null);
    }

    public Object execute(ArgumentExpression expression, ExecutionContext context, List<Object> argValues) {
        Operation definition = this.getOperation(expression);
        List<Object> arguments = Arrays.asList(this.provideArguments(argValues, (List)expression.getArguments(), context, definition));
        this.verifyCalls.put((Object)definition.getName(), arguments);
        return this.mockReturn.get(definition.getName(), arguments);
    }

    public boolean wasCalledAtLeast(String operation, List<Object> parameters, IntLiteral times) {
        long t = 1L;
        if (times != null) {
            t = times.getValue();
        }
        return (long)this.getOperationCallCount(operation, parameters) >= t;
    }

    public boolean wasNotCalled(String operation, List<Object> parameters) {
        return this.getOperationCallCount(operation, parameters) == 0;
    }

    public Collection<List<Object>> getOperationCalls(String operation) {
        Collection calledParameters = this.verifyCalls.get((Object)operation);
        return calledParameters;
    }

    public int getOperationCallCount(String operation, List<Object> parameters) {
        Collection<List<Object>> operationCalls = this.getOperationCalls(operation);
        if (operationCalls == null || operationCalls.isEmpty()) {
            return 0;
        }
        if (parameters == null || parameters.isEmpty()) {
            return operationCalls.size();
        }
        return this.getCallCountForParams(operationCalls, parameters);
    }

    public void mockReturnValue(String operation, List<Object> params, Object value) {
        this.mockReturn.put(operation, params, value);
    }

    public void reset() {
        this.mockReturn = new MockReturnMap();
        this.verifyCalls = ArrayListMultimap.create();
    }

    protected int getCallCountForParams(Collection<List<Object>> calledParameters, List<Object> parameters) {
        int times = 0;
        for (List<Object> params : calledParameters) {
            if (!params.equals(parameters)) continue;
            ++times;
        }
        return times;
    }

    protected static class MockReturnMap {
        Map<String, Map<List<Object>, Object>> mockReturn = new HashMap<String, Map<List<Object>, Object>>();

        public void put(String name, List<Object> args, Object value) {
            if (!this.mockReturn.containsKey(name) || args.isEmpty()) {
                HashMap<List<Object>, Object> map = new HashMap<List<Object>, Object>();
                map.put(args, value);
                this.mockReturn.put(name, map);
            } else {
                Map<List<Object>, Object> map = this.mockReturn.get(name);
                map.put(args, value);
            }
        }

        public Object get(String name, List<Object> args) {
            if (this.mockReturn.containsKey(name)) {
                Map<List<Object>, Object> resultMap = this.mockReturn.get(name);
                if (resultMap.containsKey(args)) {
                    return resultMap.get(args);
                }
                return resultMap.get(Collections.emptyList());
            }
            return null;
        }
    }
}

