/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.sexec.interpreter;

import com.google.inject.Inject;
import com.yakindu.sct.model.sexec.ReactionFired;
import com.yakindu.sct.model.sexec.Trace;
import com.yakindu.sct.model.sexec.TraceBeginRunCycle;
import com.yakindu.sct.model.sexec.TraceEndRunCycle;
import com.yakindu.sct.model.sexec.TraceNodeExecuted;
import com.yakindu.sct.model.sexec.TraceStateEntered;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.simulation.core.coverage.Measurement;
import com.yakindu.sct.simulation.core.coverage.MeasurementContext;
import com.yakindu.sct.simulation.core.coverage.MeasurementExtension;
import com.yakindu.sct.simulation.core.sexec.interpreter.ITraceStepInterpreter;
import org.eclipse.emf.ecore.EObject;

public class DefaultTraceStepInterpreter
implements ITraceStepInterpreter {
    @Inject
    protected MeasurementExtension extension;
    @Inject
    protected MeasurementContext measurementContext;

    @Override
    public void evaluate(Trace trace, ExecutionContext context) {
        EObject sourceElement;
        if (trace instanceof TraceBeginRunCycle) {
            for (EObject element : context.getExecutedElements()) {
                this.increaseVisited(element);
            }
            if (context.getExecutedElements().size() > 0) {
                context.getExecutedElements().clear();
            }
        }
        if (trace instanceof TraceStateEntered) {
            TraceStateEntered traceState = (TraceStateEntered)trace;
            this.increaseVisited(traceState.getState().getSourceElement());
        }
        if (trace instanceof ReactionFired && (sourceElement = ((ReactionFired)trace).getReaction().getSourceElement()) != null) {
            context.getExecutedElements().add(sourceElement);
            this.increaseVisited(sourceElement);
        }
        if (trace instanceof TraceNodeExecuted) {
            TraceNodeExecuted traceNode = (TraceNodeExecuted)trace;
            this.increaseVisited(traceNode.getNode().getSourceElement());
        }
        if (trace instanceof TraceEndRunCycle) {
            this.measurementContext.changed();
        }
    }

    public void increaseVisited(EObject o) {
        if (o == null) {
            return;
        }
        try {
            Measurement current = this.extension.forSubject(this.measurementContext.getRootMeasurement(), (Object)o);
            if (current != null) {
                this.extension.visits(current).increase();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

