/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.sexec.interpreter;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.interpreter.AbstractOperationExecutor;
import com.yakindu.base.expressions.interpreter.context.IExecutionSlotResolver;
import com.yakindu.base.types.Operation;
import com.yakindu.sct.commons.WorkspaceClassLoaderFactory;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.xtext.util.PolymorphicDispatcher;

@Singleton
public class JavaOperationMockup
extends AbstractOperationExecutor {
    @Inject
    protected IExecutionSlotResolver resolver;
    private List<Object> callbacks = Lists.newArrayList();

    public void initOperationCallbacks(IProject project, String[] classes) {
        this.callbacks = Lists.newArrayList();
        ClassLoader classLoader = new WorkspaceClassLoaderFactory().createClassLoader(project, ((Object)((Object)this)).getClass().getClassLoader());
        try {
            if (classes.length > 0) {
                String[] stringArray = classes;
                int n = classes.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if ((string = string.trim()).length() != 0) {
                        Class<?> loadClass = classLoader.loadClass(string);
                        this.callbacks.add(loadClass.newInstance());
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean canExecute(ArgumentExpression expression, ExecutionContext context) {
        for (Object callback : this.callbacks) {
            Class<?> current = callback.getClass();
            while (current != Object.class) {
                Method[] methods;
                Method[] methodArray = methods = current.getDeclaredMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (this.hasSignatureMatch(this.getOperation(expression), method)) {
                        return true;
                    }
                    ++n2;
                }
                current = current.getSuperclass();
            }
        }
        return false;
    }

    public Object execute(ArgumentExpression expression, ExecutionContext context) {
        return this.execute(expression, context, null);
    }

    public Object execute(ArgumentExpression expression, ExecutionContext context, List<Object> argValues) {
        String className;
        Operation definition = this.getOperation(expression);
        List<Object> targets = this.callbacks;
        if (definition.eContainer() instanceof InterfaceScope && (className = ((InterfaceScope)definition.eContainer()).getName()) != null) {
            targets = this.callbacks.stream().filter(c -> className.equals(c.getClass().getSimpleName())).collect(Collectors.toList());
        }
        PolymorphicDispatcher dispatcher = new PolymorphicDispatcher(definition.getName(), definition.getParameters().size(), definition.getParameters().size(), targets.size() > 0 ? targets : this.callbacks);
        try {
            return dispatcher.invoke(this.provideArguments(argValues, (List)expression.getArguments(), context, definition));
        }
        catch (Exception ex) {
            throw new WrappedException("Error during invocation of operation '" + definition.getName() + "' with params " + String.valueOf(definition.getParameters()) + " '", ex);
        }
    }

    protected boolean hasSignatureMatch(Operation definition, Method method) {
        if (!definition.getName().equals(method.getName())) {
            return false;
        }
        return definition.getParameters().size() == method.getParameterTypes().length;
    }
}

