/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.ui.contentassist;

import com.yakindu.base.xtext.utils.jface.concurrent.INonBlockingReadAccess;
import java.util.Arrays;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.CompletionProposalComputer;
import org.eclipse.xtext.ui.editor.contentassist.XtextContentAssistProcessor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class AsyncXtextContentAssistProcessor
extends XtextContentAssistProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (this.getContentProposalProvider() == null) {
            return null;
        }
        final IXtextDocument document = (IXtextDocument)viewer.getDocument();
        final CancelableCompletionProposalComputer computer = this.createCompletionProposalComputer(viewer, offset);
        RunnableWithResult.Impl<ICompletionProposal[]> runnable = new RunnableWithResult.Impl<ICompletionProposal[]>(){

            public void run() {
                this.setResult((ICompletionProposal[])INonBlockingReadAccess.nonBlockingPriorityReadOnly((IReadAccess.Priority)document, (IUnitOfWork)new CancelableUnitOfWork<ICompletionProposal[], XtextResource>(){

                    public ICompletionProposal[] exec(XtextResource state, CancelIndicator cancelIndicator) throws Exception {
                        computer.setCancelIndicator(cancelIndicator);
                        try {
                            return computer.exec(state);
                        }
                        catch (Throwable t) {
                            return new ICompletionProposal[0];
                        }
                    }
                }, (Object)new ICompletionProposal[0]));
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec((Runnable)runnable);
        } else {
            runnable.run();
        }
        ICompletionProposal[] result = (ICompletionProposal[])runnable.getResult();
        Arrays.sort(result, this.getCompletionProposalComparator());
        result = this.getCompletionProposalPostProcessor().postProcess(result);
        return result;
    }

    protected CancelableCompletionProposalComputer createCompletionProposalComputer(ITextViewer viewer, int offset) {
        return new CancelableCompletionProposalComputer((CompletionProposalComputer.State)this, viewer, offset);
    }

    public static class CancelableCompletionProposalComputer
    extends CompletionProposalComputer {
        private CancelIndicator cancelIndicator;

        public CancelableCompletionProposalComputer(CompletionProposalComputer.State state, ITextViewer viewer, int offset) {
            super(state, viewer, offset);
        }

        public void setCancelIndicator(CancelIndicator indicator) {
            this.cancelIndicator = indicator;
        }

        public boolean canAcceptMoreProposals() {
            if (this.cancelIndicator == null) {
                return super.canAcceptMoreProposals();
            }
            return !this.cancelIndicator.isCanceled();
        }
    }
}

