/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.ui.contentassist;

import com.google.inject.Singleton;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.model.WorkbenchFile;

@Singleton
public class PackageImportIconProvider
extends WorkbenchFile {
    private Map<ImageDescriptor, Image> fImages = new HashMap<ImageDescriptor, Image>();

    public Image getImageFor(IPackageImport2URIMapper.PackageImport pkImport, IProject contextProject) {
        if (contextProject != null) {
            try {
                IContentType contentType = contextProject.getContentTypeMatcher().findContentTypeFor(pkImport.getName());
                ImageDescriptor image = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(pkImport.getName(), contentType);
                if (image == null) {
                    return this.getDefaultImage();
                }
                return this.getImage(image);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return this.getDefaultImage();
    }

    private Image getDefaultImage() {
        ImageDescriptor imageDesc = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
        return this.getImage(imageDesc);
    }

    private Image getImage(ImageDescriptor descriptor) {
        Image image = this.fImages.get(descriptor);
        if (image != null) {
            return image;
        }
        image = descriptor.createImage();
        if (image != null) {
            this.fImages.put(descriptor, image);
        }
        return image;
    }
}

