/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.ui.contentassist;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.ExpressionBuilder;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.MetaComposite;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.sct.commons.EMFHelper;
import com.yakindu.sct.model.sgraph.Entry;
import com.yakindu.sct.model.sgraph.Exit;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.RegularState;
import com.yakindu.sct.model.sgraph.SpecificationElement;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.stext.extensions.STextExtensions;
import com.yakindu.sct.model.stext.inferrer.STextTypeInferrer;
import com.yakindu.sct.model.stext.services.STextGrammarAccess;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.InternalScope;
import com.yakindu.sct.model.stext.stext.SimpleScope;
import com.yakindu.sct.model.stext.stext.StatechartSpecification;
import com.yakindu.sct.model.stext.stext.StextPackage;
import com.yakindu.sct.model.stext.stext.TransitionReaction;
import com.yakindu.sct.model.stext.stext.TransitionSpecification;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sct.model.stext.ui.contentassist.AbstractSTextProposalProvider;
import com.yakindu.sct.model.stext.ui.contentassist.PackageImportIconProvider;
import com.yakindu.sct.model.stext.ui.contentassist.StringProposalDelegate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.AbstractJavaBasedContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.hover.IEObjectHover;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class STextProposalProvider
extends AbstractSTextProposalProvider {
    protected static final String ICONS_INCLUDE = "icons/Package.png";
    @Inject
    protected STextGrammarAccess grammarAccess;
    private ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    @Inject
    private IPackageImport2URIMapper mapper;
    @Inject
    private STextExtensions utils;
    @Inject
    private PackageImportIconProvider iconProvider;
    @Inject
    private STextTypeInferrer typeInferrer;
    @Inject
    @Extension
    private ExpressionBuilder _expressionBuilder;

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        ArrayList<Keyword> suppressedKeywords = new ArrayList<Keyword>();
        this.addSuppressions(suppressedKeywords, contentAssistContext.getRootModel(), contentAssistContext);
        this.addSuppressions(suppressedKeywords, contentAssistContext.getCurrentModel(), contentAssistContext);
        this.addGeneralSuppressions(suppressedKeywords);
        boolean _contains = suppressedKeywords.contains(keyword);
        boolean bl = _not = !_contains;
        if (_not) {
            IEObjectHover _hover = this.getHover();
            AcceptorDelegate _acceptorDelegate = new AcceptorDelegate(acceptor, _hover);
            super.completeKeyword(keyword, contentAssistContext, (ICompletionProposalAcceptor)_acceptorDelegate);
        }
    }

    protected void _addSuppressions(List<Keyword> suppressKeywords, TransitionSpecification model, ContentAssistContext context) {
        suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getEntryEventAccess().getGroup().eContents()));
        suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getExitEventAccess().getGroup().eContents()));
        suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getExitPointSpecAccess().getGroup().eContents()));
        suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getExitEventAccess().getExitEventAction_0().eContents()));
        suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getExitEventAccess().getExitKeyword_1().eContents()));
    }

    protected void _addSuppressions(List<Keyword> suppressKeywords, SimpleScope model, ContentAssistContext context) {
        suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getInternalScopeAccess().getGroup().eContents()));
        suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getDirectionAccess().getAlternatives().eContents()));
    }

    protected void _addSuppressions(List<Keyword> suppressKeywords, InterfaceScope model, ContentAssistContext context) {
        suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getLocalReactionAccess().getGroup().eContents()));
        suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getAlwaysEventAccess().getGroup().eContents()));
        suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getTimeEventTypeAccess().getAlternatives().eContents()));
    }

    protected void _addSuppressions(List<Keyword> suppressKeywords, FeatureCall featureCall, ContentAssistContext context) {
        boolean _not;
        EObject _feature = featureCall.getFeature();
        boolean bl = _not = !(_feature instanceof Operation);
        if (_not) {
            suppressKeywords.add(this.grammarAccess.getFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_0_2_0_0_0());
        }
        this.suppressMetaCallIfNotApplicable(suppressKeywords, featureCall.getFeature());
    }

    protected void _addSuppressions(List<Keyword> suppressKeywords, ElementReferenceExpression referenceExpression, ContentAssistContext context) {
        boolean _not;
        EObject _reference = referenceExpression.getReference();
        boolean bl = _not = !(_reference instanceof Operation);
        if (_not) {
            suppressKeywords.add(this.grammarAccess.getElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_2_0_0_0());
        }
        this.suppressMetaCallIfNotApplicable(suppressKeywords, referenceExpression.getReference());
    }

    protected void _addSuppressions(List<Keyword> keywords, StatechartSpecification model, ContentAssistContext context) {
        EObject _grammarElement_1;
        Keyword prefix;
        boolean _equals;
        EObject _grammarElement = context.getLastCompleteNode().getGrammarElement();
        if (_grammarElement instanceof Keyword && (_equals = ":".equals((prefix = (Keyword)(_grammarElement_1 = context.getLastCompleteNode().getGrammarElement())).getValue()))) {
            keywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getInternalScopeAccess().getGroup().eContents()));
            keywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getInterfaceScopeAccess().getGroup().eContents()));
            keywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getImportScopeAccess().getGroup().eContents()));
        }
    }

    protected void _addSuppressions(List<Keyword> suppressKeywords, InternalScope model, ContentAssistContext context) {
        suppressKeywords.add(this.grammarAccess.getDirectionAccess().getINInKeyword_0_0());
        suppressKeywords.add(this.grammarAccess.getDirectionAccess().getOUTOutKeyword_1_0());
    }

    protected void _addSuppressions(List<Keyword> suppressKeywords, Object model, ContentAssistContext context) {
    }

    protected void suppressMetaCallIfNotApplicable(List<Keyword> suppressKeywords, EObject obj) {
        if (!(obj instanceof MetaComposite) || ((MetaComposite)obj).getMetaFeatures().isEmpty()) {
            suppressKeywords.add(this.grammarAccess.getFeatureCallAccess().getFullStopCommercialAtKeyword_1_0_0_1_1());
            suppressKeywords.add(this.grammarAccess.getSimpleFeatureCallAccess().getFullStopCommercialAtKeyword_1_0_1_1());
        }
    }

    protected void addGeneralSuppressions(List<Keyword> suppressKeywords) {
        suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getInitializationExpressionAccess().getGroup().eContents()));
    }

    protected List<Keyword> getKeywords(EList<EObject> list) {
        ArrayList<Keyword> keywords = new ArrayList<Keyword>();
        for (EObject eObject : list) {
            if (eObject instanceof Keyword) {
                keywords.add((Keyword)eObject);
                continue;
            }
            if (!(eObject instanceof EnumLiteralDeclaration)) continue;
            keywords.add(((EnumLiteralDeclaration)eObject).getLiteral());
        }
        return keywords;
    }

    protected Function<IEObjectDescription, ICompletionProposal> getProposalFactory(String ruleName, final ContentAssistContext contentAssistContext) {
        IQualifiedNameConverter _qualifiedNameConverter = this.getQualifiedNameConverter();
        return new AbstractJavaBasedContentProposalProvider.DefaultProposalCreator((AbstractJavaBasedContentProposalProvider)this, contentAssistContext, ruleName, _qualifiedNameConverter){

            public ICompletionProposal apply(IEObjectDescription candidate) {
                Operation operation;
                ICompletionProposal proposal = super.apply(candidate);
                EObject eObjectOrProxy = candidate.getEObjectOrProxy();
                boolean _eIsProxy = eObjectOrProxy.eIsProxy();
                if (_eIsProxy) {
                    return proposal;
                }
                if (eObjectOrProxy instanceof ComplexType) {
                    EObject _eContainer_1;
                    boolean _isNullOrEmpty;
                    boolean _not;
                    boolean _and = false;
                    boolean _and_1 = false;
                    boolean _equals = candidate.getName().toString().equals(((ComplexType)eObjectOrProxy).getName());
                    if (!_equals) {
                        _and_1 = false;
                    } else {
                        EObject _eContainer = null;
                        if ((ComplexType)eObjectOrProxy != null) {
                            _eContainer = ((ComplexType)eObjectOrProxy).eContainer();
                        }
                        _and_1 = _eContainer instanceof Package;
                    }
                    _and = !_and_1 ? false : (_not = !(_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)((Package)(_eContainer_1 = ((ComplexType)eObjectOrProxy).eContainer())).getName())));
                    if (_and) {
                        return null;
                    }
                }
                if (eObjectOrProxy instanceof Property && proposal != null) {
                    STextProposalProvider.this.fixTypeInfo(proposal, eObjectOrProxy, contentAssistContext.getCurrentModel());
                }
                if (eObjectOrProxy instanceof Operation && (operation = (Operation)eObjectOrProxy).getParameters().size() > 0 && proposal instanceof ConfigurableCompletionProposal) {
                    ConfigurableCompletionProposal configurableProposal = (ConfigurableCompletionProposal)proposal;
                    StringConcatenation _builder = new StringConcatenation();
                    String _replacementString = configurableProposal.getReplacementString();
                    _builder.append(_replacementString);
                    _builder.append("()");
                    configurableProposal.setReplacementString(_builder.toString());
                    int _cursorPosition = configurableProposal.getCursorPosition();
                    int _plus = _cursorPosition + 1;
                    configurableProposal.setCursorPosition(_plus);
                }
                return proposal;
            }
        };
    }

    protected Object _fixTypeInfo(ICompletionProposal proposal, Object element, Object current) {
        return null;
    }

    protected Object _fixTypeInfo(ConfigurableCompletionProposal proposal, Property element, ElementReferenceExpression current) {
        this.defineDisplayString(proposal, this._expressionBuilder._dot((Expression)this._expressionBuilder._ref(current.getReference(), new Expression[0]), (EObject)element, new Expression[0]));
        return null;
    }

    protected Object _fixTypeInfo(ConfigurableCompletionProposal proposal, Property element, FeatureCall current) {
        this.defineDisplayString(proposal, this._expressionBuilder._dot((Expression)EcoreUtil.copy((EObject)current.getOwner()), (EObject)element, new Expression[0]));
        return null;
    }

    protected void defineDisplayString(ConfigurableCompletionProposal proposal, FeatureCall featureCall) {
        ITypeSystemInferrer.InferenceResult result = this.typeInferrer.infer((EObject)featureCall);
        EObject _feature = featureCall.getFeature();
        String _name = ((NamedElement)_feature).getName();
        String _plus = _name + " : ";
        String _string = result.toString();
        String _plus_1 = _plus + _string;
        proposal.setDisplayString(_plus_1);
    }

    public void completeElementReferenceExpression_Reference(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        AbstractElement _terminal = assignment.getTerminal();
        this.lookupCrossReference((CrossReference)_terminal, context, acceptor);
    }

    @Override
    public void completeSimpleElementReferenceExpression_Reference(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        AbstractElement _terminal = assignment.getTerminal();
        this.lookupCrossReference((CrossReference)_terminal, context, acceptor);
    }

    public void completeTypeSpecifier_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        AbstractElement _terminal = assignment.getTerminal();
        this.lookupCrossReference((CrossReference)_terminal, context, acceptor);
    }

    public void complete_BOOL(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposalAcceptor priorityOptimizer = this.getCustomAcceptor(model, "boolean", acceptor);
        ImmutableList _of = ImmutableList.of((Object)"true", (Object)"false", (Object)"yes", (Object)"no");
        for (String s : _of) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(s);
            _builder.append(" - ");
            String _name = ruleCall.getRule().getName();
            _builder.append(_name);
            ICompletionProposal proposal = this.createCompletionProposal(s, _builder.toString(), null, context);
            priorityOptimizer.accept(proposal);
        }
    }

    @Override
    public void completeImportScope_Imports(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StringProposalDelegate stringProposalDelegate = new StringProposalDelegate(acceptor, context);
        Set allImports = this.mapper.getAllImports(model.eResource());
        IProject contextProject = this.getProject(model);
        for (IPackageImport2URIMapper.PackageImport pkgImport : allImports) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("\"");
            String _name = pkgImport.getName();
            _builder.append(_name);
            _builder.append("\"");
            StyledString _computePackageStyledString = this.computePackageStyledString(pkgImport);
            Image _includeImage = this.getIncludeImage(pkgImport, contextProject);
            int _xifexpression = 0;
            boolean _isPlatformResource = pkgImport.getUri().isPlatformResource();
            _xifexpression = _isPlatformResource ? 1 : -1;
            ICompletionProposal doCreateProposal = this.createCompletionProposal(_builder.toString(), _computePackageStyledString, _includeImage, _xifexpression, context.getPrefix(), context);
            stringProposalDelegate.accept(doCreateProposal);
        }
    }

    protected IProject getProject(EObject model) {
        URI emfUri = this.utils.getContextElement(model).eResource().getURI();
        IFile _iFileFromEMFUri = EMFHelper.getIFileFromEMFUri((URI)emfUri);
        IProject _project = null;
        if (_iFileFromEMFUri != null) {
            _project = _iFileFromEMFUri.getProject();
        }
        return _project;
    }

    public ICompletionProposal createCompletionProposal(String proposal, StyledString displayString, Image image, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, displayString, image, this.getPriorityHelper().getDefaultPriority(), contentAssistContext.getPrefix(), contentAssistContext);
    }

    protected Image getIncludeImage(IPackageImport2URIMapper.PackageImport pkgImport, IProject contextProject) {
        return this.iconProvider.getImageFor(pkgImport, contextProject);
    }

    protected StyledString computePackageStyledString(IPackageImport2URIMapper.PackageImport pkgImport) {
        String _name = pkgImport.getName();
        StyledString firstPart = new StyledString(_name);
        StyledString secondPart = this.getPackageImportStyleString(pkgImport.getUri());
        return firstPart.append(secondPart);
    }

    protected StyledString getPackageImportStyleString(URI uri) {
        String _xifexpression = null;
        boolean _isPlatform = uri.isPlatform();
        _xifexpression = _isPlatform ? uri.toPlatformString(true) : uri.toFileString();
        String filePath = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(" ");
        _builder.append("- ");
        _builder.append(filePath, " ");
        GreyoutStyler _greyoutStyler = new GreyoutStyler();
        StyledString secondPart = new StyledString(_builder.toString(), (StyledString.Styler)_greyoutStyler);
        return secondPart;
    }

    protected ICompletionProposalAcceptor getCustomAcceptor(EObject model, String typeName, ICompletionProposalAcceptor acceptor) {
        VariableDefinition vd;
        Object priorityOptimizer = acceptor;
        if (model instanceof VariableDefinition && (vd = (VariableDefinition)model).getType() != null && typeName.equalsIgnoreCase(vd.getType().getName())) {
            priorityOptimizer = new ICompletionProposalAcceptor.Delegate(acceptor){

                public void accept(ICompletionProposal proposal) {
                    STextProposalProvider.this.alterPriority(proposal, 1);
                    super.accept(proposal);
                }
            };
        }
        return priorityOptimizer;
    }

    protected String getDisplayString(EObject element, String qualifiedNameAsString_finalParam_, String shortName) {
        String qualifiedNameAsString = qualifiedNameAsString_finalParam_;
        if (element instanceof Type) {
            return super.getDisplayString(element, qualifiedNameAsString, shortName);
        }
        if (element instanceof RegularState) {
            qualifiedNameAsString = this.getQualifiedNameConverter().toString(this.getQualifiedNameConverter().toQualifiedName(qualifiedNameAsString).skipFirst(1));
            return super.getDisplayString(element, qualifiedNameAsString, shortName);
        }
        if (element == null || element.eIsProxy()) {
            return qualifiedNameAsString;
        }
        Adapter _adapt = this.composedAdapterFactory.adapt((Notifier)element, IItemLabelProvider.class);
        IItemLabelProvider adapter = (IItemLabelProvider)_adapt;
        if (adapter != null) {
            return adapter.getText((Object)element);
        }
        return super.getDisplayString(element, qualifiedNameAsString, shortName);
    }

    public void complete_STRING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_STRING(model, ruleCall, context, this.getCustomAcceptor(model, "string", acceptor));
    }

    public void complete_INT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_INT(model, ruleCall, context, this.getCustomAcceptor(model, "integer", acceptor));
    }

    public void complete_XID(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.complete_ID(model, ruleCall, context, acceptor);
    }

    public void complete_HEX(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposalAcceptor priorityOptimizer = this.getCustomAcceptor(model, "integer", acceptor);
        String proposalText = "0x1";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(proposalText);
        _builder.append(" - ");
        String _name = ruleCall.getRule().getName();
        _builder.append(_name);
        ICompletionProposal proposal = this.createCompletionProposal(proposalText, _builder.toString(), null, context);
        if (proposal instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal;
            int _replacementOffset = configurable.getReplacementOffset();
            int _plus = _replacementOffset + 2;
            configurable.setSelectionStart(_plus);
            int _length = proposalText.length();
            int _minus = _length - 2;
            configurable.setSelectionLength(_minus);
            configurable.setAutoInsertable(false);
            configurable.setSimpleLinkedMode(context.getViewer(), new char[]{Character.valueOf('\t').charValue(), Character.valueOf(' ').charValue()});
        }
        priorityOptimizer.accept(proposal);
    }

    public void complete_DOUBLE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposalAcceptor priorityOptimizer = this.getCustomAcceptor(model, "real", acceptor);
        String proposalText = "0.1";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(proposalText);
        _builder.append(" - ");
        String _name = ruleCall.getRule().getName();
        _builder.append(_name);
        ICompletionProposal proposal = this.createCompletionProposal(proposalText, _builder.toString(), null, context);
        priorityOptimizer.accept(proposal);
    }

    public void complete_IDWithKeywords(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        SpecificationElement contextElement;
        if (model instanceof TransitionReaction && (contextElement = this.utils.getContextElement(model)) instanceof Transition) {
            Transition transition = (Transition)contextElement;
            EObject eContainer = ruleCall.eContainer();
            Vertex state = null;
            boolean entry = false;
            if (eContainer instanceof Assignment) {
                String feature = ((Assignment)eContainer).getFeature();
                boolean _equals = StextPackage.Literals.ENTRY_POINT_SPEC__ENTRYPOINT.getName().equals(feature);
                if (_equals) {
                    state = transition.getTarget();
                    entry = true;
                } else {
                    boolean _equals_1 = StextPackage.Literals.EXIT_POINT_SPEC__EXITPOINT.getName().equals(feature);
                    if (_equals_1) {
                        entry = false;
                        state = transition.getSource();
                    } else {
                        super.complete_ID(model, ruleCall, context, acceptor);
                    }
                }
            }
            if (state instanceof State) {
                this.createContentAssistForEntryAndExit((State)state, entry, context, acceptor);
            }
        }
        super.complete_ID(model, ruleCall, context, acceptor);
    }

    private void createContentAssistForEntryAndExit(State state, boolean entry, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EList _regions = state.getRegions();
        for (Region region : _regions) {
            EList _vertices = region.getVertices();
            for (Vertex vertex : _vertices) {
                boolean _greaterThan_1;
                if (entry) {
                    boolean _greaterThan;
                    if (!(vertex instanceof Entry)) continue;
                    String assist = ((Entry)vertex).getName();
                    int _length = assist.length();
                    boolean bl = _greaterThan = _length > 0;
                    if (!_greaterThan) continue;
                    acceptor.accept(this.createCompletionProposal(assist, context));
                    continue;
                }
                if (!(vertex instanceof Exit)) continue;
                String assist_1 = ((Exit)vertex).getName();
                int _length_1 = assist_1.length();
                boolean bl = _greaterThan_1 = _length_1 > 0;
                if (!_greaterThan_1) continue;
                acceptor.accept(this.createCompletionProposal(assist_1, context));
            }
        }
    }

    @Override
    public void completeActiveStateReferenceExpression_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        AbstractElement _terminal = assignment.getTerminal();
        this.lookupCrossReference((CrossReference)_terminal, context, acceptor);
    }

    private void alterPriority(ICompletionProposal proposal, int delta) {
        if (proposal == null || !(proposal instanceof ConfigurableCompletionProposal)) {
            return;
        }
        ConfigurableCompletionProposal castedProposal = (ConfigurableCompletionProposal)proposal;
        int _priority = castedProposal.getPriority();
        int _plus = _priority + delta;
        castedProposal.setPriority(_plus);
    }

    @XbaseGenerated
    protected void addSuppressions(List<Keyword> suppressKeywords, Object model, ContentAssistContext context) {
        if (model instanceof InterfaceScope) {
            this._addSuppressions(suppressKeywords, (InterfaceScope)model, context);
            return;
        }
        if (model instanceof InternalScope) {
            this._addSuppressions(suppressKeywords, (InternalScope)model, context);
            return;
        }
        if (model instanceof ElementReferenceExpression) {
            this._addSuppressions(suppressKeywords, (ElementReferenceExpression)model, context);
            return;
        }
        if (model instanceof FeatureCall) {
            this._addSuppressions(suppressKeywords, (FeatureCall)model, context);
            return;
        }
        if (model instanceof StatechartSpecification) {
            this._addSuppressions(suppressKeywords, (StatechartSpecification)model, context);
            return;
        }
        if (model instanceof SimpleScope) {
            this._addSuppressions(suppressKeywords, (SimpleScope)model, context);
            return;
        }
        if (model instanceof TransitionSpecification) {
            this._addSuppressions(suppressKeywords, (TransitionSpecification)model, context);
            return;
        }
        if (model != null) {
            this._addSuppressions(suppressKeywords, model, context);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(suppressKeywords, model, context).toString());
    }

    @XbaseGenerated
    protected Object fixTypeInfo(ICompletionProposal proposal, Object element, Object current) {
        if (proposal instanceof ConfigurableCompletionProposal && element instanceof Property && current instanceof ElementReferenceExpression) {
            return this._fixTypeInfo((ConfigurableCompletionProposal)proposal, (Property)element, (ElementReferenceExpression)current);
        }
        if (proposal instanceof ConfigurableCompletionProposal && element instanceof Property && current instanceof FeatureCall) {
            return this._fixTypeInfo((ConfigurableCompletionProposal)proposal, (Property)element, (FeatureCall)current);
        }
        if (proposal != null && element != null && current != null) {
            return this._fixTypeInfo(proposal, element, current);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(proposal, element, current).toString());
    }

    public static class AcceptorDelegate
    implements ICompletionProposalAcceptor {
        private final ICompletionProposalAcceptor delegate;
        private final IEObjectHover hover;

        public AcceptorDelegate(ICompletionProposalAcceptor delegate, IEObjectHover hover) {
            this.delegate = delegate;
            this.hover = hover;
        }

        public void accept(ICompletionProposal proposal) {
            if (proposal instanceof ConfigurableCompletionProposal) {
                Keyword keyword = XtextFactory.eINSTANCE.createKeyword();
                keyword.setValue(((ConfigurableCompletionProposal)proposal).getDisplayString());
                ((ConfigurableCompletionProposal)proposal).setAdditionalProposalInfo((Object)keyword);
                ((ConfigurableCompletionProposal)proposal).setHover(this.hover);
            }
            this.delegate.accept(proposal);
        }

        public boolean canAcceptMoreProposals() {
            return this.delegate.canAcceptMoreProposals();
        }
    }

    public static class GreyoutStyler
    extends StyledString.Styler {
        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = Display.getDefault().getSystemColor(15);
        }
    }

    public static class StrikeThroughStyler
    extends StyledString.Styler {
        public void applyStyles(TextStyle textStyle) {
            textStyle.strikeout = true;
        }
    }
}

