/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.ui.contentassist;

import com.google.inject.Inject;
import com.yakindu.base.expressions.ui.contentassist.AbstractExpressionsProposalProvider;
import com.yakindu.base.types.annotations.DeprecatedAnnotations;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.Extension;

public class ExpressionsProposalProvider
extends AbstractExpressionsProposalProvider {
    @Inject
    @Extension
    protected DeprecatedAnnotations _deprecatedAnnotations;
    protected static final StyledString.Styler DEPRECATED_STYLE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = Display.getCurrent().getSystemColor(16);
            textStyle.strikeout = true;
            textStyle.strikeoutColor = textStyle.foreground;
        }
    };

    @Override
    public void completeFeatureCall_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        AbstractElement _terminal = assignment.getTerminal();
        this.lookupCrossReference((CrossReference)_terminal, context, acceptor);
    }

    protected StyledString getStyledDisplayString(EObject element, String qualifiedName, String shortName) {
        String _displayString = this.getDisplayString(element, qualifiedName, shortName);
        StyledString displayString = new StyledString(_displayString);
        boolean _isDeprecated = this._deprecatedAnnotations.isDeprecated(element);
        if (_isDeprecated) {
            displayString.setStyle(0, displayString.length(), DEPRECATED_STYLE);
        }
        return displayString;
    }
}

