/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.genmodel.ui.wizard;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.yakindu.sct.generator.builder.action.ToggleSCTNatureAction;
import com.yakindu.sct.generator.core.extensions.IGeneratorDescriptor;
import com.yakindu.sct.generator.genmodel.ui.wizard.ModelCreator;
import com.yakindu.sct.generator.genmodel.ui.wizard.SGenWizardPage2;
import com.yakindu.sct.model.sgen.GeneratorModel;
import com.yakindu.sct.ui.wizards.ModelCreationWizardPage;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;

public class SGenNewFileWizard
extends Wizard
implements INewWizard {
    public static final String ID = "com.yakindu.sct.generator.genmodel.ui.SGenNewFileWizard";
    protected ModelCreationWizardPage modelFilePage;
    private IStructuredSelection selection;
    protected SGenWizardPage2 generatorConfigPage;
    @Inject
    private ResourceSet resourceSet;
    @Inject
    private Injector injector;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle("New itemis CREATE SGen Model");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.modelFilePage = new ModelCreationWizardPage("fileName", this.selection, "sgen");
        this.modelFilePage.setTitle("itemis CREATE generator model");
        this.modelFilePage.setDescription("Create a new itemis CREATE generator model");
        this.addPage((IWizardPage)this.modelFilePage);
        this.generatorConfigPage = new SGenWizardPage2("content", this.modelFilePage, this.selection);
        this.injector.injectMembers((Object)this.generatorConfigPage);
        this.generatorConfigPage.setTitle("itemis CREATE generator model configuration");
        this.generatorConfigPage.setDescription("Select the generator type and the content");
        this.addPage((IWizardPage)this.generatorConfigPage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                SGenNewFileWizard.this.ensureSCTNature(SGenNewFileWizard.this.getProject(SGenNewFileWizard.this.modelFilePage.getContainerFullPath()));
                Resource resource = SGenNewFileWizard.this.createDefaultModel(SGenNewFileWizard.this.modelFilePage.getURI());
                SGenNewFileWizard.this.openModel(resource);
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean openModel(Resource model) throws PartInitException {
        String path = model.getURI().toPlatformString(true);
        IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (workspaceResource instanceof IFile) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return page.openEditor((IEditorInput)new FileEditorInput((IFile)workspaceResource), "com.yakindu.sct.generator.genmodel.SGen") != null;
        }
        return false;
    }

    protected void ensureSCTNature(IProject project) throws CoreException {
        if (project.getNature("com.yakindu.sct.builder.SCTNature") == null) {
            new ToggleSCTNatureAction().toggleNature(project);
        }
    }

    protected IProject getProject(IPath containerFullPath) {
        if (containerFullPath.segmentCount() == 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(containerFullPath.lastSegment());
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(containerFullPath).getProject();
    }

    private Resource createDefaultModel(URI uri) {
        List<EObject> selectedObjects = this.generatorConfigPage.getSelectedElements();
        IGeneratorDescriptor selectedGenerator = this.generatorConfigPage.getSelectedGenerator();
        ModelCreator creator = new ModelCreator(selectedGenerator, selectedObjects);
        GeneratorModel model = creator.create();
        Resource resource = this.resourceSet.createResource(uri);
        resource.getContents().add((Object)model);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resource;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean canFinish() {
        boolean complete = super.canFinish();
        if (!complete) {
            return false;
        }
        return this.getContainer().getCurrentPage() != this.modelFilePage;
    }
}

