/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.genmodel.ui.wizard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yakindu.sct.generator.core.extensions.GeneratorExtensions;
import com.yakindu.sct.generator.core.extensions.IGeneratorDescriptor;
import com.yakindu.sct.generator.genmodel.ui.PathToImageResolver;
import com.yakindu.sct.generator.genmodel.ui.wizard.CoreGenerator;
import com.yakindu.sct.generator.genmodel.ui.wizard.TreeExpandingDoubleClickListener;
import com.yakindu.sct.generator.genmodel.ui.wizard.TreePropagatingCheckStateListener;
import com.yakindu.sct.ui.install.InstallWizardOpener;
import com.yakindu.sct.ui.wizards.AbstractWorkspaceLabelProvider;
import com.yakindu.sct.ui.wizards.ModelCreationWizardPage;
import com.yakindu.sct.ui.wizards.WorkspaceTreeContentProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class SGenWizardPage2
extends WizardPage {
    private static final Map<String, CoreGenerator> NATURE_TO_GENERATOR = new TreeMap<String, CoreGenerator>();
    private ComboViewer generatorCombo;
    protected CheckboxTreeViewer resourceTree;
    private final ModelCreationWizardPage fileSelectionPage;
    private final IStructuredSelection selection;
    private Label lblNewLabel;

    static {
        NATURE_TO_GENERATOR.put("org.eclipse.cdt.core.cnature", CoreGenerator.C);
        NATURE_TO_GENERATOR.put("org.eclipse.cdt.core.ccnature", CoreGenerator.Cpp);
        NATURE_TO_GENERATOR.put("org.eclipse.jdt.core.javanature", CoreGenerator.Java);
    }

    protected SGenWizardPage2(String pageName, ModelCreationWizardPage fileSelectionPage, IStructuredSelection selection) {
        super(pageName);
        this.fileSelectionPage = fileSelectionPage;
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createGeneratorCombo(container);
        this.createObjectTree(container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.selectPreferredGenerator();
            this.refreshInput();
        }
    }

    private void createObjectTree(Composite container) {
        this.lblNewLabel = new Label(container, 0);
        this.lblNewLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.lblNewLabel.setText("Choose: " + this.getSelectedGenerator().getKeyword());
        this.resourceTree = new CheckboxTreeViewer(container, 2048);
        this.resourceTree.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.resourceTree.setContentProvider((IContentProvider)new WorkspaceTreeContentProvider());
        this.resourceTree.setLabelProvider((IBaseLabelProvider)new SGenWorkspaceLabelProvider());
        TreePropagatingCheckStateListener checkStateListener = new TreePropagatingCheckStateListener(this.resourceTree){

            @Override
            public void checkStateChanged(CheckStateChangedEvent event) {
                super.checkStateChanged(event);
            }
        };
        this.resourceTree.addCheckStateListener((ICheckStateListener)checkStateListener);
        this.resourceTree.addDoubleClickListener((IDoubleClickListener)new TreeExpandingDoubleClickListener(this.resourceTree, checkStateListener));
        this.resourceTree.setAutoExpandLevel(-1);
        this.resourceTree.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFolder) {
                    return !((IFolder)element).getName().startsWith(".");
                }
                return true;
            }
        }});
    }

    private void createGeneratorCombo(Composite container) {
        Label lblGenerator = new Label(container, 0);
        lblGenerator.setText("Generator");
        this.generatorCombo = new ComboViewer(container, 8);
        this.generatorCombo.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.generatorCombo.setLabelProvider((IBaseLabelProvider)new GeneratorDescriptorLabelProvider());
        this.generatorCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        List<Object> descriptors = Lists.newArrayList((Iterable)GeneratorExtensions.getGeneratorDescriptors());
        descriptors = descriptors.stream().filter(desc -> desc.isPrimary()).collect(Collectors.toList());
        descriptors.sort(Comparator.comparing(IGeneratorDescriptor::getName));
        this.generatorCombo.setInput(descriptors);
        this.generatorCombo.getCombo().select(0);
        this.generatorCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element instanceof InstallMoreGeneratorsItem) {
                    try {
                        SGenWizardPage2.this.getContainer().run(true, true, monitor -> ((InstallMoreGeneratorsItem)element).openInstallWizard(monitor));
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    SGenWizardPage2.this.generatorCombo.getCombo().select(0);
                } else {
                    SGenWizardPage2.this.refreshInput();
                }
            }
        });
        this.generatorCombo.add((Object)new InstallMoreGeneratorsItem());
    }

    private void selectPreferredGenerator() {
        Optional<IGeneratorDescriptor> desc;
        ArrayList descriptors = Lists.newArrayList((Iterable)GeneratorExtensions.getGeneratorDescriptors());
        Collections.sort(descriptors, CoreGenerator.generatorOrder);
        Optional<CoreGenerator> preferredByNature = this.getGeneratorForNature(this.getContextProject());
        if (preferredByNature.isPresent() && (desc = descriptors.stream().filter(d -> d.getId().equals(((CoreGenerator)((Object)((Object)preferredByNature.get()))).getId())).findFirst()).isPresent()) {
            this.generatorCombo.getCombo().select(descriptors.indexOf(desc.get()));
        }
    }

    private Optional<CoreGenerator> getGeneratorForNature(IProject project) {
        if (project == null) {
            return Optional.empty();
        }
        for (Map.Entry<String, CoreGenerator> entry : NATURE_TO_GENERATOR.entrySet()) {
            try {
                if (!project.hasNature(entry.getKey())) continue;
                return Optional.of(entry.getValue());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }

    protected void refreshInput() {
        this.lblNewLabel.setText("Choose: " + this.getSelectedGenerator().getKeyword());
        ((WorkspaceTreeContentProvider)this.resourceTree.getContentProvider()).setContentType(this.getSelectedGenerator().getContentType());
        this.resourceTree.setInput(this.getRelevantProjects());
    }

    protected List<IProject> getRelevantProjects() {
        ArrayList relevantProjects = Lists.newArrayList();
        IProject project = this.getContextProject();
        relevantProjects.add(project);
        relevantProjects.addAll(this.getReferencedProjects(project));
        return relevantProjects;
    }

    protected IProject getContextProject() {
        IPath filePath = this.fileSelectionPage.getFilePath();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        IProject project = file.getProject();
        return project;
    }

    protected List<IProject> getReferencedProjects(IProject project) {
        try {
            IProject[] referencedProjects = project.getReferencedProjects();
            return Arrays.asList(referencedProjects);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public List<EObject> getSelectedElements() {
        Object[] checkedElements;
        ArrayList selectedElements = Lists.newArrayList();
        Object[] objectArray = checkedElements = this.resourceTree.getCheckedElements();
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IFile) {
                selectedElements.add(this.loadReferencedObject((IResource)object));
            }
            ++n2;
        }
        return selectedElements;
    }

    protected EObject loadReferencedObject(IResource resource) {
        URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource emfResource = resourceSet.getResource(uri, true);
        IGeneratorDescriptor desc = this.getSelectedGenerator();
        String className = desc.getElementRefType();
        TreeIterator content = emfResource.getAllContents();
        ArrayList contentList = Lists.newArrayList((Iterator)content);
        for (EObject obj : contentList) {
            if (!obj.eClass().getInstanceClassName().equals(className)) continue;
            return obj;
        }
        for (EObject obj : contentList) {
            EList superClasses = obj.eClass().getEAllSuperTypes();
            for (EClass superClass : superClasses) {
                if (!superClass.getInstanceClassName().equals(className)) continue;
                return obj;
            }
        }
        return null;
    }

    public IGeneratorDescriptor getSelectedGenerator() {
        return (IGeneratorDescriptor)((StructuredSelection)this.generatorCombo.getSelection()).getFirstElement();
    }

    private static class GeneratorDescriptorLabelProvider
    extends LabelProvider {
        private GeneratorDescriptorLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IGeneratorDescriptor) {
                return ((IGeneratorDescriptor)element).getName();
            }
            if (element instanceof InstallMoreGeneratorsItem) {
                return ((InstallMoreGeneratorsItem)element).getText();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IGeneratorDescriptor) {
                return PathToImageResolver.toImage(((IGeneratorDescriptor)element).getImagePath());
            }
            return super.getImage(element);
        }
    }

    protected static class InstallMoreGeneratorsItem {
        private static final String LABS_REPO_URI = "http://updates.yakindu.com/statecharts/labs";

        protected InstallMoreGeneratorsItem() {
        }

        public String getText() {
            return "Install more...";
        }

        public void openInstallWizard(IProgressMonitor monitor) {
            HashMap deps = Maps.newHashMap();
            deps.put(LABS_REPO_URI, Collections.emptySet());
            new InstallWizardOpener().open((Map)deps, monitor);
        }
    }

    public static class SGenWorkspaceLabelProvider
    extends AbstractWorkspaceLabelProvider {
        private Map<ImageDescriptor, Image> fImages = new HashMap<ImageDescriptor, Image>();

        protected Image createImageForFile(IFile file) {
            try {
                if (file.getContentDescription() != null && file.getContentDescription().getContentType() != null) {
                    IContentType contentType = file.getContentDescription().getContentType();
                    ImageDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(file.getName(), contentType);
                    return this.getImage(descriptor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return this.getDefaultImage();
        }

        private Image getDefaultImage() {
            ImageDescriptor imageDesc = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
            return this.getImage(imageDesc);
        }

        private Image getImage(ImageDescriptor descriptor) {
            Image image = this.fImages.get(descriptor);
            if (image != null) {
                return image;
            }
            image = descriptor.createImage();
            if (image != null) {
                this.fImages.put(descriptor, image);
            }
            return image;
        }

        public void dispose() {
            this.fImages.values().forEach(image -> image.dispose());
            super.dispose();
        }
    }
}

