/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.codemodel;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.itemis.create.base.generator.core.GeneratorAssignment;
import com.itemis.create.base.generator.core.codepattern.IMethodCode;
import com.itemis.create.base.generator.core.concepts.Documentation;
import com.itemis.create.base.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.ExpressionBuilder;
import com.yakindu.base.types.AnnotatableElement;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.TypeBuilder;
import com.yakindu.base.types.TypesUtil;
import com.yakindu.base.types.annotations.VisibilityAnnotations;
import com.yakindu.sct.generator.core.codemodel.StateEnum;
import com.yakindu.sct.generator.core.codemodel.StatemachineClass;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.ExecutionScope;
import com.yakindu.sct.model.sexec.ExecutionState;
import com.yakindu.sct.model.sexec.concepts.TriggerWithoutEventMethod;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sexec.extensions.StateVectorExtensions;
import com.yakindu.sct.model.sexec.naming.INamingService;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class StatemachineFunctions {
    @Inject
    @Extension
    protected TypeBuilder _typeBuilder;
    @Inject
    @Extension
    protected ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    protected ExpressionBuilder _expressionBuilder;
    @Inject
    @Extension
    protected StatemachineClass _statemachineClass;
    @Inject
    @Extension
    protected Documentation _documentation;
    @Inject
    @Extension
    protected GeneratorAssignment _generatorAssignment;
    @Inject
    @Extension
    protected IMethodCode _iMethodCode;
    @Inject
    @Extension
    protected INamingService _iNamingService;
    @Inject
    @Extension
    protected StateVectorExtensions _stateVectorExtensions;
    @Inject
    @Extension
    protected StateEnum _stateEnum;
    @Inject
    @Extension
    protected SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    protected TriggerWithoutEventMethod _triggerWithoutEventMethod;
    @Inject
    @Extension
    protected VisibilityAnnotations _visibilityAnnotations;
    @Inject
    @Extension
    protected TypesUtil _typesUtil;

    public boolean defineFunctions(ExecutionFlow flow) {
        boolean _xblockexpression = false;
        ComplexType smClass = this._statemachineClass.stateMachineClass(flow);
        EList _features = smClass.getFeatures();
        Operation _defineIsActive = this.defineIsActive(flow);
        _features.add((Object)_defineIsActive);
        EList _features_1 = smClass.getFeatures();
        Operation _defineIsFinal = this.defineIsFinal(flow);
        _features_1.add((Object)_defineIsFinal);
        EList _features_2 = smClass.getFeatures();
        Operation _defineIsStateActive = this.defineIsStateActive(flow);
        _features_2.add((Object)_defineIsStateActive);
        boolean _xifexpression = false;
        boolean _hasTriggerWithoutEvents = this._triggerWithoutEventMethod.hasTriggerWithoutEvents(flow);
        if (_hasTriggerWithoutEvents) {
            EList _features_3 = smClass.getFeatures();
            Operation _triggerWithoutEvents = this._triggerWithoutEventMethod.triggerWithoutEvents(flow);
            Procedures.Procedure1 _function = it -> {
                Functions.Function0 _function_1 = () -> this._iMethodCode.methodDefinitionCode(it);
                this._generatorAssignment.generateDefinitionWith((EObject)it, _function_1);
            };
            Operation _doubleArrow = (Operation)ObjectExtensions.operator_doubleArrow((Object)_triggerWithoutEvents, (Procedures.Procedure1)_function);
            _xifexpression = _features_3.add((Object)_doubleArrow);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String isActiveName() {
        return "isActive";
    }

    protected Operation defineIsActive(ExecutionFlow flow) {
        Operation __op = this._typeBuilder._op(this.isActiveName(), this._typeBuilder._boolean());
        Procedures.Procedure1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.");
            _builder.newLine();
            this._documentation.documentation((AnnotatableElement)it, _builder.toString());
            this._typeBuilder._public((AnnotatableElement)it);
            Functions.Function0 _function_1 = () -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _visibilityName = this._visibilityAnnotations.visibilityName(this._visibilityAnnotations.getVisibility((AnnotatableElement)it));
                _builder_1.append(_visibilityName);
                _builder_1.append(" ");
                String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(it.getType());
                _builder_1.append(_targetLanguageName);
                _builder_1.append(" ");
                String _name = it.getName();
                _builder_1.append(_name);
                _builder_1.append("()");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("{");
                _builder_1.newLine();
                _builder_1.append("\t");
                _builder_1.append("return ");
                int _size = flow.getStateVector().getSize();
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
                boolean _hasElements = false;
                for (Integer i : _doubleDotLessThan) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder_1.appendImmediate((Object)"||", "\t");
                    }
                    CharSequence _stateConfVector = this.stateConfVector();
                    _builder_1.append((Object)_stateConfVector, "\t");
                    _builder_1.append("[");
                    _builder_1.append((Object)i, "\t");
                    _builder_1.append("] != ");
                    CharSequence _enumAccess = this.enumAccess(flow);
                    _builder_1.append((Object)_enumAccess, "\t");
                    String _name_1 = this._stateEnum.noStateEnumerator(flow).getName();
                    _builder_1.append(_name_1, "\t");
                }
                _builder_1.append(";");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("}");
                _builder_1.newLine();
                return _builder_1.toString();
            };
            this._generatorAssignment.generateDefinitionWith((EObject)it, _function_1);
        };
        Operation method = (Operation)ObjectExtensions.operator_doubleArrow((Object)__op, (Procedures.Procedure1)_function);
        return method;
    }

    public Operation isActive(ExecutionFlow it) {
        Functions.Function1 _function = it_1 -> {
            String _name = it_1.getName();
            String _isActiveName = this.isActiveName();
            return Objects.equals(_name, _isActiveName);
        };
        return (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this._statemachineClass.stateMachineClass(it).getFeatures(), Operation.class), (Functions.Function1)_function));
    }

    public String isFinalName() {
        return "isFinal";
    }

    protected Operation defineIsFinal(ExecutionFlow flow) {
        List[] finalStateImpactVector = this._stateVectorExtensions.finalStateImpactVector(flow);
        Operation __op = this._typeBuilder._op(this.isFinalName(), this._typeBuilder._boolean());
        Procedures.Procedure1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Checks whether all active states are final. If there are no active states then the state machine is considered being inactive.");
            _builder.newLine();
            this._documentation.documentation((AnnotatableElement)it, _builder.toString());
            this._typeBuilder._public((AnnotatableElement)it);
            Functions.Function0 _function_1 = () -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _visibilityName = this._visibilityAnnotations.visibilityName(this._visibilityAnnotations.getVisibility((AnnotatableElement)it));
                _builder_1.append(_visibilityName);
                _builder_1.append(" ");
                String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(it.getType());
                _builder_1.append(_targetLanguageName);
                _builder_1.append(" ");
                String _name = it.getName();
                _builder_1.append(_name);
                _builder_1.append("()");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("{");
                _builder_1.newLine();
                boolean _isCompletelyCovered = this._stateVectorExtensions.isCompletelyCovered(finalStateImpactVector);
                if (_isCompletelyCovered) {
                    _builder_1.append("\t");
                    _builder_1.append("return ");
                    int _size = ((List)Conversions.doWrapArray((Object)finalStateImpactVector)).size();
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
                    boolean _hasElements = false;
                    for (Integer i : _doubleDotLessThan) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder_1.appendImmediate((Object)" && ", "\t");
                        }
                        _builder_1.append("(");
                        List _get = finalStateImpactVector[i];
                        boolean _hasElements_1 = false;
                        for (ExecutionState fs : _get) {
                            boolean _equals;
                            if (!_hasElements_1) {
                                _hasElements_1 = true;
                            } else {
                                _builder_1.appendImmediate((Object)" || ", "\t");
                            }
                            CharSequence _stateConfVector = this.stateConfVector();
                            _builder_1.append((Object)_stateConfVector, "\t");
                            _builder_1.append("[");
                            _builder_1.append((Object)i, "\t");
                            _builder_1.append("] == ");
                            int _offset = fs.getStateVector().getOffset();
                            boolean bl = _equals = _offset == i;
                            if (_equals) {
                                CharSequence _enumAccess = this.enumAccess(flow);
                                _builder_1.append((Object)_enumAccess, "\t");
                                String _name_1 = this._stateEnum.enumerator(fs).getName();
                                _builder_1.append(_name_1, "\t");
                                continue;
                            }
                            CharSequence _enumAccess_1 = this.enumAccess(flow);
                            _builder_1.append((Object)_enumAccess_1, "\t");
                            String _name_2 = this._stateEnum.noStateEnumerator(flow).getName();
                            _builder_1.append(_name_2, "\t");
                        }
                        _builder_1.append(")");
                    }
                    _builder_1.append(";");
                    _builder_1.newLineIfNotEmpty();
                } else {
                    _builder_1.append("\t");
                    _builder_1.append("return false;");
                    _builder_1.newLine();
                }
                _builder_1.append("}");
                _builder_1.newLine();
                return _builder_1.toString();
            };
            this._generatorAssignment.generateDefinitionWith((EObject)it, _function_1);
        };
        Operation method = (Operation)ObjectExtensions.operator_doubleArrow((Object)__op, (Procedures.Procedure1)_function);
        return method;
    }

    public Operation isFinal(ExecutionFlow it) {
        Functions.Function1 _function = it_1 -> {
            String _name = it_1.getName();
            String _isFinalName = this.isFinalName();
            return Objects.equals(_name, _isFinalName);
        };
        return (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this._statemachineClass.stateMachineClass(it).getFeatures(), Operation.class), (Functions.Function1)_function));
    }

    public String isStateActiveName() {
        return "isStateActive";
    }

    protected Operation defineIsStateActive(ExecutionFlow flow) {
        Operation __op = this._typeBuilder._op(this.isStateActiveName(), this._typeBuilder._boolean());
        Procedures.Procedure1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Returns true if the given state is currently active otherwise false.");
            _builder.newLine();
            this._documentation.documentation((AnnotatableElement)it, _builder.toString());
            this._typeBuilder._public((AnnotatableElement)it);
            Functions.Function0 _function_1 = () -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _visibilityName = this._visibilityAnnotations.visibilityName(this._visibilityAnnotations.getVisibility((AnnotatableElement)it));
                _builder_1.append(_visibilityName);
                _builder_1.append(" ");
                String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(it.getType());
                _builder_1.append(_targetLanguageName);
                _builder_1.append(" ");
                String _name = it.getName();
                _builder_1.append(_name);
                _builder_1.append("(");
                String _name_1 = this._stateEnum.stateEnum(flow).getName();
                _builder_1.append(_name_1);
                _builder_1.append(" state)");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t\t");
                _builder_1.append("{");
                _builder_1.newLine();
                _builder_1.append("\t\t\t");
                _builder_1.append("switch (state)");
                _builder_1.newLine();
                _builder_1.append("\t\t\t");
                _builder_1.append("{");
                _builder_1.newLine();
                EList _states = flow.getStates();
                for (ExecutionState s : _states) {
                    _builder_1.append("\t\t\t\t");
                    _builder_1.append("case ");
                    CharSequence _enumAccess = this.enumAccess(flow);
                    _builder_1.append((Object)_enumAccess, "\t\t\t\t");
                    String _name_2 = this._stateEnum.enumerator(s).getName();
                    _builder_1.append(_name_2, "\t\t\t\t");
                    _builder_1.append(" :");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t\t\t\t");
                    _builder_1.append("{");
                    _builder_1.newLine();
                    _builder_1.append("\t\t\t\t");
                    _builder_1.append("\t");
                    _builder_1.append("return (");
                    boolean _isLeaf = s.isLeaf();
                    if (_isLeaf) {
                        CharSequence _stateConfVector = this.stateConfVector();
                        _builder_1.append((Object)_stateConfVector, "\t\t\t\t\t");
                        _builder_1.append("[");
                        CharSequence _stateVectorDefine = this.stateVectorDefine(s);
                        _builder_1.append((Object)_stateVectorDefine, "\t\t\t\t\t");
                        _builder_1.append("] == ");
                        CharSequence _enumAccess_1 = this.enumAccess(flow);
                        _builder_1.append((Object)_enumAccess_1, "\t\t\t\t\t");
                        String _name_3 = this._stateEnum.enumerator(s).getName();
                        _builder_1.append(_name_3, "\t\t\t\t\t");
                    } else {
                        CharSequence _stateConfVector_1 = this.stateConfVector();
                        _builder_1.append((Object)_stateConfVector_1, "\t\t\t\t\t");
                        _builder_1.append("[");
                        CharSequence _stateVectorDefine_1 = this.stateVectorDefine(s);
                        _builder_1.append((Object)_stateVectorDefine_1, "\t\t\t\t\t");
                        _builder_1.append("] >= ");
                        CharSequence _enumAccess_2 = this.enumAccess(flow);
                        _builder_1.append((Object)_enumAccess_2, "\t\t\t\t\t");
                        String _name_4 = this._stateEnum.enumerator(s).getName();
                        _builder_1.append(_name_4, "\t\t\t\t\t");
                        _builder_1.append(" && ");
                        CharSequence _stateConfVector_2 = this.stateConfVector();
                        _builder_1.append((Object)_stateConfVector_2, "\t\t\t\t\t");
                        _builder_1.append("[");
                        CharSequence _stateVectorDefine_2 = this.stateVectorDefine(s);
                        _builder_1.append((Object)_stateVectorDefine_2, "\t\t\t\t\t");
                        _builder_1.append("] <= ");
                        CharSequence _enumAccess_3 = this.enumAccess(flow);
                        _builder_1.append((Object)_enumAccess_3, "\t\t\t\t\t");
                        String _name_5 = this._stateEnum.enumerator((ExecutionState)this._typesUtil.lastOrNull((Iterable)this._sExecExtensions.subStates((ExecutionScope)s))).getName();
                        _builder_1.append(_name_5, "\t\t\t\t\t");
                    }
                    _builder_1.append(");");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t\t\t\t");
                    _builder_1.append("\t");
                    boolean _needsBreak = this.needsBreak();
                    if (_needsBreak) {
                        _builder_1.append("break;");
                    }
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t\t\t\t");
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("\t\t\t\t");
                _builder_1.append("default:");
                _builder_1.newLine();
                _builder_1.append("\t\t\t\t");
                _builder_1.append("{");
                _builder_1.newLine();
                _builder_1.append("\t\t\t\t\t");
                _builder_1.append("/* State is not active*/");
                _builder_1.newLine();
                _builder_1.append("\t\t\t\t\t");
                _builder_1.append("return false;");
                _builder_1.newLine();
                _builder_1.append("\t\t\t\t\t");
                boolean _needsBreak_1 = this.needsBreak();
                if (_needsBreak_1) {
                    _builder_1.append("break;");
                }
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t\t\t\t");
                _builder_1.append("}");
                _builder_1.newLine();
                _builder_1.append("\t\t\t");
                _builder_1.append("}");
                _builder_1.newLine();
                _builder_1.append("\t\t");
                _builder_1.append("}");
                _builder_1.newLine();
                return _builder_1.toString();
            };
            this._generatorAssignment.generateDefinitionWith((EObject)it, _function_1);
        };
        Operation method = (Operation)ObjectExtensions.operator_doubleArrow((Object)__op, (Procedures.Procedure1)_function);
        return method;
    }

    public Operation isStateActive(ExecutionFlow it) {
        Functions.Function1 _function = it_1 -> {
            String _name = it_1.getName();
            String _isStateActiveName = this.isStateActiveName();
            return Objects.equals(_name, _isStateActiveName);
        };
        return (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this._statemachineClass.stateMachineClass(it).getFeatures(), Operation.class), (Functions.Function1)_function));
    }

    public CharSequence stateConfVector() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("stateConfVector");
        return _builder;
    }

    public CharSequence enumAccess(ExecutionFlow it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public boolean needsBreak() {
        return true;
    }

    public CharSequence stateVectorDefine(ExecutionState it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("scvi_");
        String _shortName = this._iNamingService.getShortName((NamedElement)it);
        _builder.append(_shortName);
        return _builder;
    }
}

