/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.execution;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.generator.core.console.IConsoleLogger;
import com.yakindu.sct.generator.core.execution.IGeneratorEntryExecutor;
import com.yakindu.sct.generator.core.filesystem.DefaultFileSystemAccessFactory;
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public abstract class AbstractGeneratorEntryExecutor
implements IGeneratorEntryExecutor {
    @Inject
    protected DefaultFileSystemAccessFactory factory;
    @Inject
    protected IConsoleLogger logger;
    @Inject
    protected ICoreLibraryHelper helper;
    @Inject
    protected IResourceValidator validator;
    @Inject(optional=true)
    @Named(value="skipValidation")
    protected boolean skipValidation = false;

    protected abstract void execute(ISCTFileSystemAccess var1, GeneratorEntry var2);

    @Override
    public IStatus execute(GeneratorEntry entry) {
        IStatus status = Status.OK_STATUS;
        this.logStart(entry);
        if (this.valid(entry)) {
            try {
                this.execute(this.factory.create(entry), entry);
            }
            catch (Exception ex) {
                this.logger.logError(ex);
                status = new Status(4, "com.yakindu.sct.generator.core", ex.toString());
            }
        } else {
            status = new Status(4, "com.yakindu.sct.generator.core", "The referenced model (" + ((NamedElement)entry.getElementRef()).getName() + ") contains errors. See console log for more details.");
        }
        this.logEnd(entry);
        return status;
    }

    protected void logStart(GeneratorEntry entry) {
        EObject elementRef = entry.getElementRef();
        String elementName = elementRef instanceof NamedElement ? ((NamedElement)elementRef).getName() : elementRef.toString();
        FeatureParameterValue targetProjectValue = this.helper.getTargetProjectValue(entry);
        String target = targetProjectValue != null ? targetProjectValue.getStringValue() : this.factory.create(entry).getOutputConfigurations().get("DEFAULT_OUTPUT").getOutputDirectory();
        String targetKind = targetProjectValue != null ? "project" : "folder";
        this.logger.log(String.format("Generating '%s' to target '%s '%s' ...", elementName, targetKind, target));
    }

    protected void logEnd(GeneratorEntry entry) {
        this.logger.log(((NamedElement)entry.getElementRef()).getName() + " done.");
    }

    protected void logException(Exception ex) {
        this.logger.logError(ex);
    }

    protected boolean valid(GeneratorEntry entry) {
        if (this.skipValidation) {
            return true;
        }
        List issues = this.validator.validate(entry.getElementRef().eResource(), CheckMode.ALL, null);
        Iterable errors = Iterables.filter((Iterable)issues, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                return input.getSeverity() == Severity.ERROR;
            }
        });
        if (!Iterables.isEmpty((Iterable)errors)) {
            this.logger.log("The referenced model (" + ((NamedElement)entry.getElementRef()).getName() + ") contains errors and could not be generated:");
            for (Issue issue : errors) {
                this.logger.log(issue.getMessage());
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isSkipValidation() {
        return this.skipValidation;
    }
}

