/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.extensions;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.types.Direction;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Property;
import com.yakindu.sct.generator.core.codemodel.StatemachineClass;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.concepts.EventQueue;
import com.yakindu.sct.model.stext.stext.EventDefinition;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.InternalScope;
import java.util.List;
import java.util.Objects;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class EventQueueExtension {
    public static final String INCOMING_EVENT_QUEUE_NAME = "incomingEventQueue";
    public static final String INTERNAL_EVENT_QUEUE_NAME = "internalEventQueue";
    public static final String GET_NEXT_EVENT_METHOD_NAME = "getNextEvent";
    public static final String DISPATCH_EVENT_METHOD_NAME = "dispatchEvent";
    public static final String GET_TIME_EVENT_ID_METHOD_NAME = "getTimeEventId";
    @Inject
    @Extension
    protected EventQueue _eventQueue;
    @Inject
    @Extension
    protected StatemachineClass _statemachineClass;

    public List<EventDefinition> eventsHandledByStatemachineClass(ExecutionFlow flow) {
        Functions.Function1 _function = it -> {
            boolean _requiresIncomingEventQueue;
            boolean _or = false;
            boolean _and = false;
            boolean _and_1 = false;
            if (!(it instanceof InterfaceScope)) {
                _and_1 = false;
            } else {
                boolean _isNullOrEmpty;
                String _name = null;
                if ((InterfaceScope)it != null) {
                    _name = ((InterfaceScope)it).getName();
                }
                _and_1 = _isNullOrEmpty = StringExtensions.isNullOrEmpty(_name);
            }
            _and = !_and_1 ? false : (_requiresIncomingEventQueue = this._eventQueue.requiresIncomingEventQueue(flow));
            _or = _and ? true : it instanceof InternalScope;
            return _or;
        };
        Functions.Function1 _function_1 = it -> {
            Functions.Function1 _function_2 = it_1 -> {
                Direction _direction = it_1.getDirection();
                return _direction != Direction.OUT;
            };
            return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)it.getMembers(), EventDefinition.class), (Functions.Function1)_function_2));
        };
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)flow.getScopes(), (Functions.Function1)_function), (Functions.Function1)_function_1)));
    }

    public Property internalEventQueue(ExecutionFlow it) {
        Functions.Function1 _function = it_1 -> {
            String _lowerCase = it_1.getName().toLowerCase();
            String _lowerCase_1 = INTERNAL_EVENT_QUEUE_NAME.toLowerCase();
            return Objects.equals(_lowerCase, _lowerCase_1);
        };
        return (Property)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this._statemachineClass.stateMachineClass(it).getFeatures(), Property.class), (Functions.Function1)_function));
    }

    public Property incomingEventQueue(ExecutionFlow it) {
        Functions.Function1 _function = it_1 -> {
            String _lowerCase = it_1.getName().toLowerCase();
            String _lowerCase_1 = INCOMING_EVENT_QUEUE_NAME.toLowerCase();
            return Objects.equals(_lowerCase, _lowerCase_1);
        };
        return (Property)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this._statemachineClass.stateMachineClass(it).getFeatures(), Property.class), (Functions.Function1)_function));
    }

    public Operation dispatchEventMethod(ExecutionFlow it) {
        Functions.Function1 _function = it_1 -> {
            String _lowerCase = it_1.getName().toLowerCase();
            String _lowerCase_1 = DISPATCH_EVENT_METHOD_NAME.toLowerCase();
            return Objects.equals(_lowerCase, _lowerCase_1);
        };
        return (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this._statemachineClass.stateMachineClass(it).getFeatures(), Operation.class), (Functions.Function1)_function));
    }

    public Operation nextEventMethod(ExecutionFlow it) {
        Functions.Function1 _function = it_1 -> {
            String _lowerCase = it_1.getName().toLowerCase();
            String _lowerCase_1 = GET_NEXT_EVENT_METHOD_NAME.toLowerCase();
            return Objects.equals(_lowerCase, _lowerCase_1);
        };
        return (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this._statemachineClass.stateMachineClass(it).getFeatures(), Operation.class), (Functions.Function1)_function));
    }

    public Operation getTimeEventMethod(ExecutionFlow it) {
        Functions.Function1 _function = it_1 -> {
            String _lowerCase = it_1.getName().toLowerCase();
            String _lowerCase_1 = GET_TIME_EVENT_ID_METHOD_NAME.toLowerCase();
            return Objects.equals(_lowerCase, _lowerCase_1);
        };
        return (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this._statemachineClass.stateMachineClass(it).getFeatures(), Operation.class), (Functions.Function1)_function));
    }
}

