/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.extensions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.yakindu.sct.generator.core.IGeneratorModule;
import com.yakindu.sct.generator.core.execution.IGeneratorEntryExecutor;
import com.yakindu.sct.generator.core.extensions.IGeneratorDescriptor;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class GeneratorExtensions {
    private static final String EXTENSION_POINT_ID = "com.yakindu.sct.generator.core.generator";
    private static final String ATTRIBUTE_GENERATOR_EXECUTOR = "executor";
    private static final String ATTRIBUTE_BINDINGS = "bindings";
    private static final String ATTRIBUTE_ID = "id";
    private static final String LIBRARY_CONFIG_ELEMENT = "FeatureLibrary";
    private static final String ATTRIBUTE_LIBRARY_ID = "library_id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_CONTENT_TYPE = "contentType";
    private static final String ATTRIBUTE_KEYWORD = "keyword";
    private static final String ATTRIBUTE_ELEMENT_REF_TYPE = "elementRefType";
    private static final String ATTRIBUTE_ICON = "icon";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String DOMAIN_CONFIG_ELEMENT = "Domain";
    private static List<IGeneratorDescriptor> descriptors;

    public static List<IGeneratorDescriptor> getGeneratorDescriptors() {
        if (descriptors == null) {
            descriptors = Lists.newArrayList();
            if (Platform.isRunning()) {
                GeneratorExtensions.initFromExtensions();
            }
        }
        return descriptors;
    }

    public static IGeneratorDescriptor addNewGeneratorDescriptor(IConfigurationElement elem, final String id, final boolean first, final String primaryId) {
        GeneratorDescriptor desc = new GeneratorDescriptor(elem){

            @Override
            public String getId() {
                return id.trim();
            }

            @Override
            public boolean isDeprecated() {
                return this.getPrimaryGeneratorId() != null;
            }

            @Override
            public String getPrimaryGeneratorId() {
                return !first ? primaryId : null;
            }
        };
        return desc;
    }

    protected static void initFromExtensions() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            GeneratorDescriptor descriptor = new GeneratorDescriptor(iConfigurationElement);
            String[] split = descriptor.getId().split(",");
            int i = 0;
            while (i < split.length) {
                boolean first = i == 0;
                String primaryId = split[0];
                descriptors.add(GeneratorExtensions.addNewGeneratorDescriptor(iConfigurationElement, split[i], first, primaryId));
                ++i;
            }
            ++n2;
        }
    }

    public static Optional<IGeneratorDescriptor> getGeneratorDescriptor(final String generatorId) {
        try {
            return Optional.of((IGeneratorDescriptor)Iterables.find(GeneratorExtensions.getGeneratorDescriptors(), (Predicate)new Predicate<IGeneratorDescriptor>(){

                public boolean apply(IGeneratorDescriptor input) {
                    return input != null && input.getId() != null && input.getId().equals(generatorId);
                }
            }));
        }
        catch (NoSuchElementException ex) {
            return Optional.empty();
        }
    }

    protected static class GeneratorDescriptor
    implements IGeneratorDescriptor {
        private final IConfigurationElement configElement;
        private boolean isDeprecated;
        private String primaryGeneratorId;
        private URL image;

        GeneratorDescriptor(IConfigurationElement configElement) {
            this.configElement = configElement;
        }

        @Override
        public IGeneratorEntryExecutor createExecutor() {
            try {
                return (IGeneratorEntryExecutor)this.configElement.createExecutableExtension(GeneratorExtensions.ATTRIBUTE_GENERATOR_EXECUTOR);
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public Module getBindings(GeneratorEntry entry) {
            try {
                IGeneratorModule module = (IGeneratorModule)this.configElement.createExecutableExtension(GeneratorExtensions.ATTRIBUTE_BINDINGS);
                return new GeneratorModuleAdapter(module, entry);
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public String getLibraryID() {
            ArrayList<String> libs = new ArrayList<String>();
            IConfigurationElement[] iConfigurationElementArray = this.configElement.getChildren(GeneratorExtensions.LIBRARY_CONFIG_ELEMENT);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                String lib_id = child.getAttribute(GeneratorExtensions.ATTRIBUTE_LIBRARY_ID);
                if (lib_id != null && !lib_id.isEmpty()) {
                    libs.add(lib_id);
                }
                ++n2;
            }
            return libs.isEmpty() ? null : (String)libs.get(0);
        }

        @Override
        public Set<String> getValidDomains() {
            HashSet<String> domains = new HashSet<String>();
            IConfigurationElement[] iConfigurationElementArray = this.configElement.getChildren(GeneratorExtensions.DOMAIN_CONFIG_ELEMENT);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                String domainID = child.getAttribute(GeneratorExtensions.ATTRIBUTE_ID);
                if (domainID != null && !domainID.isEmpty()) {
                    domains.add(domainID);
                }
                ++n2;
            }
            return domains;
        }

        @Override
        public String getId() {
            return this.configElement.getAttribute(GeneratorExtensions.ATTRIBUTE_ID);
        }

        @Override
        public String getName() {
            return this.configElement.getAttribute(GeneratorExtensions.ATTRIBUTE_NAME);
        }

        @Override
        public URL getImagePath() {
            if (this.image != null) {
                return this.image;
            }
            String path = this.configElement.getAttribute(GeneratorExtensions.ATTRIBUTE_ICON);
            if (path == null) {
                return null;
            }
            Bundle extensionBundle = Platform.getBundle((String)this.configElement.getContributor().getName());
            this.image = extensionBundle.getEntry(path);
            return this.image;
        }

        @Override
        public String getContentType() {
            return this.configElement.getAttribute(GeneratorExtensions.ATTRIBUTE_CONTENT_TYPE);
        }

        @Override
        public String getKeyword() {
            return this.configElement.getAttribute(GeneratorExtensions.ATTRIBUTE_KEYWORD);
        }

        @Override
        public String getDescription() {
            return this.configElement.getAttribute(GeneratorExtensions.ATTRIBUTE_DESCRIPTION);
        }

        @Override
        public String getElementRefType() {
            try {
                return this.configElement.getAttribute(GeneratorExtensions.ATTRIBUTE_ELEMENT_REF_TYPE);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public boolean isPrimary() {
            return this.getPrimaryGeneratorId() == null;
        }

        @Override
        public boolean isDeprecated() {
            return this.isDeprecated;
        }

        public void setDeprecated(boolean value) {
            this.isDeprecated = value;
        }

        @Override
        public String getPrimaryGeneratorId() {
            return this.primaryGeneratorId;
        }

        public void setPrimaryGeneratorId(String value) {
            this.primaryGeneratorId = value;
        }
    }

    public static class GeneratorModuleAdapter
    implements Module {
        private GeneratorEntry entry;
        private IGeneratorModule module;

        public GeneratorModuleAdapter(IGeneratorModule module, GeneratorEntry entry) {
            this.module = module;
            this.entry = entry;
        }

        public void configure(Binder binder) {
            this.module.configure(this.entry, binder);
        }
    }
}

