/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.filesystem;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.yakindu.sct.generator.core.console.IConsoleLogger;
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess;
import com.yakindu.sct.generator.core.filesystem.PathBasedFileSystemAccess;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.OutputConfiguration;

public class DefaultFileSystemAccessFactory {
    @Inject
    protected IConsoleLogger logger;
    @Inject
    protected Provider<ISCTFileSystemAccess> fileSystemProvider;
    @Inject
    protected ICoreLibraryHelper helper;
    @Inject
    protected Injector injector;

    public ISCTFileSystemAccess create(GeneratorEntry entry) {
        if (this.helper.getTargetProjectValue(entry) == null) {
            ISCTFileSystemAccess fsa = (ISCTFileSystemAccess)this.injector.getInstance(PathBasedFileSystemAccess.class);
            fsa.setOutputPath("DEFAULT_OUTPUT", "");
            fsa.getOutputConfigurations().get("DEFAULT_OUTPUT").setCreateOutputDirectory(true);
            this.checkWriteAccess(fsa, "DEFAULT_OUTPUT", "");
            return fsa;
        }
        ISCTFileSystemAccess result = (ISCTFileSystemAccess)this.fileSystemProvider.get();
        this.initTargetProject(result, entry);
        this.initDefaultOutput(result, entry);
        this.initLibraryTargetFolder(result, entry);
        this.initApiTargetFolder(result, entry);
        return result;
    }

    protected void initTargetProject(ISCTFileSystemAccess access, GeneratorEntry entry) {
        String targetProjectName = this.helper.getTargetProjectValue(entry).getStringValue();
        access.setContext(targetProjectName);
        access.setOutputPath("targetProject", targetProjectName);
    }

    protected void initDefaultOutput(ISCTFileSystemAccess access, GeneratorEntry entry) {
        String folderName = this.helper.getTargetFolderValue(entry).getStringValue();
        access.setOutputPath("DEFAULT_OUTPUT", folderName);
        access.getOutputConfigurations().get("DEFAULT_OUTPUT").setCreateOutputDirectory(true);
        this.checkWriteAccess(access, "DEFAULT_OUTPUT", folderName);
    }

    protected void initLibraryTargetFolder(ISCTFileSystemAccess access, GeneratorEntry entry) {
        FeatureParameterValue libraryTargetFolderValue = this.helper.getLibraryTargetFolderValue(entry);
        if (libraryTargetFolderValue != null) {
            String folderName = libraryTargetFolderValue.getStringValue();
            access.setOutputPath("LIBRARY_TARGET_FOLDER", folderName);
            OutputConfiguration output = access.getOutputConfigurations().get("LIBRARY_TARGET_FOLDER");
            this.checkWriteAccess(access, "LIBRARY_TARGET_FOLDER", folderName);
            output.setCreateOutputDirectory(true);
            output.setCanClearOutputDirectory(false);
            output.setOverrideExistingResources(false);
        }
    }

    protected void initApiTargetFolder(ISCTFileSystemAccess access, GeneratorEntry entry) {
        FeatureParameterValue apiTargetFolderValue = this.helper.getApiTargetFolderValue(entry);
        if (apiTargetFolderValue != null) {
            String folderName = apiTargetFolderValue.getStringValue();
            access.setOutputPath("API_TARGET_FOLDER", folderName);
            OutputConfiguration output = access.getOutputConfigurations().get("API_TARGET_FOLDER");
            this.checkWriteAccess(access, "API_TARGET_FOLDER", folderName);
            output.setCreateOutputDirectory(true);
        }
    }

    protected void checkWriteAccess(ISCTFileSystemAccess access, String outputConfiguration, String folderName) {
        URI uri = access.getURI("", outputConfiguration);
        if (uri.isFile()) {
            File file = new File(uri.path());
            if (!file.exists()) {
                return;
            }
            if (!file.canWrite()) {
                this.logger.log(String.format("Can not generate files to read-only folder '%s'. ", folderName));
            }
        }
    }
}

