/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.filesystem;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess;
import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.parser.IEncodingProvider;

@Singleton
public class ProjectBasedFileSystemAccess
extends JavaIoFileSystemAccess
implements ISCTFileSystemAccess {
    @Inject
    @Named(value="filesystemAccess.absolute.baseDir")
    protected String absoluteBaseDir;
    @Inject
    private IEncodingProvider encodingProvider;
    private String projectName;

    @Override
    public void setContext(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public void setOutputPath(String outputName, String path) {
        super.setOutputPath(outputName, this.absoluteBaseDir + File.separator + this.projectName + File.separator + path);
    }

    protected String getEncoding(URI fileURI) {
        return this.encodingProvider.getEncoding(fileURI);
    }
}

