/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.tracing;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.itemis.create.base.generator.core.GeneratorAssignment;
import com.itemis.create.base.generator.core.codepattern.IEnumCode;
import com.itemis.create.base.generator.core.concepts.Documentation;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.AnnotatableElement;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.TypeBuilder;
import com.yakindu.base.types.TypedDeclaration;
import com.yakindu.base.types.TypesFactory;
import com.yakindu.base.types.adapter.OriginTracing;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sgraph.util.StatechartUtil;
import com.yakindu.sct.model.stext.stext.EventDefinition;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class TraceEvent {
    public static final String TRACE_EVENT_TYPE_ENUM_NAME = "TraceEventType";
    public static final String TRACE_FEATURE_SUFFIX = "Feature";
    public static final Map<String, String> TRACE_EVENT_TYPE_MAP = Map.ofEntries(Map.entry("TraceBeginRunCycle", "MACHINE_RTS_START"), Map.entry("TraceEndRunCycle", "MACHINE_RTS_STOP"), Map.entry("TraceReactionWillFire", "STATE_TRANSITION"), Map.entry("traceEnterCode", "MACHINE_ENTER"), Map.entry("traceExitCode", "MACHINE_EXIT"), Map.entry("TraceStateEntered", "STATE_ENTERED"), Map.entry("TraceStateExited", "STATE_EXITED"), Map.entry("EventDefinition", "EVENT_RAISED"), Map.entry("Property", "VARIABLE_SET"), Map.entry("ScheduleTimeEvent", "TIME_EVENT_SET"), Map.entry("UnscheduleTimeEvent", "TIME_EVENT_UNSET"));
    @Extension
    protected TypesFactory tFactory = TypesFactory.eINSTANCE;
    @Inject
    @Extension
    protected IEnumCode _iEnumCode;
    @Inject
    @Extension
    protected SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    protected OriginTracing _originTracing;
    @Inject
    @Extension
    protected Documentation _documentation;
    @Inject
    @Extension
    protected TypeBuilder _typeBuilder;
    @Inject
    @Extension
    protected GeneratorAssignment _generatorAssignment;
    @Inject
    @Extension
    protected StatechartUtil _statechartUtil;
    private final HashMap<ArrayList<?>, EnumerationType> _createCache_traceEventType = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, EnumerationType> _createCache_traceEventFeature = CollectionLiterals.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumerationType traceEventType() {
        EnumerationType _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList();
        HashMap<ArrayList<?>, EnumerationType> hashMap = this._createCache_traceEventType;
        synchronized (hashMap) {
            EnumerationType _createEnumerationType;
            if (this._createCache_traceEventType.containsKey(_cacheKey)) {
                return this._createCache_traceEventType.get(_cacheKey);
            }
            _result = _createEnumerationType = this.tFactory.createEnumerationType();
            this._createCache_traceEventType.put(_cacheKey, _result);
        }
        this._init_traceEventType(_result);
        return _result;
    }

    private void _init_traceEventType(EnumerationType e) {
        this._documentation.documentation((AnnotatableElement)e, "Enumeration of all types of origin tracing.");
        this._typeBuilder._public((AnnotatableElement)e);
        e.setName(TRACE_EVENT_TYPE_ENUM_NAME);
        Consumer<String> _function = en -> {
            EList _enumerator = e.getEnumerator();
            Enumerator _createEnumerator = this.tFactory.createEnumerator();
            Procedures.Procedure1 _function_1 = it -> it.setName(en);
            Enumerator _doubleArrow = (Enumerator)ObjectExtensions.operator_doubleArrow((Object)_createEnumerator, (Procedures.Procedure1)_function_1);
            _enumerator.add((Object)_doubleArrow);
        };
        TRACE_EVENT_TYPE_MAP.values().forEach(_function);
        Functions.Function0 _function_1 = () -> this._iEnumCode.enumerationCode(e);
        this._generatorAssignment.generateDefinitionWith((EObject)e, _function_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumerationType traceEventFeature(ComplexType ct) {
        EnumerationType _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ComplexType[]{ct});
        HashMap<ArrayList<?>, EnumerationType> hashMap = this._createCache_traceEventFeature;
        synchronized (hashMap) {
            EnumerationType _createEnumerationType;
            if (this._createCache_traceEventFeature.containsKey(_cacheKey)) {
                return this._createCache_traceEventFeature.get(_cacheKey);
            }
            _result = _createEnumerationType = this.tFactory.createEnumerationType();
            this._createCache_traceEventFeature.put(_cacheKey, _result);
        }
        this._init_traceEventFeature(_result, ct);
        return _result;
    }

    private void _init_traceEventFeature(EnumerationType e, ComplexType ct) {
        this._documentation.documentation((AnnotatableElement)e, "Enumeration of all features of the statechart.");
        this._typeBuilder._public((AnnotatableElement)e);
        String _name = ct.getName();
        String _plus = _name + TRACE_FEATURE_SUFFIX;
        e.setName(_plus);
        Functions.Function1 _function = it -> this._originTracing.originSource((EObject)it) instanceof EventDefinition || this._originTracing.originSource((EObject)it) instanceof VariableDefinition;
        Procedures.Procedure1 _function_1 = en -> {
            EList _enumerator = e.getEnumerator();
            Enumerator _createEnumerator = this.tFactory.createEnumerator();
            Procedures.Procedure1 _function_2 = it -> it.setName(this.featureEnumMemberName((NamedElement)en));
            Enumerator _doubleArrow = (Enumerator)ObjectExtensions.operator_doubleArrow((Object)_createEnumerator, (Procedures.Procedure1)_function_2);
            _enumerator.add((Object)_doubleArrow);
        };
        IteratorExtensions.forEach((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)ct.eAllContents(), TypedDeclaration.class), (Functions.Function1)_function), (Procedures.Procedure1)_function_1);
        Functions.Function0 _function_2 = () -> this._iEnumCode.enumerationCode(e);
        this._generatorAssignment.generateDeclarationWith((EObject)e, _function_2);
    }

    public String featureEnumMemberName(NamedElement it) {
        String _defaultInterfaceName = this._sExecExtensions.defaultInterfaceName(this._sExecExtensions.scope((EObject)it));
        String _name = it.getName();
        Functions.Function1 _function = it_1 -> {
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it_1);
            return !_isNullOrEmpty;
        };
        return IterableExtensions.join((Iterable)IterableExtensions.filter(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_defaultInterfaceName, _name})), (Functions.Function1)_function), (CharSequence)"_").toUpperCase();
    }
}

