/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.coverage.io;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterators;
import com.google.common.collect.Table;
import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.simulation.core.coverage.Measurement;
import com.yakindu.sct.simulation.core.coverage.MeasurementExtension;
import com.yakindu.sctunit.coverage.builder.SCTUnitMeasurementBuilder;
import com.yakindu.sctunit.coverage.io.ClassDeserializer;
import com.yakindu.sctunit.coverage.io.MeasuresDeserializer;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class JSONToMeasurement {
    @Extension
    protected DefaultDeclarativeQualifiedNameProvider provider;
    @Extension
    protected MeasurementExtension mExtension = new MeasurementExtension();
    private String jsonString = "";
    private ObjectMapper mapper;
    private JsonNode jsonNode;

    public JSONToMeasurement(String inputJsonString) {
        try {
            JsonNode _readTree;
            ObjectMapper _objectMapper;
            this.jsonString = inputJsonString;
            this.mapper = _objectMapper = new ObjectMapper();
            this.jsonNode = _readTree = this.mapper.readTree(this.jsonString);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String getURIString() {
        String uri;
        String _xblockexpression = null;
        _xblockexpression = uri = this.jsonNode.get("uri").asText();
        return _xblockexpression;
    }

    public String getDate() {
        String _xblockexpression = null;
        JsonNode date = this.jsonNode.get("date");
        _xblockexpression = date.asText();
        return _xblockexpression;
    }

    public int getNumberOfTestCases() {
        int _xblockexpression = 0;
        JsonNode numberOfTestCases = this.jsonNode.get("numberOfTestCases");
        _xblockexpression = numberOfTestCases.asInt();
        return _xblockexpression;
    }

    public Measurement generateMeasurement() {
        try {
            Measurement populatedMeasurement;
            Measurement _xblockexpression = null;
            URI testURI = URI.createURI((String)this.getURIString(), (boolean)true);
            String measurementNode = this.jsonNode.get("measurement").toString();
            SimpleModule module = new SimpleModule();
            MeasurementDeserializer _measurementDeserializer = new MeasurementDeserializer();
            module.addDeserializer(Measurement.class, (JsonDeserializer)_measurementDeserializer);
            ClassDeserializer _classDeserializer = new ClassDeserializer();
            module.addDeserializer(Class.class, (JsonDeserializer)_classDeserializer);
            MeasuresDeserializer _measuresDeserializer = new MeasuresDeserializer();
            module.addDeserializer(Measurement.Measure.class, (JsonDeserializer)_measuresDeserializer);
            this.mapper.registerModule((Module)module);
            Measurement measurement = this.setMeasurementParents((Measurement)this.mapper.readValue(measurementNode, Measurement.class));
            _xblockexpression = populatedMeasurement = this.buildNewMeasurement(measurement, testURI);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Measurement buildNewMeasurement(Measurement measurement, URI uri) {
        Measurement _xblockexpression = null;
        Measurement builtMeasurement = null;
        SCTUnitMeasurementBuilder measurementBuilder = new SCTUnitMeasurementBuilder();
        Resource resourceSet = new ResourceSetImpl().getResource(uri, true);
        Functions.Function1 _function = it -> it instanceof SCTUnitClass || it instanceof SCTUnitSuite || it instanceof Statechart;
        NamedElement subject = (NamedElement)IteratorExtensions.head((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)resourceSet.getAllContents(), NamedElement.class), (Functions.Function1)_function));
        builtMeasurement = measurementBuilder.buildMeasurement(subject);
        this.reconcileSubjects(measurement, builtMeasurement);
        _xblockexpression = measurement;
        return _xblockexpression;
    }

    protected void reconcileSubjects(Measurement target, Measurement source) {
        HashBasedTable subjectTable = HashBasedTable.create();
        Functions.Function1 _function = it -> {
            EObject _subject = it.getSubject();
            return _subject != null;
        };
        Consumer<Measurement> _function_1 = arg_0 -> JSONToMeasurement.lambda$2((Table)subjectTable, arg_0);
        this.mExtension.findAll(source, _function).forEach(_function_1);
        Functions.Function1 _function_2 = it -> it.getSubject() == null && it.getSubjectID() != null && it.getType() != null;
        Consumer<Measurement> _function_3 = arg_0 -> JSONToMeasurement.lambda$4((Table)subjectTable, arg_0);
        this.mExtension.findAll(target, _function_2).forEach(_function_3);
    }

    protected Measurement setMeasurementParents(Measurement measurement) {
        Measurement _xblockexpression = null;
        Functions.Function1 _function = it -> {
            List _children = it.getChildren();
            return _children != null;
        };
        Consumer<Measurement> _function_1 = it -> {
            Consumer<Measurement> _function_2 = child -> child.setParent(it);
            it.getChildren().forEach(_function_2);
        };
        this.mExtension.findAll(measurement, _function).forEach(_function_1);
        _xblockexpression = measurement;
        return _xblockexpression;
    }

    private static /* synthetic */ void lambda$2(Table table, Measurement it) {
        boolean _not;
        boolean _contains = table.contains((Object)it.getType().getSimpleName(), (Object)it.getSubjectID());
        boolean bl = _not = !_contains;
        if (_not) {
            table.put((Object)it.getType().getSimpleName(), (Object)it.getSubjectID(), (Object)it.getSubject());
        }
    }

    private static /* synthetic */ void lambda$4(Table table, Measurement it) {
        it.setSubject((EObject)table.get((Object)it.getType().getSimpleName(), (Object)it.getSubjectID()));
    }

    public static class MeasurementDeserializer
    extends JsonDeserializer<Measurement> {
        public Measurement deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            JsonNode measuresNode;
            boolean _isArray_1;
            JsonNode childrenNode;
            boolean _isArray;
            Measurement _xblockexpression = null;
            ObjectMapper mapper = new ObjectMapper();
            SimpleModule module = new SimpleModule();
            MeasurementDeserializer _measurementDeserializer = new MeasurementDeserializer();
            module.addDeserializer(Measurement.class, (JsonDeserializer)_measurementDeserializer);
            ClassDeserializer _classDeserializer = new ClassDeserializer();
            module.addDeserializer(Class.class, (JsonDeserializer)_classDeserializer);
            MeasuresDeserializer _measuresDeserializer = new MeasuresDeserializer();
            module.addDeserializer(Measurement.Measure.class, (JsonDeserializer)_measuresDeserializer);
            mapper.registerModule((Module)module);
            TreeNode _readTree = mapper.readTree(parser);
            JsonNode node = (JsonNode)_readTree;
            String subjectID = node.get("subjectID").asText();
            String name = node.get("name").asText();
            long _xifexpression = 0L;
            JsonNode _get = node.get("timestamp");
            boolean _tripleNotEquals = _get != null;
            _xifexpression = _tripleNotEquals ? node.get("timestamp").asLong() : 0L;
            long timestamp = _xifexpression;
            Class type = (Class)mapper.readValue(node.get("type").traverse(), Class.class);
            ArrayList<Measurement> children = new ArrayList<Measurement>();
            boolean _has = node.has("children");
            if (_has && (_isArray = (childrenNode = node.get("children")).isArray())) {
                for (JsonNode childNode : childrenNode) {
                    Measurement child = (Measurement)mapper.readValue(childNode.traverse(), Measurement.class);
                    children.add(child);
                }
            }
            ArrayList<Measurement.Measure> measures = new ArrayList<Measurement.Measure>();
            boolean _has_1 = node.has("measures");
            if (_has_1 && (_isArray_1 = (measuresNode = node.get("measures")).isArray())) {
                for (JsonNode mNode : measuresNode) {
                    Measurement.Measure measure = (Measurement.Measure)mapper.readValue(mNode.traverse(), Measurement.Measure.class);
                    if (measure == null) continue;
                    measures.add(measure);
                }
            }
            Measurement measurement = new Measurement();
            measurement.setName(name);
            measurement.setSubjectID(subjectID);
            measurement.setType(type);
            measurement.setTimestamp(timestamp);
            measurement.getChildren().addAll(children);
            measurement.getMeasures().addAll(measures);
            _xblockexpression = measurement;
            return _xblockexpression;
        }
    }
}

