/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.action.global;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.action.global.GetGlobalActionHandlerOperation;
import org.eclipse.gmf.runtime.common.ui.services.action.global.GlobalActionHandlerOperation;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionHandler;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionHandlerContext;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionHandlerProvider;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.CommonUIServicesActionDebugOptions;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.CommonUIServicesActionPlugin;

public class GlobalActionHandlerService
extends Service
implements IGlobalActionHandlerProvider {
    private static final GlobalActionHandlerService instance = new GlobalActionHandlerService();

    static {
        instance.configureProviders(CommonUIServicesActionPlugin.getPluginId(), "globalActionHandlerProviders");
    }

    protected GlobalActionHandlerService() {
        super(false);
    }

    public static GlobalActionHandlerService getInstance() {
        return instance;
    }

    private Object execute(GlobalActionHandlerOperation operation) {
        List results = this.execute(ExecutionStrategy.FIRST, operation);
        return results.isEmpty() ? null : results.get(0);
    }

    @Override
    public IGlobalActionHandler getGlobalActionHandler(IGlobalActionHandlerContext context) {
        assert (context != null);
        return (IGlobalActionHandler)this.execute(new GetGlobalActionHandlerOperation(context));
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element, this.getGlobalActionHandlerProviderInfo(element));
    }

    private Hashtable getGlobalActionHandlerProviderInfo(IConfigurationElement element) {
        Hashtable providerInfo = new Hashtable();
        try {
            IConfigurationElement[] viewChildren = element.getChildren("ViewId");
            int i = 0;
            while (i < viewChildren.length) {
                IConfigurationElement viewConfig = viewChildren[i];
                String id = viewConfig.getAttribute("id");
                if (id == null) {
                    this.handleInvalidElement(viewConfig);
                } else {
                    providerInfo.put(id, new Hashtable());
                    IConfigurationElement[] elementTypeChildren = viewConfig.getChildren();
                    int j = 0;
                    while (j < elementTypeChildren.length) {
                        IConfigurationElement elementTypeConfig = elementTypeChildren[j];
                        String elementTypeClass = elementTypeConfig.getAttribute("class");
                        if (elementTypeClass == null) {
                            elementTypeClass = IGlobalActionHandlerProvider.NullElementType.class.getName();
                        }
                        Hashtable table = (Hashtable)providerInfo.get(id);
                        table.put(elementTypeClass, new Vector());
                        Vector<String> listOfActionId = new Vector<String>();
                        IConfigurationElement[] actionIdChildren = elementTypeConfig.getChildren();
                        int k = 0;
                        while (k < actionIdChildren.length) {
                            IConfigurationElement actionIdConfig = actionIdChildren[k];
                            String actionId = actionIdConfig.getAttribute("actionId");
                            if (actionId == null) {
                                this.handleInvalidElement(actionIdConfig);
                            } else {
                                listOfActionId.addElement(actionId);
                            }
                            ++k;
                        }
                        Vector list = (Vector)((Hashtable)providerInfo.get(id)).get(elementTypeClass);
                        list.addAll(listOfActionId);
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.catching((Plugin)CommonUIServicesActionPlugin.getDefault(), (String)CommonUIServicesActionDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getGlobalActionHandlerProviderInfo", (Throwable)e);
            Log.error((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)MessageFormat.format("Invalid XML element ({0}).", element.getName()), (Throwable)e);
        }
        return providerInfo;
    }

    private void handleInvalidElement(IConfigurationElement element) {
        String message = MessageFormat.format("Invalid XML element ({0}).", element.getDeclaringExtension().toString() + ":" + element.getName());
        Trace.trace((Plugin)CommonUIServicesActionPlugin.getDefault(), (String)CommonUIServicesActionDebugOptions.SERVICES_CONFIG, (String)message);
        Log.error((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)message);
    }

    protected static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private Hashtable partHandlerList = null;

        protected ProviderDescriptor(IConfigurationElement element, Hashtable partHandlerList) {
            super(element);
            assert (partHandlerList != null) : "partHandlerList cannot be null";
            this.partHandlerList = partHandlerList;
        }

        public boolean provides(IOperation operation) {
            if (!(operation instanceof GlobalActionHandlerOperation)) {
                return false;
            }
            IGlobalActionHandlerContext context = ((GlobalActionHandlerOperation)operation).getContext();
            String partId = context.getActivePart().getSite().getId();
            String actionId = context.getActionId();
            Class elementType = context.getElementType();
            boolean isCompatible = context.isCompatible();
            Hashtable elementTypeTable = (Hashtable)this.getPartHandlerList().get(partId);
            if (elementTypeTable == null) {
                return false;
            }
            List actionIdList = (List)elementTypeTable.get(isCompatible ? this.getCompatibleType(elementTypeTable, elementType, actionId).getName() : elementType.getName());
            if (actionIdList == null && (actionIdList = (List)elementTypeTable.get(IGlobalActionHandlerProvider.NullElementType.class.getName())) == null) {
                return false;
            }
            if (actionIdList.contains(actionId)) {
                if (!this.policyInitialized) {
                    this.policy = this.getPolicy();
                    this.policyInitialized = true;
                }
                if (this.policy != null) {
                    return this.policy.provides(operation);
                }
                return true;
            }
            return false;
        }

        private Hashtable getPartHandlerList() {
            return this.partHandlerList;
        }

        private Class getCompatibleType(Hashtable elementTypeTable, Class elementType, String actionId) {
            Class<?> newClass = null;
            String className = null;
            Enumeration enumeration = elementTypeTable.keys();
            while (enumeration.hasMoreElements()) {
                className = (String)enumeration.nextElement();
                List actionIdList = (List)elementTypeTable.get(className);
                if (actionIdList == null || !actionIdList.contains(actionId)) continue;
                try {
                    newClass = Class.forName(className, false, elementType.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    Trace.catching((Plugin)CommonUIServicesActionPlugin.getDefault(), (String)CommonUIServicesActionDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getCompatibleType", (Throwable)e);
                }
                if (newClass == null || !newClass.isAssignableFrom(elementType)) continue;
                return newClass;
            }
            return elementType;
        }
    }
}

