/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.builder;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.yakindu.sct.generator.builder.EclipseContextModule;
import com.yakindu.sct.generator.builder.GenModelLoader;
import com.yakindu.sct.generator.core.execution.GeneratorExecutorLookup;
import com.yakindu.sct.model.sgen.GeneratorModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.xtext.ui.shared.SharedStateModule;

public class EclipseContextGeneratorExecutorLookup
extends GeneratorExecutorLookup {
    protected Module getContextModule() {
        return Modules.combine((Module[])new Module[]{new EclipseContextModule(), new SharedStateModule()});
    }

    public void executeGenerator(IFile file) {
        final GeneratorModel model = GenModelLoader.load(file);
        Job generatorJob = new Job("Execute SCT Genmodel " + file.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    EclipseContextGeneratorExecutorLookup.this.execute(model);
                }
                catch (Exception ex) {
                    return new Status(4, "com.yakindu.sct.builder", "An error occurred during code generation.", (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        generatorJob.setRule((ISchedulingRule)file.getProject().getWorkspace().getRoot());
        generatorJob.schedule();
    }
}

