/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AssignmentOperator implements Enumerator
{
    ASSIGN(0, "assign", "="),
    MULT_ASSIGN(1, "multAssign", "*="),
    DIV_ASSIGN(2, "divAssign", "/="),
    MOD_ASSIGN(3, "modAssign", "%="),
    ADD_ASSIGN(4, "addAssign", "+="),
    SUB_ASSIGN(5, "subAssign", "-="),
    LEFT_SHIFT_ASSIGN(6, "leftShiftAssign", "<<="),
    RIGHT_SHIFT_ASSIGN(7, "rightShiftAssign", ">>="),
    AND_ASSIGN(8, "andAssign", "&="),
    XOR_ASSIGN(9, "xorAssign", "^="),
    OR_ASSIGN(10, "orAssign", "|=");

    public static final int ASSIGN_VALUE = 0;
    public static final int MULT_ASSIGN_VALUE = 1;
    public static final int DIV_ASSIGN_VALUE = 2;
    public static final int MOD_ASSIGN_VALUE = 3;
    public static final int ADD_ASSIGN_VALUE = 4;
    public static final int SUB_ASSIGN_VALUE = 5;
    public static final int LEFT_SHIFT_ASSIGN_VALUE = 6;
    public static final int RIGHT_SHIFT_ASSIGN_VALUE = 7;
    public static final int AND_ASSIGN_VALUE = 8;
    public static final int XOR_ASSIGN_VALUE = 9;
    public static final int OR_ASSIGN_VALUE = 10;
    private static final AssignmentOperator[] VALUES_ARRAY;
    public static final List<AssignmentOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AssignmentOperator[]{ASSIGN, MULT_ASSIGN, DIV_ASSIGN, MOD_ASSIGN, ADD_ASSIGN, SUB_ASSIGN, LEFT_SHIFT_ASSIGN, RIGHT_SHIFT_ASSIGN, AND_ASSIGN, XOR_ASSIGN, OR_ASSIGN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AssignmentOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssignmentOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssignmentOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssignmentOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssignmentOperator get(int value) {
        switch (value) {
            case 0: {
                return ASSIGN;
            }
            case 1: {
                return MULT_ASSIGN;
            }
            case 2: {
                return DIV_ASSIGN;
            }
            case 3: {
                return MOD_ASSIGN;
            }
            case 4: {
                return ADD_ASSIGN;
            }
            case 5: {
                return SUB_ASSIGN;
            }
            case 6: {
                return LEFT_SHIFT_ASSIGN;
            }
            case 7: {
                return RIGHT_SHIFT_ASSIGN;
            }
            case 8: {
                return AND_ASSIGN;
            }
            case 9: {
                return XOR_ASSIGN;
            }
            case 10: {
                return OR_ASSIGN;
            }
        }
        return null;
    }

    private AssignmentOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

