/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.validation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression;
import com.yakindu.base.expressions.expressions.ExpressionsPackage;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.Literal;
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.expressions.expressions.StringLiteral;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.expressions.validation.AbstractExpressionsValidator;
import com.yakindu.base.expressions.validation.ReturnValidator;
import com.yakindu.base.types.AnnotatableElement;
import com.yakindu.base.types.AnnotatedElement;
import com.yakindu.base.types.Annotation;
import com.yakindu.base.types.Argument;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypesPackage;
import com.yakindu.base.types.TypesUtil;
import com.yakindu.base.types.annotations.DeprecatedAnnotations;
import com.yakindu.base.types.annotations.TypeAnnotations;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.util.ArgumentSorter;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import com.yakindu.base.types.validation.TypeValidator;
import com.yakindu.base.types.validation.TypesJavaValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@ComposedChecks(validators={TypesJavaValidator.class, ReturnValidator.class})
public class ExpressionsValidator
extends AbstractExpressionsValidator
implements IValidationIssueAcceptor {
    @Inject
    private ITypeSystemInferrer typeInferrer;
    @Inject
    private TypeValidator typeValidator;
    @Inject
    @Extension
    private ExpressionExtensions _expressionExtensions;
    @Inject
    @Extension
    protected DeprecatedAnnotations _deprecatedAnnotations;
    @Inject
    @Extension
    protected TypeAnnotations _typeAnnotations;
    @Inject
    @Extension
    protected ArgumentSorter _argumentSorter;
    public static final String POSTFIX_ONLY_ON_VARIABLES_CODE = "PostfixOnlyOnVariables";
    public static final String POSTFIX_ONLY_ON_VARIABLES_MSG = "Invalid argument to operator '++/--'";
    public static final String ERROR_SURPLUS_PARAMETER_ASSIGNMENT_CODE = "ErrorSurplusParameterAssignment";
    public static final String ERROR_SURPLUS_PARAMETER_ASSIGNMENT_MSG = "Surplus assignment to parameter '%s'.";
    public static final String ERROR_ARG_FOR_UNDEFINED_PARAMETER_CODE = "ErrorArgForUndefinedParameter";
    public static final String ERROR_ARG_FOR_UNDEFINED_PARAMETER_MSG = "Argument refers to undefined parameter '%s'.";
    public static final String WARNING_REORDERD_ARGUMENT_LISTS_SHOULD_ONLY_USE_NAMED_ARGUMENTS_CODE = "Warning.ReorderedArgumentListShouldOnlyUseNamedArguments";
    public static final String WARNING_REORDERD_ARGUMENT_LISTS_SHOULD_ONLY_USE_NAMED_ARGUMENTS_MSG = "When using named arguments in an unordered fashion all arguments should be named.";
    public static final String WARNING_AMBIGOUS_MSG = "%s is ambiguous. Please consider to use fully qualified name.";
    public static final String WARNING_AMBIGOUS_CODE = "ambigousType";
    public static final String ERROR_ASSIGNMENT_TO_CONST_CODE = "AssignmentToConst";
    public static final String ERROR_ASSIGNMENT_TO_CONST_MSG = "Assignment to constant not allowed.";
    public static final String ERROR_POST_FIX_TO_CONST_CODE = "PostFixToConst";
    public static final String ERROR_POST_FIX_TO_CONST_MSG = "Increment or decrement to constant not allowed.";
    public static final String ERROR_LEFT_HAND_ASSIGNMENT_CODE = "LeftHandAssignment";
    public static final String ERROR_LEFT_HAND_ASSIGNMENT_MSG = "The left-hand side of an assignment must be a variable.";
    public static final String DEPRECATED_ANNOTATABLE_ELEMENT = "This is a deprecated element and will be removed in the future. ";
    public static final String ERROR_WRONG_NUMBER_OF_ARGUMENTS_CODE = "WrongNrOfArgs";
    public static final String ERROR_WRONG_NUMBER_OF_ARGUMENTS_MSG = "Wrong number of arguments, expected %s .";
    public static final String ERROR_WRONG_ANNOTATION_TARGET_CODE = "WrongAnnotationTarget";
    public static final String ERROR_WRONG_ANNOTATION_TARGET_MSG = "Annotation '%s' can not be applied on '%s'. It is applicable to %s.";
    public static final String CONST_MUST_HAVE_VALUE_MSG = "A constant definition must specify an initial value.";
    public static final String CONST_MUST_HAVE_VALUE_CODE = "ConstMustHaveAValue";
    public static final String REFERENCE_TO_VARIABLE = "Cannot reference a variable in a constant initialization.";
    public static final String DECLARATION_WITH_READONLY = "The keyword '%s' has no effect for '%s' definitions. Can be removed.";
    public static final String ASSIGNMENT_EXPRESSION = "No nested assignment of the same variable allowed (different behavior in various programming languages).";
    public static final String VALUE_OF_REQUIRES_EVENT = "valueof() expression requires event as argument.";

    @Check
    public void checkExpression(Expression expression) {
        boolean _not;
        EObject _eContainer = expression.eContainer();
        boolean bl = _not = !(_eContainer instanceof Expression);
        if (_not) {
            this.typeInferrer.infer((EObject)expression, (IValidationIssueAcceptor)this);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkExpression(Property expression) {
        if (expression.getType() == null || expression.getType().eIsProxy()) {
            return;
        }
        this.typeInferrer.infer((EObject)expression, (IValidationIssueAcceptor)this);
    }

    public void accept(IValidationIssueAcceptor.ValidationIssue issue) {
        IValidationIssueAcceptor.ValidationIssue.Severity _severity = issue.getSeverity();
        if (_severity != null) {
            switch (_severity) {
                case ERROR: {
                    this.error(issue.getMessage(), null, issue.getIssueCode(), new String[0]);
                    break;
                }
                case WARNING: {
                    this.warning(issue.getMessage(), null, issue.getIssueCode(), new String[0]);
                    break;
                }
                case INFO: {
                    break;
                }
            }
        }
    }

    @Check
    public void checkPostFixOperatorOnlyOnVariables(PostFixUnaryExpression expression) {
        if (!(expression.getOperand() instanceof ElementReferenceExpression) && !(expression.getOperand() instanceof FeatureCall)) {
            this.error(POSTFIX_ONLY_ON_VARIABLES_MSG, (EObject)expression, null, POSTFIX_ONLY_ON_VARIABLES_CODE, new String[0]);
        }
    }

    @Check
    public void checkParameters(ArgumentExpression exp) {
        EObject declaration = this._expressionExtensions.featureOrReference(exp);
        int errors = 0;
        if (declaration instanceof Operation) {
            boolean _not;
            List argumentOrders = ArgumentSorter.getArgumentOrders(exp.getArguments(), (List)((Operation)declaration).getParameters());
            boolean _isEmpty = argumentOrders.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                int maxArgumentsSize = Math.max(argumentOrders.size(), ((Operation)declaration).getParameters().size());
                Argument[] sortedArguments = new Argument[maxArgumentsSize];
                for (ArgumentSorter.ArgumentOrder ao : argumentOrders) {
                    Argument _get;
                    boolean _tripleEquals;
                    boolean _not_1;
                    Argument argument = ao.getArgument();
                    Object _xifexpression = null;
                    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)ao.getName());
                    _xifexpression = _isNullOrEmpty ? Integer.valueOf(argumentOrders.indexOf(ao)) : ao.getName();
                    String paramNameOrIndex = _xifexpression;
                    boolean _isValid = ao.isValid();
                    boolean bl2 = _not_1 = !_isValid;
                    if (_not_1) {
                        this.error(String.format(ERROR_ARG_FOR_UNDEFINED_PARAMETER_MSG, paramNameOrIndex), (EObject)argument, null, ERROR_ARG_FOR_UNDEFINED_PARAMETER_CODE, new String[0]);
                        ++errors;
                    }
                    boolean bl3 = _tripleEquals = (_get = sortedArguments[ao.getOrder()]) == null;
                    if (_tripleEquals) {
                        sortedArguments[ao.getOrder()] = argument;
                        continue;
                    }
                    this.error(String.format(ERROR_SURPLUS_PARAMETER_ASSIGNMENT_MSG, paramNameOrIndex), (EObject)argument, null, ERROR_SURPLUS_PARAMETER_ASSIGNMENT_CODE, new String[0]);
                    ++errors;
                }
                int _size = argumentOrders.size();
                int _minus = _size - 1;
                Functions.Function1 _function = i -> {
                    int _order = ((ArgumentSorter.ArgumentOrder)argumentOrders.get((int)i)).getOrder();
                    return _order != i;
                };
                boolean reorderExists = IterableExtensions.exists((Iterable)new IntegerRange(0, _minus), (Functions.Function1)_function);
                int _size_1 = argumentOrders.size();
                int _minus_1 = _size_1 - 1;
                Functions.Function1 _function_1 = i -> StringExtensions.isNullOrEmpty((String)((ArgumentSorter.ArgumentOrder)argumentOrders.get((int)i)).getName());
                boolean unnamedExists = IterableExtensions.exists((Iterable)new IntegerRange(0, _minus_1), (Functions.Function1)_function_1);
                if (errors == 0 && reorderExists && unnamedExists) {
                    this.warning(WARNING_REORDERD_ARGUMENT_LISTS_SHOULD_ONLY_USE_NAMED_ARGUMENTS_MSG, (EObject)exp, null, WARNING_REORDERD_ARGUMENT_LISTS_SHOULD_ONLY_USE_NAMED_ARGUMENTS_CODE, new String[0]);
                }
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkAmbigousEnumInGuard(FeatureCall it) {
        EObject _eContainer;
        Type type;
        EObject _rootContainer;
        EObject _featureOrReference = this._expressionExtensions.featureOrReference(it);
        if (_featureOrReference instanceof Enumerator && (_rootContainer = EcoreUtil2.getRootContainer((EObject)(type = (Type)(_eContainer = this._expressionExtensions.featureOrReference(it).eContainer())))) instanceof Package) {
            ICompositeNode node = NodeModelUtils.getNode((EObject)it);
            EObject _rootContainer_1 = EcoreUtil2.getRootContainer((EObject)type);
            Set packageContainedTypes = TypesUtil.collectPackageContainedTypes((Package)((Package)_rootContainer_1), (Set)CollectionLiterals.newHashSet());
            if (IterableExtensions.exists((Iterable)packageContainedTypes, it_1 -> it_1 != type && it_1.getName() != null && it_1.getName().equals(type.getName())) && node.getText().contains(type.getName()) && !node.getText().contains(TypesUtil.toQualifiedName((EObject)type).toString())) {
                this.warning(String.format(WARNING_AMBIGOUS_MSG, type.getName()), (EObject)it, null, WARNING_AMBIGOUS_CODE, new String[0]);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkAssignmentToFinalVariable(AssignmentExpression exp) {
        boolean _isConst;
        EObject referencedObject = this._expressionExtensions.featureOrReference(exp.getVarRef());
        if (referencedObject instanceof Property && (_isConst = ((Property)referencedObject).isConst())) {
            this.error(ERROR_ASSIGNMENT_TO_CONST_MSG, (EStructuralFeature)ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION__VAR_REF, ERROR_ASSIGNMENT_TO_CONST_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkPostFixUnaryExpressionToFinalVariable(PostFixUnaryExpression exp) {
        boolean _isConst;
        EObject referencedObject = this._expressionExtensions.featureOrReference(exp.getOperand());
        if (referencedObject instanceof Property && (_isConst = ((Property)referencedObject).isConst())) {
            this.error(ERROR_POST_FIX_TO_CONST_MSG, (EObject)exp, null, ERROR_POST_FIX_TO_CONST_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkLeftHandAssignment(AssignmentExpression expression) {
        Expression varRef = expression.getVarRef();
        if (varRef instanceof FeatureCall) {
            EObject referencedObject = ((FeatureCall)varRef).getFeature();
            if (!referencedObject.eIsProxy() && !(referencedObject instanceof Property)) {
                this.error(ERROR_LEFT_HAND_ASSIGNMENT_MSG, (EStructuralFeature)ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION__VAR_REF, ERROR_LEFT_HAND_ASSIGNMENT_CODE, new String[0]);
            }
        } else if (varRef instanceof ElementReferenceExpression) {
            EObject referencedObject_1 = ((ElementReferenceExpression)varRef).getReference();
            if (!(referencedObject_1.eIsProxy() || referencedObject_1 instanceof Property || referencedObject_1 instanceof Parameter)) {
                this.error(ERROR_LEFT_HAND_ASSIGNMENT_MSG, (EStructuralFeature)ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION__VAR_REF, ERROR_LEFT_HAND_ASSIGNMENT_CODE, new String[0]);
            }
        } else {
            this.error(ERROR_LEFT_HAND_ASSIGNMENT_MSG, (EStructuralFeature)ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION__VAR_REF, ERROR_LEFT_HAND_ASSIGNMENT_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkOperationArguments_FeatureCall(FeatureCall call) {
        EObject _feature = call.getFeature();
        if (_feature instanceof Operation) {
            EObject _feature_1 = call.getFeature();
            Operation operation = (Operation)_feature_1;
            this.assertOperationArguments(operation, (List<Expression>)call.getExpressions());
        }
    }

    @Check(value=CheckType.FAST)
    public void checkDeprecatedInGuard(FeatureCall fc) {
        Consumer<FeatureCall> _function = a -> {
            boolean _isDeprecated = this._deprecatedAnnotations.isDeprecated(a.getFeature());
            if (_isDeprecated) {
                String _deprecationMessage = this.deprecationMessage(a.getFeature());
                String _plus = DEPRECATED_ANNOTATABLE_ELEMENT + _deprecationMessage;
                this.warning(_plus, (EObject)a, null);
            }
        };
        Iterables.filter(fc.getExpressions(), FeatureCall.class).forEach(_function);
    }

    protected String _deprecationMessage(AnnotatableElement it) {
        Literal msg;
        Expression expr;
        String _xblockexpression = null;
        Annotation annotation = it.getAnnotationOfType(DeprecatedAnnotations.DEPRECATED_ANNOTATION);
        if (annotation != null && annotation.getArguments().size() > 0 && (expr = ((Argument)annotation.getArguments().get(0)).getValue()) instanceof PrimitiveValueExpression && (msg = ((PrimitiveValueExpression)expr).getValue()) instanceof StringLiteral) {
            return ((StringLiteral)msg).getValue();
        }
        _xblockexpression = "";
        return _xblockexpression;
    }

    protected String _deprecationMessage(EObject it) {
        return "";
    }

    @Check(value=CheckType.FAST)
    public void checkOperationArguments_TypedElementReferenceExpression(ElementReferenceExpression call) {
        EObject _reference = call.getReference();
        if (_reference instanceof Operation) {
            EObject _reference_1 = call.getReference();
            Operation operation = (Operation)_reference_1;
            this.assertOperationArguments(operation, (List<Expression>)call.getExpressions());
        }
    }

    @Check(value=CheckType.FAST)
    public void checkAnnotationArguments(Annotation annotation) {
        this.assertOperationArguments((Operation)annotation.getType(), (List<Expression>)annotation.getExpressions());
        this.typeInferrer.infer((EObject)annotation, (IValidationIssueAcceptor)this);
    }

    protected void assertOperationArguments(Operation operation, List<Expression> args) {
        EList parameters = operation.getParameters();
        List<Parameter> optionalParameters = this.filterOptionalParameters((EList<Parameter>)parameters);
        if (operation.isVariadic() && operation.getVarArgIndex() > args.size() || !operation.isVariadic() && (args.size() > parameters.size() || args.size() < parameters.size() - optionalParameters.size())) {
            this.error(String.format(ERROR_WRONG_NUMBER_OF_ARGUMENTS_MSG, parameters), null, ERROR_WRONG_NUMBER_OF_ARGUMENTS_CODE, new String[0]);
        }
    }

    protected List<Parameter> filterOptionalParameters(EList<Parameter> parameters) {
        ArrayList<Parameter> optionalParameters = new ArrayList<Parameter>();
        for (Parameter p : parameters) {
            boolean _isOptional = p.isOptional();
            if (!_isOptional) continue;
            optionalParameters.add(p);
        }
        return optionalParameters;
    }

    protected AnnotatedElement annotatedElement(Annotation annotation) {
        Object _xblockexpression = null;
        EObject parent = annotation.eContainer();
        Object _xifexpression = null;
        if (parent instanceof AnnotatedElement) {
            return this.annotatedElement((AnnotatedElement)parent);
        }
        _xblockexpression = _xifexpression = null;
        return _xblockexpression;
    }

    protected AnnotatedElement annotatedElement(AnnotatedElement e) {
        boolean _tripleEquals;
        EClass _eClass = e.eClass();
        boolean bl = _tripleEquals = _eClass == TypesPackage.Literals.ANNOTATABLE_ELEMENT;
        if (_tripleEquals) {
            return this.annotatedElement(e.eContainer());
        }
        return e;
    }

    protected AnnotatedElement annotatedElement(EObject e) {
        AnnotatedElement _xifexpression = null;
        _xifexpression = e instanceof AnnotatedElement ? (AnnotatedElement)e : null;
        return _xifexpression;
    }

    @Check(value=CheckType.FAST)
    public void checkAnnotationTarget(Annotation annotation) {
        boolean _not;
        AnnotatedElement annotatedElement = this.annotatedElement(annotation);
        if (annotatedElement == null) {
            return;
        }
        EList targets = annotation.getType().getTargets();
        boolean _isEmpty = targets.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1 _function = c -> EPackage.Registry.INSTANCE.getEPackage(c.getEPackage().getNsURI()).getEClassifier(c.getName());
            Functions.Function1 _function_1 = it -> it.isInstance((Object)annotatedElement);
            boolean found = IterableExtensions.exists((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)targets, EClass.class), (Functions.Function1)_function), (Functions.Function1)_function_1);
            if (!found) {
                String _name = annotation.getType().getName();
                String _name_1 = annotatedElement.eClass().getName();
                StringConcatenation _builder = new StringConcatenation();
                Iterable _filter = Iterables.filter((Iterable)targets, ENamedElement.class);
                boolean _hasElements = false;
                for (ENamedElement t : _filter) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    _builder.append("'");
                    String _name_2 = t.getName();
                    _builder.append(_name_2);
                    _builder.append("'");
                }
                this.error(String.format(ERROR_WRONG_ANNOTATION_TARGET_MSG, _name, _name_1, _builder), (EObject)annotation, null, ERROR_WRONG_ANNOTATION_TARGET_CODE, new String[0]);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkValueDefinitionExpression(Property property) {
        boolean _not;
        boolean _isConst = property.isConst();
        boolean bl = _not = !_isConst;
        if (_not) {
            return;
        }
        Expression initialValue = property.getInitialValue();
        if (initialValue == null) {
            this.error(CONST_MUST_HAVE_VALUE_MSG, (EObject)property, null, CONST_MUST_HAVE_VALUE_CODE, new String[0]);
            return;
        }
        ArrayList toCheck = Lists.newArrayList((Object[])new Expression[]{initialValue});
        TreeIterator eAllContents = initialValue.eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!(next instanceof Expression)) continue;
            toCheck.add((Expression)next);
        }
        for (Expression expression : toCheck) {
            boolean _not_1;
            EObject referencedObject = null;
            if (expression instanceof FeatureCall) {
                referencedObject = ((FeatureCall)expression).getFeature();
            } else if (expression instanceof ElementReferenceExpression) {
                referencedObject = ((ElementReferenceExpression)expression).getReference();
            }
            if (!(referencedObject instanceof Property)) continue;
            boolean _isConst_1 = ((Property)referencedObject).isConst();
            boolean bl2 = _not_1 = !_isConst_1;
            if (!_not_1) continue;
            boolean _isAnyType = this.typeValidator.isAnyType(((Property)referencedObject).getType());
            if (_isAnyType) {
                return;
            }
            this.error(REFERENCE_TO_VARIABLE, (EStructuralFeature)TypesPackage.Literals.PROPERTY__INITIAL_VALUE);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkConstAndReadOnlyDefinitionExpression(Property definition) {
        if (!definition.isReadonly() && !definition.isConst()) {
            return;
        }
        ICompositeNode definitionNode = NodeModelUtils.getNode((EObject)definition);
        String tokenText = NodeModelUtils.getTokenText((INode)definitionNode);
        if (tokenText == null || tokenText.isEmpty()) {
            return;
        }
        if (tokenText.contains(TypesPackage.Literals.PROPERTY__READONLY.getName()) && tokenText.contains(TypesPackage.Literals.PROPERTY__CONST.getName())) {
            this.warning(String.format(DECLARATION_WITH_READONLY, TypesPackage.Literals.PROPERTY__READONLY.getName(), TypesPackage.Literals.PROPERTY__CONST.getName()), (EObject)definition, (EStructuralFeature)TypesPackage.Literals.PROPERTY__READONLY);
        }
    }

    @Check
    public void checkAssignmentExpression(AssignmentExpression exp) {
        Functions.Function1 _function = it -> {
            EObject _featureOrReference = this._expressionExtensions.featureOrReference(it.getVarRef());
            EObject _featureOrReference_1 = this._expressionExtensions.featureOrReference(exp.getVarRef());
            return Objects.equals(_featureOrReference, _featureOrReference_1);
        };
        boolean _exists = IteratorExtensions.exists((Iterator)Iterators.filter((Iterator)exp.eAllContents(), AssignmentExpression.class), (Functions.Function1)_function);
        if (_exists) {
            this.error(ASSIGNMENT_EXPRESSION, null);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkValueOfNoEvent(EventValueReferenceExpression exp) {
        EObject element = this._expressionExtensions.featureOrReference(exp.getValue());
        if (element != null && !(element instanceof Event)) {
            String msg = "Could not find event declaration.";
            if (element instanceof NamedElement) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("'");
                String _name = ((NamedElement)element).getName();
                _builder.append(_name);
                _builder.append("' is no event.");
                msg = _builder.toString();
            }
            this.error(msg, (EStructuralFeature)ExpressionsPackage.Literals.EVENT_VALUE_REFERENCE_EXPRESSION__VALUE, 0, VALUE_OF_REQUIRES_EVENT, new String[0]);
        }
    }

    @XbaseGenerated
    public String deprecationMessage(EObject it) {
        if (it instanceof AnnotatableElement) {
            return this._deprecationMessage((AnnotatableElement)it);
        }
        if (it != null) {
            return this._deprecationMessage(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

