/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.json.transformation.model.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.yakindu.sct.json.transformation.model.JsonCell;
import com.yakindu.sct.json.transformation.model.JsonGraph;
import com.yakindu.sct.json.transformation.model.JsonPosition;
import com.yakindu.sct.json.transformation.model.JsonSize;
import com.yakindu.sct.json.transformation.model.JsonTransition;
import com.yakindu.sct.json.transformation.model.JsonTransitionAnchor;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class NotationUtil {
    @Extension
    private NotationFactory _notationFactory = NotationFactory.eINSTANCE;

    public Bounds toRelativeBounds(JsonGraph graph, JsonCell cell) {
        JsonPosition _jsonPosition;
        Bounds _xblockexpression = null;
        JsonPosition _elvis = null;
        JsonCell _findParent = graph.findParent(cell);
        JsonPosition _position = null;
        if (_findParent != null) {
            _position = _findParent.getPosition();
        }
        _elvis = _position != null ? _position : (_jsonPosition = new JsonPosition());
        JsonPosition offset = _elvis;
        Bounds _createBounds = this._notationFactory.createBounds();
        Procedures.Procedure1 _function = it -> {
            JsonSize _size;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            JsonPosition _position_1 = cell.getPosition();
            boolean bl = _tripleNotEquals = _position_1 != null;
            if (_tripleNotEquals) {
                double _x = cell.getPosition().getX();
                double _x_1 = offset.getX();
                int _minus = (int)_x - (int)_x_1;
                it.setX(_minus);
                double _y = cell.getPosition().getY();
                double _y_1 = offset.getY();
                int _minus_1 = (int)_y - (int)_y_1;
                int _minus_2 = _minus_1 - 20;
                it.setY(_minus_2);
            }
            boolean bl2 = _tripleNotEquals_1 = (_size = cell.getSize()) != null;
            if (_tripleNotEquals_1) {
                double _width = cell.getSize().getWidth();
                it.setWidth((int)_width);
                double _height = cell.getSize().getHeight();
                it.setHeight((int)_height);
            }
        };
        _xblockexpression = (Bounds)ObjectExtensions.operator_doubleArrow((Object)_createBounds, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    public void setBounds(JsonCell cell, Node view, JsonGraph graph) {
        LayoutConstraint _layoutConstraint_1;
        boolean _not;
        boolean _tripleEquals;
        boolean _or = false;
        LayoutConstraint _layoutConstraint = null;
        if (view != null) {
            _layoutConstraint = view.getLayoutConstraint();
        }
        boolean bl = _tripleEquals = _layoutConstraint == null;
        _or = _tripleEquals ? true : (_not = !((_layoutConstraint_1 = view.getLayoutConstraint()) instanceof Bounds));
        if (_or) {
            return;
        }
        LayoutConstraint _layoutConstraint_2 = view.getLayoutConstraint();
        Bounds notationBounds = (Bounds)_layoutConstraint_2;
        JsonPosition _jsonPosition = new JsonPosition();
        Procedures.Procedure1 _function = it -> {
            it.setX(notationBounds.getX());
            it.setY(notationBounds.getY());
        };
        JsonPosition _doubleArrow = (JsonPosition)ObjectExtensions.operator_doubleArrow((Object)_jsonPosition, (Procedures.Procedure1)_function);
        cell.setPosition(_doubleArrow);
        JsonPosition _elvis = null;
        JsonCell _findParent = graph.findParent(cell);
        JsonPosition _position = null;
        if (_findParent != null) {
            _position = _findParent.getPosition();
        }
        _elvis = _position != null ? _position : JsonPosition.EMPTY;
        JsonPosition parentPosition = _elvis;
        cell.getPosition().shift(parentPosition);
        if (notationBounds.getWidth() < 0 || notationBounds.getHeight() < 0) {
            cell.setSize(null);
        } else {
            JsonSize _jsonSize = new JsonSize();
            Procedures.Procedure1 _function_1 = it -> {
                it.setWidth(notationBounds.getWidth());
                it.setHeight(notationBounds.getHeight());
            };
            JsonSize _doubleArrow_1 = (JsonSize)ObjectExtensions.operator_doubleArrow((Object)_jsonSize, (Procedures.Procedure1)_function_1);
            cell.setSize(_doubleArrow_1);
        }
    }

    public IdentityAnchor createAnchor(JsonTransitionAnchor it) {
        IdentityAnchor _xblockexpression = null;
        Object _get = it.getArgs().get("dx");
        String dxRaw = String.valueOf(_get);
        Object _get_1 = it.getArgs().get("dy");
        String dyRaw = String.valueOf(_get_1);
        Double dx = this.convertPercent(dxRaw);
        Double dy = this.convertPercent(dyRaw);
        IdentityAnchor _createIdentityAnchor = this._notationFactory.createIdentityAnchor();
        Procedures.Procedure1 _function = it_1 -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(");
            _builder.append((Object)dx);
            _builder.append(",");
            _builder.append((Object)dy);
            _builder.append(")");
            it_1.setId(_builder.toString());
        };
        _xblockexpression = (IdentityAnchor)ObjectExtensions.operator_doubleArrow((Object)_createIdentityAnchor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected Double convertPercent(String value) {
        boolean _endsWith = value.endsWith("%");
        if (_endsWith) {
            int _length = value.length();
            int _minus = _length - 1;
            Double _valueOf = Double.valueOf(value.substring(0, _minus));
            return _valueOf / 100.0;
        }
        return Double.valueOf(value);
    }

    public Node findNotationView(EObject semanticElement, Diagram diagram, String type) {
        Functions.Function1 _function = it -> Objects.equals(it.getType(), type) && EcoreUtil.equals((EObject)it.getElement(), (EObject)semanticElement);
        return (Node)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), Node.class), (Functions.Function1)_function);
    }

    public Edge findNotationEdge(EObject semanticElement, Diagram diagram, String type) {
        Functions.Function1 _function = it -> Objects.equals(it.getType(), type) && EcoreUtil.equals((EObject)it.getElement(), (EObject)semanticElement);
        return (Edge)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), Edge.class), (Functions.Function1)_function);
    }

    public List<JsonPosition> transformRelativeBendpoints(Edge edge, JsonCell source) {
        boolean _lessThan;
        boolean _not;
        List _xblockexpression = null;
        Bendpoints _bendpoints = edge.getBendpoints();
        boolean bl = _not = !(_bendpoints instanceof RelativeBendpoints);
        if (_not) {
            return CollectionLiterals.newArrayList();
        }
        Bendpoints _bendpoints_1 = edge.getBendpoints();
        List bendpoints = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)((RelativeBendpoints)_bendpoints_1).getPoints(), RelativeBendpoint.class));
        int _size = bendpoints.size();
        boolean bl2 = _lessThan = _size < 2;
        if (_lessThan) {
            return CollectionLiterals.newArrayList();
        }
        int _size_1 = bendpoints.size();
        int _minus = _size_1 - 1;
        Functions.Function1 _function = rp -> {
            JsonPosition _jsonPosition = new JsonPosition();
            Procedures.Procedure1 _function_1 = it -> {
                double _x = source.getPosition().getX();
                int _sourceX = rp.getSourceX();
                double _plus = _x + (double)_sourceX;
                it.setX(_plus);
                double _y = source.getPosition().getY();
                int _sourceY = rp.getSourceY();
                double _plus_1 = _y + (double)_sourceY;
                it.setY(_plus_1);
            };
            return (JsonPosition)ObjectExtensions.operator_doubleArrow((Object)_jsonPosition, (Procedures.Procedure1)_function_1);
        };
        _xblockexpression = IterableExtensions.toList((Iterable)ListExtensions.map(bendpoints.subList(1, _minus), (Functions.Function1)_function));
        return _xblockexpression;
    }

    public Location createLabelPosition(JsonTransition transition) {
        Location _createLocation = this._notationFactory.createLocation();
        Procedures.Procedure1 _function = it -> {
            it.setX(10);
            it.setY(10);
        };
        return (Location)ObjectExtensions.operator_doubleArrow((Object)_createLocation, (Procedures.Procedure1)_function);
    }
}

