/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal;

import com.xformation.lmx.LmxFeatureInfo;
import com.xformation.lmx.LmxLicenseInfo;
import com.xformation.lmx.LmxStatus;
import com.yakindu.licmgmt.IEclipseLicenseManager;
import com.yakindu.licmgmt.IEclipseLicenseService;
import com.yakindu.licmgmt.ILicenseChangedListener;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.LicenseException;
import com.yakindu.licmgmt.LicenseStatus;
import com.yakindu.licmgmt.internal.EclipseLicenseService;
import com.yakindu.licmgmt.internal.LicenseManager;
import com.yakindu.licmgmt.internal.utils.EclipsePathUtils;
import com.yakindu.licmgmt.internal.utils.JarSignatureVerifier;
import com.yakindu.licmgmt.internal.utils.LicenseExceptionHelper;
import com.yakindu.licmgmt.internal.utils.PathUtils;
import com.yakindu.licmgmt.utils.LicenseUtils;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.Platform;

public class EclipseLicenseManager
implements IEclipseLicenseManager {
    private static boolean jarValidated = false;
    private final LicenseManager licenseManager;

    public EclipseLicenseManager(String featureId, String featureVersion, List<String> additionalLicensePaths) throws LicenseException {
        List licensePaths = PathUtils.appendAdditionalPath(additionalLicensePaths, (String)EclipsePathUtils.getEclipsePath());
        if (Platform.isRunning() && !Platform.inDevelopmentMode() && !jarValidated) {
            this.verifyBundleSignature();
            jarValidated = true;
        }
        this.licenseManager = (LicenseManager)ILicenseService.INSTANCE.getLicenseManager(featureId, featureVersion, licensePaths);
        this.initEnabledState();
    }

    private void initEnabledState() {
        boolean enabled = ((EclipseLicenseService)IEclipseLicenseService.INSTANCE).getSettings().isLicenseEnabled(this.getFeatureId());
        this.licenseManager.setEnabled(enabled);
    }

    public ILicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    private void verifyBundleSignature() throws LicenseException {
        JarSignatureVerifier verifier = null;
        try {
            File bundleLocation = LicenseUtils.getBundleLocation("com.yakindu.licmgmt.eclipse");
            verifier = new JarSignatureVerifier(bundleLocation);
        }
        catch (Exception e) {
            LicenseExceptionHelper.throwLicenseException(e.getMessage(), true, true);
        }
        if (!verifier.isSigned()) {
            LicenseExceptionHelper.throwLicenseException("Verification error, Signature is unsigend", true, true);
        }
    }

    public LmxStatus acquire() {
        return this.licenseManager.acquire();
    }

    public LmxFeatureInfo getFeatureInfo() {
        return this.licenseManager.getFeatureInfo();
    }

    public List<LmxLicenseInfo> getLicenseInfos() {
        return this.licenseManager.getLicenseInfos();
    }

    public LmxStatus release() {
        return this.licenseManager.release();
    }

    public int getExpireTime() {
        return this.licenseManager.getExpireTime();
    }

    public String getFeatureId() {
        return this.licenseManager.getFeatureId();
    }

    public boolean isCheckedOut() {
        return this.licenseManager.isCheckedOut();
    }

    public boolean isBorrowed() {
        return this.licenseManager.isBorrowed();
    }

    public boolean isEnabled() {
        return this.licenseManager.isEnabled();
    }

    public String getFeatureVersion() {
        return this.licenseManager.getFeatureVersion();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ":" + this.licenseManager.toString();
    }

    public LmxStatus borrow(int hoursToBorrow) {
        return this.licenseManager.borrow(hoursToBorrow);
    }

    public LmxStatus unborrow() {
        return this.licenseManager.unborrow();
    }

    public LmxStatus unborrowAndRelease() {
        return this.licenseManager.unborrowAndRelease();
    }

    public LmxStatus updateLicense(boolean notifyListeners) {
        return this.licenseManager.updateLicense(notifyListeners);
    }

    public boolean addListener(ILicenseChangedListener licenseChangedListener) {
        return this.licenseManager.addListener(licenseChangedListener);
    }

    public boolean removeListener(ILicenseChangedListener listener) {
        if (listener != null) {
            return this.licenseManager.removeListener(listener);
        }
        return false;
    }

    public String getStatusMessage() {
        return this.licenseManager.getStatusMessage();
    }

    public LicenseStatus getLicenseStatus() {
        return this.licenseManager.getLicenseStatus();
    }

    public boolean isTrial() {
        return this.licenseManager.isTrial();
    }

    public boolean isAcquireRequested() {
        return this.licenseManager.isAcquireRequested();
    }
}

